/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.transport;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.net.transport.ModbusTransportASCII;
import com.invertor.modbus.net.transport.ModbusTransportRTU;
import com.invertor.modbus.net.transport.ModbusTransportTCP;
import com.invertor.modbus.serial.SerialPort;
import java.net.Socket;

public class ModbusTransportFactory {
    public static ModbusTransport createRTU(SerialPort serial) {
        return new ModbusTransportRTU(serial);
    }

    public static ModbusTransport createASCII(SerialPort serial) {
        return new ModbusTransportASCII(serial);
    }

    public static ModbusTransport createTCP(Socket socket) {
        try {
            return new ModbusTransportTCP(socket);
        }
        catch (Exception e) {
            Modbus.log().severe(e.getLocalizedMessage());
            return null;
        }
    }
}

