/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.transport;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.ModbusMessageFactory;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.net.stream.InputStreamSerial;
import com.invertor.modbus.net.stream.OutputStreamSerial;
import com.invertor.modbus.net.stream.base.LoggingInputStream;
import com.invertor.modbus.net.transport.ModbusTransport;
import java.io.IOException;

class ModbusTransportSerial
extends ModbusTransport {
    ModbusTransportSerial(InputStreamSerial is, OutputStreamSerial os) {
        super(is, os);
    }

    @Override
    protected ModbusMessage read(ModbusMessageFactory factory) throws ModbusIOException, ModbusNumberException {
        ModbusMessage msg;
        LoggingInputStream is = this.getInputStream();
        if (!(is instanceof InputStreamSerial)) {
            throw new ModbusIOException("Can't cast getInputStream() to InputStreamSerial");
        }
        InputStreamSerial iss = (InputStreamSerial)is;
        try {
            iss.frameInit();
            msg = factory.createMessage(iss);
            iss.frameCheck();
        }
        catch (IOException ioe) {
            throw new ModbusIOException(ioe);
        }
        return msg;
    }

    @Override
    protected void sendImpl(ModbusMessage msg) throws ModbusIOException {
        msg.write(this.getOutputStream());
    }
}

