/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.net.transport;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.msg.ModbusMessageFactory;
import com.invertor.modbus.msg.base.ModbusMessage;
import com.invertor.modbus.net.stream.InputStreamTCP;
import com.invertor.modbus.net.stream.OutputStreamTCP;
import com.invertor.modbus.net.stream.base.LoggingInputStream;
import com.invertor.modbus.net.stream.base.LoggingOutputStream;
import com.invertor.modbus.net.transport.ModbusTransport;
import com.invertor.modbus.tcp.TcpAduHeader;
import java.io.IOException;
import java.net.Socket;

class ModbusTransportTCP
extends ModbusTransport {
    ModbusTransportTCP(Socket socket) throws ModbusIOException, IOException {
        super(new InputStreamTCP(socket), new OutputStreamTCP(socket));
    }

    @Override
    protected ModbusMessage read(ModbusMessageFactory factory) throws ModbusNumberException, ModbusIOException {
        LoggingInputStream is = this.getInputStream();
        TcpAduHeader header = new TcpAduHeader();
        header.read(is);
        ModbusMessage msg = factory.createMessage(is);
        msg.setTransactionId(header.getTransactionId());
        msg.setProtocolId(header.getProtocolId());
        return msg;
    }

    @Override
    public void sendImpl(ModbusMessage msg) throws ModbusIOException {
        LoggingOutputStream os = this.getOutputStream();
        TcpAduHeader header = new TcpAduHeader();
        header.setProtocolId(msg.getProtocolId());
        header.setTransactionId(msg.getTransactionId());
        header.setPduSize(msg.size());
        header.write(os);
        msg.write(os);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

