/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.serial;

import com.invertor.modbus.Modbus;
import com.invertor.modbus.net.stream.InputStreamTCP;
import com.invertor.modbus.net.stream.OutputStreamTCP;
import com.invertor.modbus.serial.SerialParameters;
import com.invertor.modbus.serial.SerialPort;
import com.invertor.modbus.serial.SerialPortAbstractFactory;
import com.invertor.modbus.serial.SerialPortException;
import com.invertor.modbus.tcp.TcpParameters;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.List;

public class SerialPortFactoryTcp
implements SerialPortAbstractFactory {
    private TcpParameters tcpParameters;

    public SerialPortFactoryTcp(TcpParameters tcpParameters) {
        this.setTcpParameters(tcpParameters);
    }

    public TcpParameters getTcpParameters() {
        return this.tcpParameters;
    }

    public void setTcpParameters(TcpParameters tcpParameters) {
        this.tcpParameters = tcpParameters;
    }

    @Override
    public SerialPort createSerial(SerialParameters sp) throws SerialPortException {
        return new SerialPortViaTCP(sp);
    }

    @Override
    public List<String> getPortIdentifiers() {
        return new LinkedList<String>();
    }

    private class SerialPortViaTCP
    extends SerialPort {
        private Socket socket;
        private InputStreamTCP is;
        private OutputStreamTCP os;

        public SerialPortViaTCP(SerialParameters sp) throws SerialPortException {
            super(sp);
        }

        @Override
        public void open() throws SerialPortException {
            TcpParameters parameters = SerialPortFactoryTcp.this.getTcpParameters();
            if (parameters != null) {
                this.close();
                this.socket = new Socket();
                InetSocketAddress isa = new InetSocketAddress(parameters.getHost(), parameters.getPort());
                try {
                    this.socket.connect(isa, 3000);
                    this.socket.setKeepAlive(parameters.isKeepAlive());
                    this.socket.setSoTimeout(this.getReadTimeout());
                    this.is = new InputStreamTCP(this.socket);
                    this.os = new OutputStreamTCP(this.socket);
                }
                catch (SocketException e) {
                    throw new SerialPortException(e);
                }
                catch (IOException e) {
                    throw new SerialPortException(e);
                }
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (!this.isOpened()) {
                throw new IOException("Port not opened");
            }
            this.os.write(b);
            this.os.flush();
        }

        @Override
        public void write(int b) throws IOException {
            if (!this.isOpened()) {
                throw new IOException("Port not opened");
            }
            this.os.write(b);
            this.os.flush();
        }

        @Override
        public int read() throws IOException {
            if (this.isOpened()) {
                return this.is.read();
            }
            throw new IOException("Port not opened");
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.isOpened()) {
                return this.is.read(b, off, len);
            }
            throw new IOException("Port not opened");
        }

        @Override
        public void close() {
            try {
                try {
                    if (this.isOpened()) {
                        this.is.close();
                        this.os.close();
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    Modbus.log().warning("Unable to close port: " + e.getLocalizedMessage());
                    this.is = null;
                    this.os = null;
                    this.socket = null;
                }
            }
            finally {
                this.is = null;
                this.os = null;
                this.socket = null;
            }
        }

        @Override
        public void setReadTimeout(int readTimeout) {
            super.setReadTimeout(readTimeout);
            if (this.isOpened()) {
                try {
                    this.socket.setSoTimeout(readTimeout);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                    Modbus.log().warning("Unable to set readTimeout: " + e.getLocalizedMessage());
                }
            }
        }

        @Override
        public boolean isOpened() {
            return this.socket != null && this.socket.isConnected() && this.os != null && this.is != null;
        }
    }
}

