/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.tcp;

import com.invertor.modbus.exception.ModbusIOException;
import com.invertor.modbus.exception.ModbusNumberException;
import com.invertor.modbus.net.stream.base.ModbusInputStream;
import com.invertor.modbus.net.stream.base.ModbusOutputStream;
import com.invertor.modbus.utils.DataUtils;
import java.io.IOException;

public final class TcpAduHeader {
    private final byte[] buffer = new byte[6];

    public TcpAduHeader() {
        this.setProtocolId(0);
    }

    private void setBufferValue(int value, int offset) {
        this.buffer[offset++] = DataUtils.byteHigh(value);
        this.buffer[offset] = DataUtils.byteLow(value);
    }

    private int getPduSize() {
        return DataUtils.toShort(this.buffer[4], this.buffer[5]);
    }

    public void setPduSize(int value) {
        this.setBufferValue(value, 4);
    }

    public int getProtocolId() {
        return DataUtils.toShort(this.buffer[2], this.buffer[3]);
    }

    public void setProtocolId(int value) {
        this.setBufferValue(value, 2);
    }

    public int getTransactionId() {
        return DataUtils.toShort(this.buffer[0], this.buffer[1]);
    }

    public void setTransactionId(int value) {
        this.setBufferValue(value, 0);
    }

    private byte[] byteArray() {
        return this.buffer;
    }

    public void write(ModbusOutputStream fifo) throws ModbusIOException {
        try {
            fifo.write(this.byteArray());
        }
        catch (IOException e) {
            throw new ModbusIOException(e);
        }
    }

    public void read(ModbusInputStream fifo) throws ModbusNumberException, ModbusIOException {
        block5: {
            try {
                int size = fifo.read(this.byteArray());
                if (size > 0) {
                    if (this.getPduSize() < 3) {
                        throw new ModbusNumberException("the PDU length is less than the minimum expected.", this.getPduSize());
                    }
                    if (this.getPduSize() > 254) {
                        throw new ModbusNumberException("Maximum PDU size is reached.", this.getPduSize());
                    }
                    break block5;
                }
                throw new ModbusIOException(String.valueOf(this.buffer.length) + " bytes expected, but " + size + " received.");
            }
            catch (IOException e) {
                throw new ModbusIOException(e);
            }
        }
    }
}

