/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.utils;

public enum MEITypeCode {
    CAN_OPEN_PDU(13),
    READ_DEVICE_IDENTIFICATION(14),
    RESERVED(255);

    private final int value;

    private MEITypeCode(int value) {
        this.value = value;
    }

    public static MEITypeCode get(int value) {
        MEITypeCode[] mEITypeCodeArray = MEITypeCode.values();
        int n = mEITypeCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MEITypeCode func = mEITypeCodeArray[n2];
            if (func.value == value) {
                return func;
            }
            ++n2;
        }
        return RESERVED;
    }

    public int toInt() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

