/*
 * Decompiled with CFR 0.152.
 */
package com.invertor.modbus.utils;

public enum ModbusExceptionCode {
    ILLEGAL_FUNCTION(1),
    ILLEGAL_DATA_ADDRESS(2),
    ILLEGAL_DATA_VALUE(3),
    SLAVE_DEVICE_FAILURE(4),
    ACKNOWLEDGE(5),
    SLAVE_DEVICE_BUSY(6),
    MEMORY_PARITY_ERROR(8),
    GATEWAY_PATH_UNAVAILABLE(10),
    GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND(11),
    UNKNOWN_EXCEPTION(256),
    NO_EXCEPTION(257);

    private final int value;

    private ModbusExceptionCode(int value) {
        this.value = value;
    }

    public static ModbusExceptionCode get(int value) {
        ModbusExceptionCode[] modbusExceptionCodeArray = ModbusExceptionCode.values();
        int n = modbusExceptionCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModbusExceptionCode type = modbusExceptionCodeArray[n2];
            if (type.value == value) {
                return type;
            }
            ++n2;
        }
        return UNKNOWN_EXCEPTION;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.name()) + ": Exception Code = " + this.value;
    }
}

