/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.modbus.jlibmodbus;

import de.elpro.ewms.server.datasource.modbus.jlibmodbus.RegisterOrder;
import java.nio.ByteBuffer;

public class ModbusDataConverter {
    public static short ConvertRegistersToByte(int[] registers) throws IllegalArgumentException {
        if (registers.length != 1) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        byte[] registerBytes = ModbusDataConverter.toByteArray(registers[0]);
        return registerBytes[0];
    }

    public static short ConvertRegistersToShort(int[] registers) throws IllegalArgumentException {
        if (registers.length != 1) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        return (short)registers[0];
    }

    public static float ConvertRegistersToFloat(int[] registers) throws IllegalArgumentException {
        if (registers.length != 2) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int highRegister = registers[1];
        int lowRegister = registers[0];
        byte[] highRegisterBytes = ModbusDataConverter.toByteArray(highRegister);
        byte[] lowRegisterBytes = ModbusDataConverter.toByteArray(lowRegister);
        byte[] floatBytes = new byte[]{highRegisterBytes[1], highRegisterBytes[0], lowRegisterBytes[1], lowRegisterBytes[0]};
        return ByteBuffer.wrap(floatBytes).getFloat();
    }

    public static float ConvertRegistersToFloat(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        int[] swappedRegisters = new int[]{registers[0], registers[1]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[1], registers[0]};
        }
        return ModbusDataConverter.ConvertRegistersToFloat(swappedRegisters);
    }

    public static int ConvertRegistersToInt32(int[] registers) throws IllegalArgumentException {
        if (registers.length != 2) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int highRegister = registers[1];
        int lowRegister = registers[0];
        byte[] highRegisterBytes = ModbusDataConverter.toByteArray(highRegister);
        byte[] lowRegisterBytes = ModbusDataConverter.toByteArray(lowRegister);
        byte[] int32Bytes = new byte[]{highRegisterBytes[1], highRegisterBytes[0], lowRegisterBytes[1], lowRegisterBytes[0]};
        return ByteBuffer.wrap(int32Bytes).getInt();
    }

    public static int ConvertRegistersToInt32(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        int[] swappedRegisters = new int[]{registers[0], registers[1]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[1], registers[0]};
        }
        return ModbusDataConverter.ConvertRegistersToInt32(swappedRegisters);
    }

    public static double ConvertRegistersToDouble(int[] registers) throws IllegalArgumentException {
        if (registers.length != 4) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int highHighRegister = registers[3];
        int lowHighRegister = registers[2];
        int highLowRegister = registers[1];
        int lowLowRegister = registers[0];
        byte[] highHighRegisterBytes = ModbusDataConverter.toByteArray(highHighRegister);
        byte[] lowHighRegisterBytes = ModbusDataConverter.toByteArray(lowHighRegister);
        byte[] highLowRegisterBytes = ModbusDataConverter.toByteArray(highLowRegister);
        byte[] lowLowRegisterBytes = ModbusDataConverter.toByteArray(lowLowRegister);
        byte[] floatBytes = new byte[]{highHighRegisterBytes[1], highHighRegisterBytes[0], lowHighRegisterBytes[1], lowHighRegisterBytes[0], highLowRegisterBytes[1], highLowRegisterBytes[0], lowLowRegisterBytes[1], lowLowRegisterBytes[0]};
        return ByteBuffer.wrap(floatBytes).getFloat();
    }

    public static double ConvertRegistersToDouble(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        int[] swappedRegisters = new int[]{registers[0], registers[1], registers[2], registers[3]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[1], registers[0], registers[3], registers[2]};
        }
        return ModbusDataConverter.ConvertRegistersToDouble(swappedRegisters);
    }

    public static long ConvertRegistersToInt64(int[] registers) throws IllegalArgumentException {
        if (registers.length != 4) {
            throw new IllegalArgumentException("Input Array length invalid");
        }
        int highHighRegister = registers[3];
        int lowHighRegister = registers[2];
        int highLowRegister = registers[1];
        int lowLowRegister = registers[0];
        byte[] highHighRegisterBytes = ModbusDataConverter.toByteArray(highHighRegister);
        byte[] lowHighRegisterBytes = ModbusDataConverter.toByteArray(lowHighRegister);
        byte[] highLowRegisterBytes = ModbusDataConverter.toByteArray(highLowRegister);
        byte[] lowLowRegisterBytes = ModbusDataConverter.toByteArray(lowLowRegister);
        byte[] floatBytes = new byte[]{highHighRegisterBytes[1], highHighRegisterBytes[0], lowHighRegisterBytes[1], lowHighRegisterBytes[0], highLowRegisterBytes[1], highLowRegisterBytes[0], lowLowRegisterBytes[1], lowLowRegisterBytes[0]};
        return ByteBuffer.wrap(floatBytes).getLong();
    }

    public static long ConvertRegistersToInt64(int[] registers, RegisterOrder registerOrder) throws IllegalArgumentException {
        int[] swappedRegisters = new int[]{registers[0], registers[1], registers[2], registers[3]};
        if (registerOrder == RegisterOrder.HighLow) {
            swappedRegisters = new int[]{registers[1], registers[0], registers[3], registers[2]};
        }
        return ModbusDataConverter.ConvertRegistersToInt64(swappedRegisters);
    }

    public static int[] ConvertFloatToTwoRegisters(float floatValue) {
        byte[] floatBytes = ModbusDataConverter.toByteArray(floatValue);
        byte[] byArray = new byte[4];
        byArray[2] = floatBytes[0];
        byArray[3] = floatBytes[1];
        byte[] highRegisterBytes = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[2] = floatBytes[2];
        byArray2[3] = floatBytes[3];
        byte[] lowRegisterBytes = byArray2;
        int[] returnValue = new int[]{ByteBuffer.wrap(lowRegisterBytes).getInt(), ByteBuffer.wrap(highRegisterBytes).getInt()};
        return returnValue;
    }

    public static int[] ConvertFloatToTwoRegisters(float floatValue, RegisterOrder registerOrder) {
        int[] registerValues;
        int[] returnValue = registerValues = ModbusDataConverter.ConvertFloatToTwoRegisters(floatValue);
        if (registerOrder == RegisterOrder.HighLow) {
            returnValue = new int[]{registerValues[1], registerValues[0]};
        }
        return returnValue;
    }

    public static int[] ConvertInt32ToTwoRegisters(int intValue) {
        byte[] doubleBytes = ModbusDataConverter.toByteArrayDouble(intValue);
        byte[] byArray = new byte[4];
        byArray[2] = doubleBytes[0];
        byArray[3] = doubleBytes[1];
        byte[] highRegisterBytes = byArray;
        byte[] byArray2 = new byte[4];
        byArray2[2] = doubleBytes[2];
        byArray2[3] = doubleBytes[3];
        byte[] lowRegisterBytes = byArray2;
        int[] returnValue = new int[]{ByteBuffer.wrap(lowRegisterBytes).getInt(), ByteBuffer.wrap(highRegisterBytes).getInt()};
        return returnValue;
    }

    public static int[] ConvertInt32ToTwoRegisters(int intValue, RegisterOrder registerOrder) {
        int[] registerValues;
        int[] returnValue = registerValues = ModbusDataConverter.ConvertFloatToTwoRegisters(intValue);
        if (registerOrder == RegisterOrder.HighLow) {
            returnValue = new int[]{registerValues[1], registerValues[0]};
        }
        return returnValue;
    }

    public static byte[] toByteArray(int value) {
        byte[] result = new byte[2];
        result[1] = (byte)(value >> 8);
        result[0] = (byte)value;
        return result;
    }

    public static byte[] toByteArrayDouble(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    public static byte[] toByteArray(float value) {
        return ByteBuffer.allocate(4).putFloat(value).array();
    }
}

