/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.modbus.jlibmodbus;

import com.google.common.base.Converter;
import com.google.common.collect.Table;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.invertor.modbus.Modbus;
import com.invertor.modbus.ModbusMaster;
import com.invertor.modbus.ModbusMasterFactory;
import com.invertor.modbus.tcp.TcpParameters;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.IdentifierType;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.SignalStatusCode;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.modbus.jlibmodbus.MBParameters;
import de.elpro.ewms.server.datasource.modbus.jlibmodbus.ModbusDataConverter;
import de.elpro.ewms.server.datasource.modbus.jlibmodbus.ModbusDataTypes;
import de.elpro.ewms.server.datasource.modbus.jlibmodbus.bundle.Activator;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.fx.core.log.Logger;

public class ProcessInterface
implements IProcessInterface<MBParameters> {
    private static final Logger logger = Activator.loggerFactory.createLogger(ProcessInterface.class.getName());
    private final IDataSource dataSource;
    private static final int modbusUnitNr = 1;
    ModbusMaster modbusMaster;
    TcpParameters tcpParameters;
    String hostIdentifier;
    private Converter<SignalId, MBParameters> converter = new Converter<SignalId, MBParameters>(){

        protected MBParameters doForward(SignalId signalId) {
            MBParameters mbPara = new MBParameters();
            mbPara.setServerAddress(1);
            try {
                Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
                mbPara = (MBParameters)gson.fromJson(signalId.getIdentifier(), MBParameters.class);
                switch (mbPara.getDataType()) {
                    case Byte: 
                    case Register: {
                        mbPara.setRegisterCount(1);
                        break;
                    }
                    case Int32: 
                    case Float: {
                        mbPara.setRegisterCount(2);
                        break;
                    }
                    case Int64: 
                    case Double: {
                        mbPara.setRegisterCount(4);
                    }
                }
                mbPara.setName(ProcessInterface.this.tcpParameters.getHost().getHostAddress());
                mbPara.setPortNumber(ProcessInterface.this.tcpParameters.getPort());
            }
            catch (Exception exception) {
                return null;
            }
            return mbPara;
        }

        protected SignalId doBackward(MBParameters mbPara) {
            Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
            String p1 = "";
            String p2 = gson.toJson((Object)mbPara);
            return new SignalId(p1, p2, IdentifierType.String);
        }
    };

    public ProcessInterface(IDataSource dataSource) {
        this.dataSource = dataSource;
        try {
            boolean useIpAddr = dataSource.getHostIpAddr() != null && !dataSource.getHostIpAddr().isEmpty();
            this.hostIdentifier = useIpAddr ? dataSource.getHostIpAddr() : dataSource.getHostName();
            Modbus.setAutoIncrementTransactionId(true);
        }
        catch (Exception exc) {
            logger.error("Error occured during creation of process interface", (Throwable)exc);
        }
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public synchronized OperationResult doConnect() {
        try {
            this.tcpParameters = new TcpParameters(InetAddress.getByName(this.hostIdentifier), (int)this.dataSource.getHostPortNr(), true);
            this.modbusMaster = ModbusMasterFactory.createModbusMasterTCP(this.tcpParameters);
            this.modbusMaster.connect();
            String message = String.format("Connection to Modbus-host %s port %d established.", this.tcpParameters.getHost().getHostAddress(), this.tcpParameters.getPort());
            logger.info(message);
            return OperationResult.SUCCESS;
        }
        catch (Exception ex) {
            String message = String.format("Can't open connection to Modbus-host %s port %d", this.tcpParameters.getHost().getHostAddress(), this.tcpParameters.getPort());
            logger.error(message, (Throwable)ex);
            return new OperationResult((Serializable)((Object)message), ResultType.UnexprectedError);
        }
    }

    public synchronized void doDisconnect() {
        if (this.modbusMaster != null && this.modbusMaster.isConnected()) {
            try {
                do {
                    this.modbusMaster.disconnect();
                } while (this.modbusMaster.isConnected());
                logger.info(String.format("Connection to Modbus-host %s port %d closed.", this.tcpParameters.getHost().getHostAddress(), this.tcpParameters.getPort()));
            }
            catch (Exception ex) {
                logger.error(String.format("Can't close connection to Modbus-host %s port %d", this.tcpParameters.getHost().getHostAddress(), this.tcpParameters.getPort()), (Throwable)ex);
            }
        }
    }

    public synchronized DataClientState getState() {
        if (this.modbusMaster == null) {
            return DataClientState.New;
        }
        return this.modbusMaster.isConnected() ? DataClientState.Connected : DataClientState.Disconnected;
    }

    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException {
        return null;
    }

    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        return null;
    }

    public SignalDataValue getCurrentValue(SignalId signalId) throws ExecutionException {
        MBParameters mbPara = (MBParameters)this.getSignalConverter().convert((Object)signalId);
        MeasuredValue mv = null;
        if (this.getState() == DataClientState.Connected) {
            try {
                if (mbPara.getFunctionCode() != null && this.modbusMaster.isConnected()) {
                    switch (mbPara.getFunctionCode()) {
                        case 1: {
                            boolean[] bools = this.modbusMaster.readCoils(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                            long now = Instant.now(null).toEpochMilli();
                            mv = new MeasuredValue(now, now, bools[0] ? 1.0 : 0.0, 1.0);
                            break;
                        }
                        case 2: {
                            boolean[] bools = this.modbusMaster.readDiscreteInputs(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                            long now = Instant.now(null).toEpochMilli();
                            mv = new MeasuredValue(now, now, bools[0] ? 1.0 : 0.0, 1.0);
                            break;
                        }
                        case 3: {
                            int[] ints;
                            int[] nArray = ints = this.modbusMaster.readHoldingRegisters(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                            int n = ints.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int iv = nArray[n2];
                                long now = Instant.now(null).toEpochMilli();
                                mv = new MeasuredValue(now, now, (double)Integer.valueOf(iv).intValue() / mbPara.getScale(), 1.0);
                                ++n2;
                            }
                            break;
                        }
                        case 4: {
                            int[] ints;
                            int[] nArray = ints = this.modbusMaster.readInputRegisters(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                            int n = ints.length;
                            int n3 = 0;
                            while (n3 < n) {
                                int iv = nArray[n3];
                                long now = Instant.now(null).toEpochMilli();
                                mv = new MeasuredValue(now, now, (double)Integer.valueOf(iv).intValue() / mbPara.getScale(), 1.0);
                                ++n3;
                            }
                            break;
                        }
                    }
                }
                return new SignalDataValue((Object)mv.getValue(), SignalStatusCode.GOOD, Instant.ofEpochMilli(mv.getStartTimestamp()), Instant.ofEpochMilli(mv.getStartTimestamp()));
            }
            catch (Exception e) {
                logger.error("Error occured during reading current value", (Throwable)e);
            }
        }
        return null;
    }

    public Converter<SignalId, MBParameters> getSignalConverter() {
        return this.converter;
    }

    public Map<MBParameters, List<MeasuredValue>> readValues(DataGroup group, Set<MBParameters> toolboxNodes, long requestTs, long executionInterval, long timeoutMs, long maxAgeMs) throws TimeoutException, ExecutionException, InterruptedException {
        HashMap<MBParameters, List<MeasuredValue>> measuredValues = new HashMap<MBParameters, List<MeasuredValue>>();
        for (MBParameters mbPara : toolboxNodes) {
            if (mbPara.getFunctionCode() == null || !this.modbusMaster.isConnected()) continue;
            try {
                long now = Instant.now().toEpochMilli();
                MeasuredValue mv = switch (mbPara.getFunctionCode()) {
                    case 1 -> {
                        boolean[] bools = this.modbusMaster.readCoils(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                        if (bools.length == 1) {
                            yield new MeasuredValue(now, now, bools[0] ? 1.0 : 0.0, 1.0);
                        }
                        yield null;
                    }
                    case 2 -> {
                        boolean[] bools = this.modbusMaster.readDiscreteInputs(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                        if (bools.length == 1) {
                            yield new MeasuredValue(now, now, bools[0] ? 1.0 : 0.0, 1.0);
                        }
                        yield null;
                    }
                    case 3 -> {
                        int[] ints = this.modbusMaster.readHoldingRegisters(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                        if (ints.length == 1) {
                            yield new MeasuredValue(now, now, (double)Integer.valueOf(ints[0]).intValue() / mbPara.getScale(), 1.0);
                        }
                        yield null;
                    }
                    case 4 -> {
                        Double d = null;
                        int[] ints = this.modbusMaster.readInputRegisters(mbPara.getServerAddress(), mbPara.getStartAddress(), mbPara.getRegisterCount());
                        ModbusDataTypes dataType = mbPara.getDataType();
                        switch (dataType) {
                            case Byte: {
                                d = ModbusDataConverter.ConvertRegistersToByte(ints);
                                break;
                            }
                            case Int32: {
                                d = ModbusDataConverter.ConvertRegistersToInt32(ints, mbPara.getRegisterOrder());
                                break;
                            }
                            case Float: {
                                d = ModbusDataConverter.ConvertRegistersToFloat(ints, mbPara.getRegisterOrder());
                                break;
                            }
                            case Int64: {
                                d = ModbusDataConverter.ConvertRegistersToInt64(ints, mbPara.getRegisterOrder());
                                break;
                            }
                            case Double: {
                                d = ModbusDataConverter.ConvertRegistersToDouble(ints, mbPara.getRegisterOrder());
                                break;
                            }
                            default: {
                                d = ModbusDataConverter.ConvertRegistersToShort(ints);
                            }
                        }
                        yield new MeasuredValue(requestTs - executionInterval, requestTs, d / mbPara.getScale(), 1.0);
                    }
                    default -> null;
                };
                if (mv == null) continue;
                measuredValues.put(mbPara, Collections.singletonList(mv));
            }
            catch (Exception me) {
                throw new ExecutionException("Modbus error", me);
            }
        }
        return measuredValues;
    }

    public Map<String, MBParameters> createNodes(DataGroup group, Collection<String> dataSourceKeys) {
        TreeMap<String, MBParameters> nodes = new TreeMap<String, MBParameters>();
        String namespace = group.getResultNamespace(this.getDataSource());
        for (String identifier : dataSourceKeys) {
            nodes.put(identifier, (MBParameters)this.getSignalConverter().convert((Object)new SignalId(namespace, identifier, IdentifierType.String)));
        }
        return nodes;
    }

    public boolean[] checkIsPresent(DataGroup group, ArrayList<MBParameters> toolboxNode) {
        boolean[] result = new boolean[toolboxNode.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    public boolean[] checkCanRead(DataGroup group, ArrayList<MBParameters> toolboxNode) {
        boolean[] result = new boolean[toolboxNode.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    public Map<VariableInstance, Boolean> writeValues(DataGroup group, Table<MBParameters, VariableInstance, IVarValue> writeValues, long requestTs, long executionInterval, long timeoutMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        return null;
    }
}

