/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.noprot.randomgenerator;

import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.IProcessInterface;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class ProcessInterface
implements IProcessInterface<String> {
    private final IDataSource dataSource;
    private DataClientState state = DataClientState.New;

    public ProcessInterface(IDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public OperationResult doConnect() {
        this.state = DataClientState.Connected;
        return OperationResult.SUCCESS;
    }

    public void doDisconnect() {
        this.state = DataClientState.Disconnected;
    }

    public DataClientState getState() {
        return this.state;
    }

    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException, UnsupportedOperationException {
        return null;
    }

    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        return null;
    }

    public SignalDataValue getCurrentValue(SignalId node) throws ExecutionException {
        return null;
    }

    public Map<String, String> createNodes(DataGroup group, Collection<String> dataSourceKeys) throws Exception {
        HashMap<String, String> nodes = new HashMap<String, String>();
        dataSourceKeys.forEach(s -> {
            String string = nodes.put((String)s, (String)s);
        });
        return nodes;
    }

    public boolean[] checkIsPresent(DataGroup droup, ArrayList<String> toolboxNode) {
        return this.checkCanRead(droup, toolboxNode);
    }

    public boolean[] checkCanRead(DataGroup droup, ArrayList<String> toolboxNode) {
        boolean[] result = new boolean[toolboxNode.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    public Map<String, List<MeasuredValue>> readValues(DataGroup group, Set<String> nodes, long requestTs, long executionInterval, long timeoutMs, long maxAgeMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        HashMap<String, List<MeasuredValue>> result = new HashMap<String, List<MeasuredValue>>();
        for (String node : nodes) {
            result.put(node, Collections.singletonList(new MeasuredValue(requestTs - executionInterval, requestTs, Math.random() * 100.0, 1.0)));
        }
        return result;
    }

    public Map<VariableInstance, Boolean> writeValues(DataGroup group, Table<String, VariableInstance, IVarValue> writeValues, long requestTs, long executionInterval, long timeoutMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        return null;
    }
}

