/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.opcda.openscada;

import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.IdentifierType;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.SignalType;
import de.elpro.ewms.core.datasource.opcua.SignalStatusCode;
import de.elpro.ewms.core.datasource.opcua.SignalValueDataType;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.opcda.openscada.SimpleBrowser;
import de.elpro.ewms.server.datasource.opcda.openscada.bundle.Activator;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.eclipse.fx.core.log.Logger;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.JIVariant;
import org.openscada.opc.dcom.da.OPCBROWSETYPE;
import org.openscada.opc.dcom.list.ClassDetails;
import org.openscada.opc.lib.common.ConnectionInformation;
import org.openscada.opc.lib.da.AddFailedException;
import org.openscada.opc.lib.da.Group;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;
import org.openscada.opc.lib.da.UnknownGroupException;
import org.openscada.opc.lib.list.Categories;
import org.openscada.opc.lib.list.Category;
import org.openscada.opc.lib.list.ServerList;

public class ProcessInterface
implements IProcessInterface<Item> {
    private static Logger logger = Activator.loggerFactory.createLogger(ProcessInterface.class.getName());
    private final IDataSource dataSource;
    private final Server server;
    private final ConnectionInformation ci;
    private volatile DataClientState state = DataClientState.New;

    public ProcessInterface(IDataSource dataSource) {
        String user;
        String domain;
        String host;
        this.dataSource = dataSource;
        boolean useIpAddr = dataSource.getHostIpAddr() != null && !dataSource.getHostIpAddr().isBlank();
        String string = host = useIpAddr ? dataSource.getHostIpAddr() : dataSource.getHostName();
        if (dataSource.getUser() == null) {
            domain = null;
            user = null;
        } else {
            String[] userParts = dataSource.getUser().split("@");
            user = userParts[0];
            domain = userParts.length == 2 ? userParts[1] : "";
        }
        String password = dataSource.getPassword();
        this.ci = new ConnectionInformation();
        this.ci.setHost(host);
        this.ci.setUser(user);
        this.ci.setDomain(domain);
        this.ci.setPassword(password);
        try {
            UUID.fromString(dataSource.getInstance());
            this.ci.setClsid(dataSource.getInstance());
        }
        catch (Exception exception) {
            this.ci.setProgId(dataSource.getInstance());
        }
        this.server = new Server(this.ci, Executors.newSingleThreadScheduledExecutor());
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public synchronized OperationResult doConnect() {
        try {
            this.state = DataClientState.Connecting;
            this.server.connect();
            this.state = DataClientState.Connected;
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            this.server.disconnect();
            try {
                ServerList serverList = new ServerList(this.ci.getHost(), this.ci.getUser(), this.ci.getPassword(), this.ci.getDomain());
                Collection detailsList = serverList.listServersWithDetails(new Category[]{Categories.OPCDAServer20}, new Category[0]);
                if (!detailsList.isEmpty()) {
                    String text = "Could not establisch connection. Valid connections are:\r\n";
                    for (ClassDetails details : detailsList) {
                        text = String.valueOf(text) + String.format("\t\tProgID: %s, ClsId: %s, Description: %s\r\n", details.getProgId(), details.getClsId(), details.getDescription());
                    }
                    logger.info(text);
                }
            }
            catch (Exception exc2) {
                logger.error("Error reading server list", (Throwable)exc2);
            }
        }
        this.state = DataClientState.Fault;
        return new OperationResult(ResultType.UnexprectedError, String.format("Cannot extablish OPC DA Connection. Error: %s (Cause: %s)", exc.getLocalizedMessage(), exc.getCause() != null ? exc.getCause().getMessage() : ""));
    }

    public synchronized void doDisconnect() {
        try {
            if (this.server != null) {
                this.server.disconnect();
            }
            this.state = DataClientState.Disconnected;
        }
        catch (Exception exc) {
            this.state = DataClientState.Fault;
            logger.error("Disconnection error", (Throwable)exc);
        }
    }

    public DataClientState getState() {
        return this.state;
    }

    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException, UnsupportedOperationException {
        try {
            if (rootNode != null && rootNode.getType() != SignalType.Folder) {
                return new SignalId[0];
            }
            SimpleBrowser browser = new SimpleBrowser(this.server.getBrowser());
            LinkedList<String> path = new LinkedList<String>();
            if (rootNode != null) {
                String[] stringArray = rootNode.getIdentifier().split("#//#");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String pathPart = stringArray[n2];
                    path.add(pathPart);
                    ++n2;
                }
            }
            browser.moveToRoot();
            for (String pathPart : path) {
                browser.moveTo(pathPart);
            }
            ArrayList<SignalId> signalIds = new ArrayList<SignalId>();
            for (String subBranch : browser.browse(OPCBROWSETYPE.OPC_BRANCH)) {
                String identifier = rootNode == null ? subBranch : String.valueOf(rootNode.getIdentifier()) + "#//#" + subBranch;
                SignalId signalId = new SignalId(null, identifier, IdentifierType.String);
                signalId.setType(SignalType.Folder);
                signalId.setDisplayName(subBranch);
                signalIds.add(signalId);
            }
            for (String leaf : browser.browse(OPCBROWSETYPE.OPC_LEAF)) {
                SignalId signalId = new SignalId(null, browser.getItemId(leaf), IdentifierType.String);
                signalId.setType(SignalType.Value);
                signalId.setDisplayName(leaf);
                signalIds.add(signalId);
            }
            return signalIds.toArray(new SignalId[0]);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        return signalId;
    }

    public SignalDataValue getCurrentValue(SignalId node) throws ExecutionException {
        String tempGroupName = String.format("TEMP READ GROUP [%s]", UUID.randomUUID());
        Group tempGroup = null;
        try {
            tempGroup = this.server.addGroup(tempGroupName);
            Item item = tempGroup.addItem(node.getIdentifier());
            ItemState state = (ItemState)tempGroup.read(false, new Item[]{item}).get(item);
            SignalDataValue sdv = new SignalDataValue();
            if (state.getQuality() <= 28) {
                sdv.setStatusCode(SignalStatusCode.BAD);
            } else if (state.getQuality() < 192) {
                sdv.setStatusCode(SignalStatusCode.UNCERTAIN);
            } else {
                sdv.setStatusCode(SignalStatusCode.GOOD);
            }
            sdv.setSourceTime(Instant.now());
            if (state.getTimestamp() != null) {
                sdv.setServerTime(state.getTimestamp().toInstant());
            }
            if (state.getValue() != null) {
                switch (state.getValue().getType()) {
                    case 0: 
                    case 1: 
                    case 13: {
                        sdv.setValueTypeId(SignalValueDataType.None);
                        break;
                    }
                    case 11: {
                        sdv.setValueTypeId(SignalValueDataType.Boolean);
                        sdv.setValue((Object)state.getValue().getObjectAsBoolean());
                        break;
                    }
                    case 16: {
                        sdv.setValueTypeId(SignalValueDataType.Integer);
                        sdv.setValue((Object)((byte)state.getValue().getObjectAsChar()));
                        break;
                    }
                    case 2: {
                        sdv.setValueTypeId(SignalValueDataType.Integer);
                        sdv.setValue((Object)state.getValue().getObjectAsShort());
                        break;
                    }
                    case 3: 
                    case 22: {
                        sdv.setValueTypeId(SignalValueDataType.Integer);
                        sdv.setValue((Object)state.getValue().getObjectAsInt());
                        break;
                    }
                    case 20: {
                        sdv.setValueTypeId(SignalValueDataType.Int64);
                        sdv.setValue((Object)state.getValue().getObjectAsLong());
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 23: {
                        sdv.setValueTypeId(SignalValueDataType.UInteger);
                        sdv.setValue((Object)state.getValue().getObjectAsUnsigned().getValue().intValue());
                        break;
                    }
                    case 4: {
                        sdv.setValueTypeId(SignalValueDataType.Float);
                        sdv.setValue((Object)Float.valueOf(state.getValue().getObjectAsFloat()));
                        break;
                    }
                    case 5: 
                    case 14: {
                        sdv.setValueTypeId(SignalValueDataType.Double);
                        sdv.setValue((Object)state.getValue().getObjectAsDouble());
                        break;
                    }
                    case 8: {
                        sdv.setValueTypeId(SignalValueDataType.String);
                        sdv.setValue((Object)state.getValue().getObjectAsString2());
                        break;
                    }
                }
            } else {
                sdv.setValueTypeId(SignalValueDataType.None);
            }
            this.server.removeGroup(tempGroup, true);
            SignalDataValue signalDataValue = sdv;
            return signalDataValue;
        }
        catch (Exception exc) {
            throw new ExecutionException(exc);
        }
        finally {
            if (tempGroup != null) {
                try {
                    this.server.removeGroup(tempGroup, true);
                }
                catch (JIException e) {
                    throw new ExecutionException(e);
                }
            }
        }
    }

    public Map<String, Item> createNodes(DataGroup group, Collection<String> dataSourceKeys) throws Exception {
        Group opcGroup;
        String groupId = UUID.randomUUID().toString();
        if (group.getName() != null) {
            groupId = String.format("%s [%s]", group.getName(), groupId);
        }
        try {
            opcGroup = this.server.findGroup(groupId);
        }
        catch (UnknownGroupException unknownGroupException) {
            opcGroup = this.server.addGroup(groupId);
        }
        TreeMap<String, Item> nodes = new TreeMap<String, Item>();
        for (String dataSourceKey : dataSourceKeys) {
            try {
                Item opcItem = opcGroup.addItem(dataSourceKey);
                nodes.put(dataSourceKey, opcItem);
            }
            catch (AddFailedException exc) {
                logger.errorf("Error adding opc node ", (Throwable)exc, new Object[0]);
            }
        }
        return nodes;
    }

    public boolean checkIsPresent(Item toolboxNode) {
        try {
            ItemState state = toolboxNode.read(false);
            return state.getErrorCode() == 0;
        }
        catch (JIException jIException) {
            return false;
        }
    }

    public boolean checkCanRead(Item toolboxNode) {
        try {
            ItemState state = toolboxNode.read(false);
            double doubleValue = ProcessInterface.stateToDouble(state);
            return state.getQuality() >= 192 && Double.isFinite(doubleValue);
        }
        catch (IllegalStateException illegalStateException) {
            logger.warningf("OPC DA Item %s is not of double type. State is: %s", new Object[]{toolboxNode.getId(), this.state.toString()});
            return false;
        }
        catch (JIException jIException) {
            return false;
        }
    }

    public boolean[] checkIsPresent(DataGroup group, ArrayList<Item> toolboxNodes) {
        boolean[] result = new boolean[toolboxNodes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.checkIsPresent(toolboxNodes.get(i));
            ++i;
        }
        return result;
    }

    public boolean[] checkCanRead(DataGroup group, ArrayList<Item> toolboxNodes) {
        boolean[] result = new boolean[toolboxNodes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.checkCanRead(toolboxNodes.get(i));
            ++i;
        }
        return result;
    }

    public Map<Item, List<MeasuredValue>> readValues(DataGroup group, Set<Item> toolboxNodes, long requestTs, long executionInterval, long timeoutMs, long maxAgeMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        Map states;
        HashMap<Item, List<MeasuredValue>> measuredValues = new HashMap<Item, List<MeasuredValue>>();
        if (toolboxNodes.isEmpty()) {
            return measuredValues;
        }
        Group nodesGroup = toolboxNodes.iterator().next().getGroup();
        try {
            states = nodesGroup.read(false, toolboxNodes.toArray(new Item[0]));
        }
        catch (JIException e) {
            throw new ExecutionException("Error reading opc da values", e);
        }
        int successfullRead = 0;
        for (Item item : toolboxNodes) {
            ItemState state = (ItemState)states.get(item);
            try {
                JIVariant variant = state.getValue();
                if (variant == null) {
                    logger.error(String.format("Cannot read value for node %s", item.getId()));
                    continue;
                }
                double doubleValue = ProcessInterface.stateToDouble(state);
                double quality = state.getQuality() >= 192 ? 1 : 0;
                if (Double.isNaN(doubleValue)) {
                    logger.debug(String.format("Node %s is not of supported type. Type = %d", item.getId(), state.getValue().getType()));
                    continue;
                }
                if (quality != 1.0) {
                    logger.debug(String.format("Quality error for node %s. Status = %d", item.getId(), state.getQuality()));
                } else {
                    ++successfullRead;
                }
                measuredValues.put(item, Collections.singletonList(new MeasuredValue(requestTs - executionInterval, requestTs, doubleValue, quality)));
            }
            catch (Exception exc) {
                logger.error(String.format("Error reading data for node %s", item.getId()), (Throwable)exc);
            }
        }
        if (toolboxNodes.size() > 1 && successfullRead == 0) {
            throw new ExecutionException("All read nodes unavailable (quality=bad)", new Exception("All read nodes unavailable (quality=bad)"));
        }
        return measuredValues;
    }

    public Map<VariableInstance, Boolean> writeValues(DataGroup group, Table<Item, VariableInstance, IVarValue> writeValues, long requestTs, long executionInterval, long timeoutMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        return null;
    }

    private static double stateToDouble(ItemState state) throws JIException {
        if (state.getValue() != null) {
            switch (state.getValue().getType()) {
                case 0: 
                case 1: 
                case 13: {
                    return Double.NaN;
                }
                case 11: {
                    return state.getValue().getObjectAsBoolean() ? 1.0 : 0.0;
                }
                case 16: {
                    return (byte)state.getValue().getObjectAsChar();
                }
                case 2: {
                    return state.getValue().getObjectAsShort();
                }
                case 3: 
                case 22: {
                    return state.getValue().getObjectAsInt();
                }
                case 20: {
                    return state.getValue().getObjectAsLong();
                }
                case 17: 
                case 18: 
                case 19: 
                case 23: {
                    return state.getValue().getObjectAsUnsigned().getValue().intValue();
                }
                case 4: {
                    return state.getValue().getObjectAsFloat();
                }
                case 5: 
                case 14: {
                    return state.getValue().getObjectAsDouble();
                }
                case 8: {
                    return Double.NaN;
                }
            }
            return Double.NaN;
        }
        return Double.NaN;
    }
}

