/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.opcua.milo;

import de.elpro.ewms.core.json.JsonUtils;

public class DataGroupProperties {
    private final HistorizingProperties historizingProperties;

    public DataGroupProperties(HistorizingProperties historizingProperties) {
        this.historizingProperties = historizingProperties;
    }

    public HistorizingProperties getHistorizingProperties() {
        return this.historizingProperties;
    }

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static DataGroupProperties parse(String json) {
        return (DataGroupProperties)JsonUtils.GSON.fromJson(json, DataGroupProperties.class);
    }

    public static void main(String[] args) {
        System.out.println(new DataGroupProperties(new HistorizingProperties(new IdentifierAdjustment[]{new IdentifierAdjustment("t1", "r1"), new IdentifierAdjustment("t2", "r2")})).toJson());
        DataGroupProperties properties = DataGroupProperties.parse("{\n  \"historizing_properties\": {\n    \"replacements\": [\n      {\n        \"target\": \"t\\\\|KSEPE_\",\n        \"replacement\": \"v\\\\|KSEPE_\"\n      },{\n        \"target\": \"::\",\n        \"replacement\": \"::SystemArchive\\\\\\\\\"\n      }\n    ]\n  }\n}");
        System.out.println(properties.toJson());
        String identifier = "t|KSEPE_OS1::PIZA30618/PO1.PV_Out#Value";
        IdentifierAdjustment[] identifierAdjustmentArray = properties.getHistorizingProperties().getReplacements();
        int n = identifierAdjustmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierAdjustment adjustment = identifierAdjustmentArray[n2];
            identifier = identifier.replaceAll(adjustment.getTarget(), adjustment.getReplacement());
            ++n2;
        }
        System.out.println(identifier);
    }

    public static class HistorizingProperties {
        private IdentifierAdjustment[] replacements;

        public HistorizingProperties(IdentifierAdjustment[] replacements) {
            this.replacements = replacements;
        }

        public IdentifierAdjustment[] getReplacements() {
            return this.replacements;
        }
    }

    public static class IdentifierAdjustment {
        private final String target;
        private final String replacement;

        public IdentifierAdjustment(String target, String replacement) {
            this.target = target;
            this.replacement = replacement;
        }

        public String getTarget() {
            return this.target;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }
}

