/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.opcua.milo;

import com.google.common.collect.Sets;
import de.elpro.ewms.server.datasource.opcua.milo.bundle.Activator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateBuilder;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;

class KeyStoreLoader {
    private static Logger logger = Activator.loggerFactory.createLogger(KeyStoreLoader.class.getName());
    private static final Pattern IP_ADDR_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String CLIENT_ALIAS = "client-ai";
    private static final char[] PASSWORD = "sndfH(9asdfjh3!xcvJ".toCharArray();
    private X509Certificate[] clientCertificateChain;
    private X509Certificate clientCertificate;
    private KeyPair clientKeyPair;

    KeyStoreLoader() {
    }

    KeyStoreLoader load(File baseDir) throws Exception {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        File serverKeyStore = baseDir.toPath().resolve("eos-opcua-client.pfx").toFile();
        logger.info(String.format("Loading KeyStore at {%s}", serverKeyStore));
        if (!serverKeyStore.exists()) {
            keyStore.load(null, PASSWORD);
            KeyPair keyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
            String applicationUri = "urn:com.eos:client:" + UUID.randomUUID();
            SelfSignedCertificateBuilder builder = new SelfSignedCertificateBuilder(keyPair).setCommonName("EOS Opc UA Client").setOrganization("elpro").setOrganizationalUnit("dev").setLocalityName("Berlin").setStateName("Berlin").setCountryCode("DE").setApplicationUri(applicationUri).addDnsName("localhost").addIpAddress("127.0.0.1");
            for (String hostname : KeyStoreLoader.getHostnames("0.0.0.0", true)) {
                if (IP_ADDR_PATTERN.matcher(hostname).matches()) {
                    builder.addIpAddress(hostname);
                    continue;
                }
                builder.addDnsName(hostname);
            }
            X509Certificate certificate = builder.build();
            keyStore.setKeyEntry(CLIENT_ALIAS, keyPair.getPrivate(), PASSWORD, new X509Certificate[]{certificate});
            keyStore.store(new FileOutputStream(serverKeyStore), PASSWORD);
        } else {
            keyStore.load(new FileInputStream(serverKeyStore), PASSWORD);
        }
        Key clientPrivateKey = keyStore.getKey(CLIENT_ALIAS, PASSWORD);
        if (clientPrivateKey instanceof PrivateKey) {
            this.clientCertificate = (X509Certificate)keyStore.getCertificate(CLIENT_ALIAS);
            this.clientCertificateChain = (X509Certificate[])Arrays.stream(keyStore.getCertificateChain(CLIENT_ALIAS)).map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
            PublicKey serverPublicKey = this.clientCertificate.getPublicKey();
            this.clientKeyPair = new KeyPair(serverPublicKey, (PrivateKey)clientPrivateKey);
        }
        return this;
    }

    X509Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    public X509Certificate[] getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    KeyPair getClientKeyPair() {
        return this.clientKeyPair;
    }

    public static Set<String> getHostnames(String address, boolean includeLoopback) {
        HashSet hostnames;
        block7: {
            hostnames = Sets.newHashSet();
            try {
                InetAddress inetAddress = InetAddress.getByName(address);
                if (inetAddress.isAnyLocalAddress()) {
                    try {
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        for (NetworkInterface ni : Collections.list(nis)) {
                            Collections.list(ni.getInetAddresses()).forEach(ia -> {
                                boolean loopback;
                                if (ia instanceof Inet4Address && (!(loopback = ia.isLoopbackAddress()) || includeLoopback)) {
                                    hostnames.add(ia.getHostName());
                                    hostnames.add(ia.getHostAddress());
                                    hostnames.add(ia.getCanonicalHostName());
                                }
                            });
                        }
                        break block7;
                    }
                    catch (SocketException e) {
                        logger.warning(String.format("Failed to NetworkInterfaces for bind address: %s", address), (Throwable)e);
                    }
                    break block7;
                }
                boolean loopback = inetAddress.isLoopbackAddress();
                if (!loopback || includeLoopback) {
                    hostnames.add(inetAddress.getHostName());
                    hostnames.add(inetAddress.getHostAddress());
                    hostnames.add(inetAddress.getCanonicalHostName());
                }
            }
            catch (UnknownHostException e) {
                logger.warning(String.format("Failed to get InetAddress for bind address: %s", address), (Throwable)e);
            }
        }
        return hostnames;
    }
}

