/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.opcua.milo;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.IdentifierType;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.SignalType;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityMode;
import de.elpro.ewms.core.datasource.opcua.MessageSecurityPolicy;
import de.elpro.ewms.core.datasource.opcua.NodeClass;
import de.elpro.ewms.core.datasource.opcua.SignalStatusCode;
import de.elpro.ewms.core.datasource.opcua.SignalValueDataType;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.datasource.IHistorizableProcessInterface;
import de.elpro.ewms.server.datasource.opcua.milo.DataGroupProperties;
import de.elpro.ewms.server.datasource.opcua.milo.KeyStoreLoader;
import de.elpro.ewms.server.datasource.opcua.milo.bundle.Activator;
import de.elpro.ewms.server.logger.LogDB;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.SessionActivityListener;
import org.eclipse.milo.opcua.sdk.client.api.ServiceFaultListener;
import org.eclipse.milo.opcua.sdk.client.api.UaSession;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.sdk.core.AccessLevel;
import org.eclipse.milo.opcua.sdk.core.WriteMask;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.ClientDirectoryCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.IdType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryData;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadResult;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRawModifiedDetails;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;

public class ProcessInterface
implements IHistorizableProcessInterface<NodeId> {
    private static Logger logger = Activator.loggerFactory.createLogger(ProcessInterface.class.getName());
    private static final String APPLICATION_NAME = "eos-opcua-client";
    private static final UInteger SESSION_TIMEOUT = UInteger.valueOf((int)3600000);
    private static final UInteger REQUEST_TIMEOUT = UInteger.valueOf((int)60000);
    private static final File OWN_SECURITY_DIR = Server.getWorkspaceLocation().append("security").append("own").toFile();
    private static Map<String, DataGroupProperties> dataGroupPropertiesCache = new HashMap<String, DataGroupProperties>();
    private String endpointUrl;
    private OpcUaClient opcClient;
    protected String[] namespaceArray;
    private volatile Boolean sessionActive = null;
    private boolean connecting;
    private OpcUaClientConfig config;
    private final IDataSource dataSource;
    private final Map<NodeId, SignalValueDataType> signalValueDataTypes = new HashMap<NodeId, SignalValueDataType>();
    public static final ImmutableSet<AttributeId> MY_VARIABLE_NODE_ATTRIBUTES = ImmutableSet.copyOf((Collection)Sets.union((Set)AttributeId.BASE_ATTRIBUTES, EnumSet.of(AttributeId.DataType, new AttributeId[]{AttributeId.ValueRank, AttributeId.ArrayDimensions, AttributeId.Value, AttributeId.AccessLevel, AttributeId.UserAccessLevel, AttributeId.MinimumSamplingInterval, AttributeId.Historizing})));
    private Converter<SignalId, NodeId> converter = new Converter<SignalId, NodeId>(){

        protected NodeId doForward(SignalId signalId) {
            Integer namespaceIndex;
            NodeId nodeId = null;
            try {
                namespaceIndex = ProcessInterface.this.getNamespaceIndex(signalId.getNamespace());
                if (namespaceIndex == null) {
                    return null;
                }
            }
            catch (Exception exception) {
                return null;
            }
            IdentifierType idType = IdentifierType.valueOf((String)signalId.getIdentifierType());
            switch (idType) {
                case Numeric: {
                    nodeId = new NodeId(namespaceIndex.intValue(), ((Integer)signalId.getIdentifierObject()).intValue());
                    break;
                }
                case String: {
                    nodeId = new NodeId(namespaceIndex.intValue(), signalId.getIdentifier());
                    break;
                }
                case UUID: {
                    nodeId = new NodeId(namespaceIndex.intValue(), (UUID)signalId.getIdentifierObject());
                    break;
                }
                case Opaque: {
                    nodeId = new NodeId(namespaceIndex.intValue(), ByteString.of((byte[])((byte[])signalId.getIdentifierObject())));
                }
            }
            return nodeId;
        }

        protected SignalId doBackward(NodeId nodeId) {
            String[] namespaces;
            try {
                namespaces = ProcessInterface.this.getNamespaces();
            }
            catch (UaException uaException) {
                return null;
            }
            return new SignalId(namespaces[nodeId.getNamespaceIndex().intValue()], nodeId.toString(), IdentifierType.String);
        }
    };

    public ProcessInterface(IDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public OperationResult doConnect() {
        String hostName;
        if (this.sessionActive != null && this.sessionActive.booleanValue()) {
            logger.warning("Do-Connect: session as already active. Disconnecting ...");
            this.doDisconnect();
        }
        SecurityPolicy securityPolicy = switch (this.dataSource.getSecurityPolicy()) {
            case MessageSecurityPolicy.None -> SecurityPolicy.None;
            case MessageSecurityPolicy.Basic128Rsa15 -> SecurityPolicy.Basic128Rsa15;
            case MessageSecurityPolicy.Basic256 -> SecurityPolicy.Basic256;
            case MessageSecurityPolicy.Basic256Sha256 -> SecurityPolicy.Basic256Sha256;
            case MessageSecurityPolicy.Aes128_Sha256_RsaOaep -> SecurityPolicy.Aes128_Sha256_RsaOaep;
            case MessageSecurityPolicy.Aes256_Sha256_RsaPss -> SecurityPolicy.Aes256_Sha256_RsaPss;
            default -> SecurityPolicy.None;
        };
        org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode securityMode = switch (this.dataSource.getMessageSecurityMode()) {
            case MessageSecurityMode.None -> org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode.None;
            case MessageSecurityMode.Sign -> org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode.Sign;
            case MessageSecurityMode.SignAndEncrypt -> org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode.SignAndEncrypt;
            default -> org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode.None;
        };
        InetAddress addr = null;
        final Instant ts = Instant.now();
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (Exception exception) {}
        String string = hostName = addr == null ? "unknow-host" : addr.getHostName();
        if (!OWN_SECURITY_DIR.exists() && !OWN_SECURITY_DIR.mkdirs()) {
            throw new Exception("unable to create security dir: " + OWN_SECURITY_DIR);
        }
        logger.info(String.format("Security dir: {%s}", OWN_SECURITY_DIR.getAbsolutePath()));
        KeyStoreLoader keyStoreLoader = new KeyStoreLoader().load(OWN_SECURITY_DIR);
        boolean useIpAddr = this.dataSource.getHostName() != null && !this.dataSource.getHostName().isEmpty() ? false : this.dataSource.getHostIpAddr() != null && !this.dataSource.getHostIpAddr().isEmpty();
        String hostIdentifier = useIpAddr ? this.dataSource.getHostIpAddr() : this.dataSource.getHostName();
        this.endpointUrl = "opc.tcp://" + hostIdentifier;
        if (this.dataSource.getHostPortNr() != null) {
            this.endpointUrl = String.valueOf(this.endpointUrl) + ":" + this.dataSource.getHostPortNr();
        }
        if (this.dataSource.getInstance() != null) {
            this.endpointUrl = String.valueOf(this.endpointUrl) + "/" + this.dataSource.getInstance();
        }
        logger.info("Connecting to: " + this.endpointUrl);
        Supplier<String> sessionName = new Supplier<String>(){

            @Override
            public String get() {
                return String.format("EOS @ %s (%s)", hostName, ts);
            }
        };
        List subjects = CertificateUtil.getSubjectAltNameField((X509Certificate)keyStoreLoader.getClientCertificate(), (int)6);
        String applicationUri = subjects.stream().map(o -> o.toString()).findFirst().orElse("urn:com.eos:client:" + UUID.randomUUID());
        Object identityProvider = this.dataSource.getUser() != null && !this.dataSource.getUser().trim().isEmpty() ? new UsernameProvider(this.dataSource.getUser(), this.dataSource.getPassword() != null ? this.dataSource.getPassword() : "") : new AnonymousProvider();
        ClientDirectoryCertificateValidator certValidator = new ClientDirectoryCertificateValidator(OWN_SECURITY_DIR, (Set<ValidationCheck>)ValidationCheck.NO_OPTIONAL_CHECKS);
        Function selectEndpointFunction = endpoints -> {
            Optional<EndpointDescription> endpoint = endpoints.stream().filter(e -> e.getSecurityMode().getValue() == securityMode.getValue()).filter(e -> e.getSecurityPolicyUri().equals(securityPolicy.getUri())).findFirst();
            endpoint.ifPresent(e -> logger.infof("Using endpoint: %s [%s, %s]", new Object[]{e.getEndpointUrl(), e.getSecurityPolicyUri(), e.getSecurityMode()}));
            return endpoint;
        };
        Function buildConfigFunction = arg_0 -> ProcessInterface.lambda$5(applicationUri, (IdentityProvider)identityProvider, (Supplier)sessionName, keyStoreLoader, certValidator, arg_0);
        logger.info(String.format("SessionTimeout = %s ms, RequestTimeout = %s ms", SESSION_TIMEOUT, REQUEST_TIMEOUT));
        this.opcClient = OpcUaClient.create((String)this.endpointUrl, (java.util.function.Function)selectEndpointFunction, (java.util.function.Function)buildConfigFunction);
        EndpointDescription endpoint = this.opcClient.getConfig().getEndpoint();
        this.opcClient.addSessionActivityListener(new SessionActivityListener(){

            public void onSessionActive(UaSession session) {
                ProcessInterface.this.sessionActive = true;
                logger.infof("Milo OPC UA Session '%s' Activated.", new Object[]{ProcessInterface.this.dataSource});
            }

            public void onSessionInactive(UaSession session) {
                ProcessInterface.this.sessionActive = false;
                logger.infof("Milo OPC UA Session '%s' Closed.", new Object[]{ProcessInterface.this.dataSource});
            }
        });
        this.opcClient.addFaultListener(new ServiceFaultListener(){

            public void onServiceFault(ServiceFault arg0) {
                logger.error(String.format("Service Fault! [Type: %s]", arg0.getTypeId()));
            }
        });
        try {
            this.connecting = true;
            this.opcClient.connect().get(60L, TimeUnit.SECONDS);
            this.namespaceArray = this.getNamespaces();
            String message = String.format("Connected using endpoint: %s [[MessageSecurityPolicy: %s] [SecurityMode: %s]]", endpoint.getEndpointUrl(), securityPolicy.getUri().split("#")[1], securityMode);
            LogMessage logMessage = new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, "OPC-Connection", message);
            LogDB.addMessage((LogMessage)logMessage);
            logger.info(message);
            OperationResult operationResult = new OperationResult(ResultType.Success, message);
            this.connecting = false;
            return operationResult;
        }
        catch (Exception e) {
            try {
                OperationResult operationResult = this.handleConnectException(e, endpoint, securityPolicy, securityMode);
                this.connecting = false;
                return operationResult;
            }
            catch (Throwable throwable) {
                try {
                    this.connecting = false;
                    throw throwable;
                }
                catch (Exception e2) {
                    return this.handleConnectException(e2, null, securityPolicy, securityMode);
                }
            }
        }
    }

    private OperationResult handleConnectException(Exception e, EndpointDescription endpoint, SecurityPolicy securityPolicy, org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode securityMode) {
        String message = "No Endpoint Found";
        if (endpoint != null) {
            message = String.format("Connection error for %s [[MessageSecurityPolicy: %s] [SecurityMode: %s]]", endpoint.getEndpointUrl(), securityPolicy.getUri().split("#")[1], securityMode);
        }
        ResultType resultType = ResultType.UnexprectedError;
        if (e.getCause() instanceof UaException) {
            UaException uaException = (UaException)e.getCause();
            message = String.valueOf(message) + String.format("; StatusCode=%s", uaException.getStatusCode().toString());
            resultType = ResultType.ExpectedError;
        } else {
            message = String.valueOf(message) + String.format("; Message=%s", e.getMessage());
        }
        LogMessage logMessage = new LogMessage(Instant.now(), LogType.User, LogLevel.ERROR, "OPC-Connection", message);
        LogDB.addMessage((LogMessage)logMessage);
        logger.errorf(message, (Throwable)e, new Object[0]);
        return new OperationResult(resultType, message);
    }

    public void doDisconnect() {
        if (this.opcClient == null) {
            return;
        }
        try {
            try {
                String url = this.opcClient.getConfig().getEndpoint().getEndpointUrl();
                logger.info("Disconnecting from: " + url);
                if (this.opcClient != null) {
                    do {
                        this.opcClient.disconnect().get(100L, TimeUnit.SECONDS);
                    } while (this.sessionActive.booleanValue());
                    logger.info("Disconnected from: " + url);
                }
            }
            catch (Exception e) {
                this.sessionActive = false;
                logger.error("OPC UA client disconnected!", (Throwable)e);
                this.signalValueDataTypes.clear();
            }
        }
        finally {
            this.signalValueDataTypes.clear();
        }
    }

    public DataClientState getState() {
        if (this.opcClient == null || this.sessionActive == null) {
            return DataClientState.New;
        }
        if (this.connecting) {
            return DataClientState.Connecting;
        }
        return this.sessionActive != false ? DataClientState.Connected : DataClientState.Disconnected;
    }

    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException {
        OperationResult result;
        if ((this.getState() == DataClientState.New || this.getState() == DataClientState.Disconnected) && (result = this.doConnect()).getType() != ResultType.Success) {
            throw new ExecutionException("Error during auto-connect.", (Throwable)new DAOOperationException(result));
        }
        LinkedList<SignalId> signals = new LinkedList<SignalId>();
        NodeId browseNodeId = rootNode != null ? (NodeId)this.getSignalConverter().convert((Object)rootNode) : Identifiers.RootFolder;
        try {
            BrowseDescription nodeToBrowse = new BrowseDescription(browseNodeId, BrowseDirection.Forward, null, Boolean.valueOf(true), UInteger.valueOf((int)255), UInteger.valueOf((int)63));
            Object result2 = (BrowseResult)this.opcClient.browse(nodeToBrowse).get();
            while (result2 != null && result2.getStatusCode().isGood()) {
                ReferenceDescription[] referenceDescriptionArray = result2.getReferences();
                int n = referenceDescriptionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferenceDescription referenceDescription = referenceDescriptionArray[n2];
                    org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass nodeClass = referenceDescription.getNodeClass();
                    if (nodeClass != org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass.ReferenceType && nodeClass != org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass.VariableType && nodeClass != org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass.ObjectType) {
                        String namespace = "null";
                        ExpandedNodeId eNodeId = referenceDescription.getNodeId();
                        if (eNodeId != null) {
                            namespace = this.namespaceArray[eNodeId.getNamespaceIndex().intValue()];
                            QualifiedName browseName = referenceDescription.getBrowseName() != null ? referenceDescription.getBrowseName() : new QualifiedName(0, "null");
                            LocalizedText displayName = referenceDescription.getDisplayName() != null ? referenceDescription.getDisplayName() : new LocalizedText("en", "null");
                            SignalId signalId = new SignalId(namespace, eNodeId.getIdentifier().toString(), IdentifierType.from((Integer)eNodeId.getType().getValue()));
                            signalId.setDisplayName(displayName.getText());
                            signalId.addGenericProperty("NodeClass", referenceDescription.getNodeClass().name());
                            signalId.addGenericProperty("NamespaceIndex", eNodeId.getNamespaceIndex().toString());
                            signalId.addGenericProperty("BrowseName", browseName.getName());
                            signalId.addGenericProperty("Locale", displayName.getLocale());
                            switch (nodeClass) {
                                case Object: {
                                    signalId.setType(SignalType.Folder);
                                    break;
                                }
                                case Variable: {
                                    signalId.setType(SignalType.Variable);
                                    break;
                                }
                                case Method: {
                                    signalId.setType(SignalType.Method);
                                    break;
                                }
                            }
                            signals.add(signalId);
                        }
                    }
                    ++n2;
                }
                ByteString continuationPoint = result2.getContinuationPoint();
                result2 = continuationPoint != null && continuationPoint.isNotNull() ? (BrowseResult)this.opcClient.browseNext(false, continuationPoint).get() : null;
            }
            signals.sort((o1, o2) -> {
                String s1 = o1.getDisplayName() != null ? o1.getDisplayName() : "";
                String s2 = o2.getDisplayName() != null ? o2.getDisplayName() : "";
                return s1.compareTo(s2);
            });
            SignalId[] signalsArray = signals.toArray(new SignalId[0]);
            if (signalsArray == null) {
                return new SignalId[0];
            }
            return signalsArray;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            String msg = String.format("Error browsing node %s", browseNodeId);
            logger.error(msg, (Throwable)e);
            throw new ExecutionException(msg, e);
        }
        return null;
    }

    protected String[] getNamespaces() throws UaException {
        if (this.namespaceArray == null) {
            UaVariableNode namespacesNode = this.opcClient.getAddressSpace().getVariableNode(Identifiers.Server_NamespaceArray);
            DataValue namespacesValue = namespacesNode.readValue();
            this.namespaceArray = (String[])namespacesValue.getValue().getValue();
        }
        return this.namespaceArray;
    }

    protected Integer getNamespaceIndex(String namespace) throws UaException {
        if (namespace == null) {
            return null;
        }
        String[] namespaces = this.getNamespaces();
        if (namespaces == null) {
            return null;
        }
        int i = 0;
        while (i < namespaces.length) {
            if (namespace.toLowerCase().equals(namespaces[i].toLowerCase())) {
                return i;
            }
            ++i;
        }
        return null;
    }

    public SignalDataValue getCurrentValue(SignalId signalId) throws ExecutionException {
        LinkedList<NodeId> nodes;
        NodeId nodeId;
        block10: {
            nodeId = null;
            try {
                IdentifierType idType = IdentifierType.valueOf((String)signalId.getIdentifierType());
                switch (idType) {
                    case Numeric: {
                        nodeId = new NodeId(this.getNamespaceIndex(signalId.getNamespace()).intValue(), ((Integer)signalId.getIdentifierObject()).intValue());
                        break;
                    }
                    case String: {
                        nodeId = new NodeId(this.getNamespaceIndex(signalId.getNamespace()).intValue(), signalId.getIdentifier());
                        break;
                    }
                    case UUID: {
                        nodeId = new NodeId(this.getNamespaceIndex(signalId.getNamespace()).intValue(), (UUID)signalId.getIdentifierObject());
                        break;
                    }
                    case Opaque: {
                        nodeId = new NodeId(this.getNamespaceIndex(signalId.getNamespace()).intValue(), ByteString.of((byte[])((byte[])signalId.getIdentifierObject())));
                    }
                }
                nodes = new LinkedList<NodeId>();
                if (nodeId != null) break block10;
                return null;
            }
            catch (Exception e) {
                String msg = String.format("Error by reading %s node", nodeId);
                logger.error(msg, (Throwable)e);
                throw new ExecutionException(msg, e);
            }
        }
        nodes.add(nodeId);
        ArrayList<ReadValueId> readValueIdList = new ArrayList<ReadValueId>();
        ReadValueId readValueId1 = new ReadValueId(nodeId, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
        readValueIdList.add(readValueId1);
        ReadValueId readValueId2 = new ReadValueId(nodeId, AttributeId.DataType.uid(), null, QualifiedName.NULL_VALUE);
        readValueIdList.add(readValueId2);
        ReadValueId readValueId3 = new ReadValueId(nodeId, AttributeId.ValueRank.uid(), null, QualifiedName.NULL_VALUE);
        readValueIdList.add(readValueId3);
        ReadValueId readValueId4 = new ReadValueId(nodeId, AttributeId.ArrayDimensions.uid(), null, QualifiedName.NULL_VALUE);
        readValueIdList.add(readValueId4);
        DataValue[] values = new DataValue[]{};
        ReadResponse readResponse = (ReadResponse)this.opcClient.read(0.0, TimestampsToReturn.Both, readValueIdList).get();
        values = readResponse.getResults();
        if (values.length == 0) {
            return new SignalDataValue();
        }
        return this.convertDataValue(values);
    }

    public Map<String, NodeId> createNodes(DataGroup group, Collection<String> dataSourceKeys) throws Exception {
        TreeMap<String, NodeId> nodes = new TreeMap<String, NodeId>();
        String namespace = group.getResultNamespace(this.getDataSource());
        LinkedHashMap<ReadValueId, NodeId> nodeIdRead = new LinkedHashMap<ReadValueId, NodeId>();
        for (String identifier : dataSourceKeys) {
            SignalId signalId = new SignalId(namespace, identifier, IdentifierType.String);
            try {
                NodeId nodeId = (NodeId)this.getSignalConverter().convert((Object)signalId);
                nodeIdRead.put(new ReadValueId(nodeId, UInteger.valueOf((int)AttributeId.DataType.id()), null, QualifiedName.NULL_VALUE), nodeId);
                nodes.put(identifier, nodeId);
            }
            catch (NullPointerException nullPointerException) {
                logger.errorf("Cannot create NodeID for namespace=%s and identifier=%s. Try to check namespace first.", new Object[]{namespace, identifier});
            }
        }
        ArrayList requests = new ArrayList(nodeIdRead.keySet());
        ReadResponse readValueIds = (ReadResponse)this.opcClient.read(100000.0, TimestampsToReturn.Both, requests).get();
        DataValue[] attributes = readValueIds.getResults();
        int i = 0;
        while (i < requests.size()) {
            ReadValueId rvd = (ReadValueId)requests.get(i);
            NodeId nodeId = (NodeId)nodeIdRead.get(rvd);
            DataValue dataValue = attributes[i];
            if (dataValue.getStatusCode().isGood()) {
                Variant variant = dataValue.getValue();
                Object val = variant.getValue();
                SignalValueDataType dataType = SignalValueDataType.getValue((int)((UInteger)((NodeId)val).getIdentifier()).intValue());
                this.signalValueDataTypes.put(nodeId, dataType);
            } else {
                this.signalValueDataTypes.remove(nodeId);
            }
            ++i;
        }
        return nodes;
    }

    public boolean[] checkIsPresent(DataGroup group, ArrayList<NodeId> toolboxNodes) {
        boolean[] result = new boolean[toolboxNodes.size()];
        if (toolboxNodes.isEmpty()) {
            return result;
        }
        try {
            List values = (List)this.opcClient.readValues(0.0, TimestampsToReturn.Source, toolboxNodes).get(toolboxNodes.size() * 1000, TimeUnit.MILLISECONDS);
            int i = 0;
            while (i < result.length) {
                DataValue value = (DataValue)values.get(i);
                result[i] = value.getStatusCode().getValue() != 2150891520L;
                ++i;
            }
            return result;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            logger.error(String.format("Error checking presence of nodes %s", toolboxNodes));
            return result;
        }
    }

    public boolean[] checkCanRead(DataGroup group, ArrayList<NodeId> toolboxNodes) {
        boolean[] result = new boolean[toolboxNodes.size()];
        if (toolboxNodes.isEmpty()) {
            return result;
        }
        try {
            List values = (List)this.opcClient.readValues(0.0, TimestampsToReturn.Source, toolboxNodes).get(toolboxNodes.size() * 1000, TimeUnit.MILLISECONDS);
            int i = 0;
            while (i < result.length) {
                DataValue value = (DataValue)values.get(i);
                result[i] = value.getStatusCode().isGood() && Double.isFinite(ProcessInterface.tryReadDouble(value.getValue()));
                ++i;
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error(String.format("Error by test reading %s node", toolboxNodes), (Throwable)e);
        }
        return result;
    }

    public Converter<SignalId, NodeId> getSignalConverter() {
        return this.converter;
    }

    public Map<NodeId, List<MeasuredValue>> readValues(DataGroup group, Set<NodeId> toolboxNodes, long requestTs, long executionInterval, long timeoutMs, long maxAgeMs) throws TimeoutException, ExecutionException, InterruptedException {
        ArrayList<NodeId> nodes = new ArrayList<NodeId>(toolboxNodes);
        HashMap<NodeId, List<MeasuredValue>> measuredValues = new HashMap<NodeId, List<MeasuredValue>>();
        List values = (List)this.opcClient.readValues((double)maxAgeMs, TimestampsToReturn.Source, nodes).get(timeoutMs, TimeUnit.MILLISECONDS);
        int i = 0;
        int successfullRead = 0;
        for (DataValue value : values) {
            NodeId nodeId = null;
            try {
                nodeId = nodes.get(i);
                ++i;
                Variant variant = value.getValue();
                if (variant == null) {
                    logger.error(String.format("Cannot read value for node %s", nodeId));
                    continue;
                }
                double doubleValue = ProcessInterface.tryReadDouble(variant);
                double quality = value.getStatusCode().isGood() && Double.isFinite(doubleValue) ? 1 : 0;
                if (quality != 1.0) {
                    logger.debug(String.format("Quality error for node %s. Status = %s", nodeId, value.getStatusCode()));
                } else {
                    ++successfullRead;
                }
                measuredValues.put(nodeId, Collections.singletonList(new MeasuredValue(requestTs - executionInterval, requestTs, doubleValue, quality)));
            }
            catch (Exception exc) {
                logger.error(String.format("Error reading data for node %s", nodeId), (Throwable)exc);
            }
        }
        if (values.size() > 1 && successfullRead == 0) {
            throw new ExecutionException("All read nodes unavailable (quality=bad)", new Exception("All read nodes unavailable (quality=bad)"));
        }
        return measuredValues;
    }

    public Map<NodeId, Boolean> isHistorizing(String namespace, String propertiesDefinition, Set<NodeId> nodes) throws ExecutionException, InterruptedException, IOException {
        HashMap<NodeId, Boolean> isHistorizing = new HashMap<NodeId, Boolean>();
        if (nodes.isEmpty()) {
            return isHistorizing;
        }
        DataGroupProperties properties = ProcessInterface.getDataGroupProperties(propertiesDefinition);
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>(nodes);
        ArrayList<NodeId> historizingNodeIds = ProcessInterface.getHistorizingNodes(nodes, properties);
        ArrayList<ReadValueId> readValueIdList = new ArrayList<ReadValueId>();
        AttributeId historizingAttributeId = AttributeId.Historizing;
        for (NodeId nodeId : historizingNodeIds) {
            ReadValueId rvid = new ReadValueId(nodeId, historizingAttributeId.uid(), null, QualifiedName.NULL_VALUE);
            readValueIdList.add(rvid);
        }
        ReadResponse readValueIds = (ReadResponse)this.opcClient.read(100000.0, TimestampsToReturn.Both, readValueIdList).get();
        if (!readValueIds.getResponseHeader().getServiceResult().isGood()) {
            nodes.forEach(n -> {
                Boolean bl = isHistorizing.put((NodeId)n, false);
            });
            return isHistorizing;
        }
        DataValue[] attributes = readValueIds.getResults();
        int index = 0;
        for (NodeId nodeId : nodeIds) {
            Variant variant;
            Object val;
            DataValue dataValue;
            boolean historizing = false;
            if ((dataValue = attributes[index++]).getStatusCode().isGood() && (val = (variant = dataValue.getValue()).getValue()) instanceof Boolean) {
                historizing = (Boolean)val;
            }
            isHistorizing.put(nodeId, historizing);
        }
        return isHistorizing;
    }

    public Map<NodeId, IVarValuesCollection> readHistoricalValues(String namespace, String propertiesDefinition, Set<NodeId> nodes, Instant from, Instant to, Raster raster) throws ExecutionException, InterruptedException, IOException {
        from = Instant.ofEpochMilli(raster.getRasterBegin(from.toEpochMilli()));
        to = Instant.ofEpochMilli(raster.getRasterEnd(to.toEpochMilli()));
        DateTime startTs = new DateTime(Date.from(from));
        DateTime endTs = new DateTime(Date.from(to));
        HashMap<NodeId, IVarValuesCollection> values = new HashMap<NodeId, IVarValuesCollection>();
        ReadRawModifiedDetails historyReadDetails = new ReadRawModifiedDetails(Boolean.valueOf(false), startTs, endTs, null, Boolean.valueOf(true));
        ArrayList<HistoryReadValueId> historyNodes = new ArrayList<HistoryReadValueId>();
        HashMap<NodeId, Long> nextHDAValueTimestamps = new HashMap<NodeId, Long>();
        HashMap<NodeId, IVarValue> lastValues = new HashMap<NodeId, IVarValue>();
        DataGroupProperties properties = ProcessInterface.getDataGroupProperties(propertiesDefinition);
        ArrayList<NodeId> nodeIds = new ArrayList<NodeId>(nodes);
        ArrayList<NodeId> historizingNodes = ProcessInterface.getHistorizingNodes(nodes, properties);
        HashMap<NodeId, NodeId> historizingToSourceNodeIds = new HashMap<NodeId, NodeId>();
        try {
            int nodeIndex = 0;
            for (NodeId historizingNodeId : historizingNodes) {
                NodeId nodeId = nodeIds.get(nodeIndex++);
                historyNodes.add(new HistoryReadValueId(historizingNodeId, null, null, null));
                nextHDAValueTimestamps.put(nodeId, from.toEpochMilli() + raster.toMilli());
                lastValues.put(nodeId, VarValue.nan((long)from.toEpochMilli()));
                values.put(nodeId, new IVarValuesCollection());
                historizingToSourceNodeIds.put(historizingNodeId, nodeId);
            }
            HistoryReadResponse hrp = (HistoryReadResponse)this.opcClient.historyRead((HistoryReadDetails)historyReadDetails, TimestampsToReturn.Both, false, historyNodes).get();
            while (hrp != null) {
                nodeIndex = 0;
                ArrayList<HistoryReadValueId> rereadNodes = new ArrayList<HistoryReadValueId>();
                HistoryReadResult[] historyReadResultArray = hrp.getResults();
                int n = historyReadResultArray.length;
                int n2 = 0;
                while (n2 < n) {
                    HistoryReadResult result = historyReadResultArray[n2];
                    NodeId historizingNodeId = ((HistoryReadValueId)historyNodes.get(nodeIndex++)).getNodeId();
                    NodeId nodeId = (NodeId)historizingToSourceNodeIds.get(historizingNodeId);
                    long nextHDAValueTs = (Long)nextHDAValueTimestamps.get(nodeId);
                    IVarValue lastValue = (IVarValue)lastValues.get(nodeId);
                    IVarValuesCollection valuesCollection = (IVarValuesCollection)values.get(nodeId);
                    if (result.getStatusCode().isGood()) {
                        if (result.getStatusCode().getValue() != 0xA50000L) {
                            HistoryData hd = (HistoryData)result.getHistoryData().decode(this.opcClient.getStaticSerializationContext());
                            DataValue[] dataValueArray = hd.getDataValues();
                            int n3 = dataValueArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                DataValue dv = dataValueArray[n4];
                                long serverTs = dv.getServerTime().getJavaTime();
                                long sourceTs = dv.getSourceTime().getJavaTime();
                                if (sourceTs > serverTs) {
                                    serverTs = sourceTs;
                                }
                                IVarValue value = null;
                                if (dv.getValue().isNotNull() && (dv.getStatusCode().isGood() || dv.getStatusCode().isUncertain())) {
                                    double quality;
                                    double dVal = ProcessInterface.tryReadDouble(dv.getValue());
                                    double d = quality = dv.getStatusCode().isGood() ? 1.0 : 0.5;
                                    if (Double.isFinite(dVal)) {
                                        value = new VarValue(serverTs, ((Number)dv.getValue().getValue()).doubleValue(), quality, ValueSource.Measured);
                                    }
                                }
                                if (value == null) {
                                    value = VarValue.nan((long)serverTs);
                                }
                                while (nextHDAValueTs <= value.getEndTimestamp() && nextHDAValueTs <= to.toEpochMilli()) {
                                    if (lastValue.isValid()) {
                                        MeasuredValue av = new MeasuredValue(nextHDAValueTs - raster.toMilli(), nextHDAValueTs, lastValue.getValue(), 1.0);
                                        valuesCollection.add((IVarValue)av);
                                    }
                                    nextHDAValueTs += raster.toMilli();
                                }
                                lastValue = value;
                                ++n4;
                            }
                            nextHDAValueTimestamps.put(nodeId, nextHDAValueTs);
                            lastValues.put(nodeId, lastValue);
                            ByteString continuationPoint = result.getContinuationPoint();
                            if (continuationPoint != null && continuationPoint.isNotNull()) {
                                rereadNodes.add(new HistoryReadValueId(historizingNodeId, null, null, continuationPoint));
                            }
                        }
                    } else {
                        logger.errorf("Could not read node %s, result: %s", new Object[]{nodeId.toString(), result.toString()});
                    }
                    ++n2;
                }
                if (!rereadNodes.isEmpty()) {
                    historyNodes = rereadNodes;
                    rereadNodes = new ArrayList();
                    hrp = (HistoryReadResponse)this.opcClient.historyRead((HistoryReadDetails)historyReadDetails, TimestampsToReturn.Server, false, historyNodes).get();
                    continue;
                }
                hrp = null;
            }
        }
        catch (Throwable throwable) {
            values.values().forEach(c -> c.close());
            throw throwable;
        }
        values.values().forEach(c -> c.close());
        return values;
    }

    public Map<VariableInstance, Boolean> writeValues(DataGroup group, Table<NodeId, VariableInstance, IVarValue> writeValues, long requestTs, long executionInterval, long timeoutMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        if (writeValues.isEmpty()) {
            logger.warning("Nothing to write");
            return new LinkedHashMap<VariableInstance, Boolean>();
        }
        ArrayList nodeIds = new ArrayList();
        ArrayList instances = new ArrayList();
        ArrayList values = new ArrayList();
        writeValues.cellSet().forEach(cell -> {
            NodeId nodeId = (NodeId)cell.getRowKey();
            nodeIds.add(nodeId);
            instances.add((VariableInstance)cell.getColumnKey());
            IVarValue value = (IVarValue)cell.getValue();
            SignalValueDataType dataType = this.signalValueDataTypes.get(nodeId);
            Object valueObject = switch (dataType) {
                case SignalValueDataType.Boolean -> {
                    if (value.getValue() != 0.0) {
                        yield Boolean.TRUE;
                    }
                    yield Boolean.FALSE;
                }
                case SignalValueDataType.Byte -> (byte)value.getValue();
                case SignalValueDataType.Integer -> (int)value.getValue();
                case SignalValueDataType.Double -> value.getValue();
                case SignalValueDataType.Float -> Float.valueOf((float)value.getValue());
                case SignalValueDataType.Int16 -> (short)value.getValue();
                case SignalValueDataType.Int32 -> (int)value.getValue();
                case SignalValueDataType.Int64 -> (long)value.getValue();
                case SignalValueDataType.UInteger -> UInteger.valueOf((long)((long)value.getValue()));
                case SignalValueDataType.UInt16 -> UShort.valueOf((int)((int)value.getValue()));
                case SignalValueDataType.UInt32 -> UInteger.valueOf((int)((int)value.getValue()));
                case SignalValueDataType.UInt64 -> ULong.valueOf((long)((int)value.getValue()));
                case SignalValueDataType.String -> Double.toString(value.getValue());
                default -> {
                    logger.errorf("Unsupported DataType %s for node %s ", new Object[]{dataType, nodeId});
                    yield null;
                }
            };
            values.add(new DataValue(new Variant(valueObject), StatusCode.GOOD, null, null));
        });
        LinkedHashMap<VariableInstance, Boolean> result = new LinkedHashMap<VariableInstance, Boolean>();
        this.opcClient.writeValues(nodeIds, values).thenAccept(statusCodes -> {
            int i = 0;
            for (StatusCode code : statusCodes) {
                result.put((VariableInstance)instances.get(i), code.isGood());
                ++i;
            }
        });
        return result;
    }

    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        NodeClass nodeClass = NodeClass.valueOf((String)((String)signalId.getGenericProperties().get("NodeClass")));
        switch (nodeClass) {
            case Unspecified: {
                return this.fillBaseAttributes(signalId);
            }
            case Object: {
                return this.fillBaseAttributes(signalId);
            }
            case Variable: {
                return this.fillVariableAttributes(signalId);
            }
            case Method: {
                return this.fillBaseAttributes(signalId);
            }
            case ObjectType: {
                return this.fillBaseAttributes(signalId);
            }
            case VariableType: {
                return this.fillBaseAttributes(signalId);
            }
            case ReferenceType: {
                return this.fillBaseAttributes(signalId);
            }
            case DataType: {
                return this.fillBaseAttributes(signalId);
            }
            case View: {
                return this.fillBaseAttributes(signalId);
            }
        }
        return signalId;
    }

    private SignalId fillBaseAttributes(SignalId signalId) {
        NodeId browseNodeId = (NodeId)this.getSignalConverter().convert((Object)signalId);
        ArrayList<ReadValueId> readValueIdList = new ArrayList<ReadValueId>();
        ImmutableList attributeIdList = AttributeId.BASE_ATTRIBUTES.asList();
        for (AttributeId aid : attributeIdList) {
            ReadValueId rvid = new ReadValueId(browseNodeId, aid.uid(), null, QualifiedName.NULL_VALUE);
            readValueIdList.add(rvid);
        }
        try {
            ReadResponse readValueIds = (ReadResponse)this.opcClient.read(100000.0, TimestampsToReturn.Source, readValueIdList).get();
            DataValue[] attributes = readValueIds.getResults();
            int i = 0;
            while (i < attributeIdList.size()) {
                AttributeId attrId = (AttributeId)attributeIdList.get(i);
                DataValue dataValue = attributes[i];
                Variant variant = dataValue.getValue();
                Object val = variant.getValue();
                if (val != null) {
                    switch (attrId) {
                        case Description: {
                            if (!(val instanceof LocalizedText)) break;
                            signalId.addGenericProperty("Description", ((LocalizedText)val).getText());
                            break;
                        }
                        case WriteMask: {
                            if (!(val instanceof UInteger)) break;
                            signalId.addGenericProperty("WriteMask", ((UInteger)val).toString());
                            break;
                        }
                        case UserWriteMask: {
                            if (!(val instanceof UInteger)) break;
                            signalId.addGenericProperty("UserWriteMask", ((UInteger)val).toString());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signalId;
    }

    private SignalId fillVariableAttributes(SignalId signalId) {
        NodeId browseNodeId = (NodeId)this.getSignalConverter().convert((Object)signalId);
        ArrayList<ReadValueId> readValueIdList = new ArrayList<ReadValueId>();
        ImmutableList attributeIdList = MY_VARIABLE_NODE_ATTRIBUTES.asList();
        for (AttributeId aid : attributeIdList) {
            ReadValueId rvid = new ReadValueId(browseNodeId, aid.uid(), null, QualifiedName.NULL_VALUE);
            readValueIdList.add(rvid);
        }
        try {
            ReadResponse readValueIds = (ReadResponse)this.opcClient.read(100000.0, TimestampsToReturn.Both, readValueIdList).get();
            DataValue[] attributes = readValueIds.getResults();
            SignalValueDataType dataType = SignalValueDataType.None;
            AttributeId valueAttrId = null;
            Variant value = null;
            Integer valueRank = -1;
            Boolean isArrayDimensionRelevant = false;
            UInteger[] arrayDimensions = new UInteger[]{};
            int i = 0;
            while (i < attributeIdList.size()) {
                AttributeId attrId = (AttributeId)attributeIdList.get(i);
                DataValue dataValue = attributes[i];
                Variant variant = dataValue.getValue();
                Object val = variant.getValue();
                switch (attrId) {
                    case Description: {
                        if (!(val instanceof LocalizedText)) break;
                        signalId.addGenericProperty(attrId.name(), ((LocalizedText)val).getText());
                        break;
                    }
                    case WriteMask: {
                        if (!(val instanceof UInteger)) break;
                        EnumSet writeMasks = WriteMask.fromMask((UInteger)((UInteger)val));
                        signalId.addGenericProperty(attrId.name(), writeMasks.isEmpty() ? "" : writeMasks.toString());
                        break;
                    }
                    case UserWriteMask: {
                        if (!(val instanceof UInteger)) break;
                        EnumSet writeMasks = WriteMask.fromMask((UInteger)((UInteger)val));
                        signalId.addGenericProperty(attrId.name(), writeMasks.isEmpty() ? "" : writeMasks.toString());
                        break;
                    }
                    case DataType: {
                        dataType = SignalValueDataType.getValue((int)((UInteger)((NodeId)val).getIdentifier()).intValue());
                        signalId.addGenericProperty(attrId.name(), dataType.name());
                        break;
                    }
                    case ValueRank: {
                        valueRank = (Integer)val;
                        isArrayDimensionRelevant = valueRank != -1;
                        signalId.addGenericProperty(attrId.name(), valueRank.toString());
                        break;
                    }
                    case ArrayDimensions: {
                        if (val != null && isArrayDimensionRelevant.booleanValue()) {
                            arrayDimensions = (UInteger[])val;
                            if (arrayDimensions.length == 0) {
                                arrayDimensions = new UInteger[]{UInteger.valueOf((int)0)};
                            }
                            String arrayDimension = "[";
                            int j = 0;
                            while (j < arrayDimensions.length) {
                                arrayDimension = j > 0 ? String.valueOf(arrayDimension) + ", " + arrayDimensions[j].toString() : String.valueOf(arrayDimension) + arrayDimensions[j].toString();
                                ++j;
                            }
                            arrayDimension = String.valueOf(arrayDimension) + "]";
                            signalId.addGenericProperty(attrId.name(), arrayDimension);
                            break;
                        }
                        arrayDimensions = null;
                        break;
                    }
                    case Value: {
                        value = variant;
                        valueAttrId = attrId;
                        break;
                    }
                    case AccessLevel: {
                        EnumSet accessLevels = AccessLevel.fromValue((UByte)((UByte)val));
                        signalId.addGenericProperty(attrId.name(), accessLevels.isEmpty() ? "" : accessLevels.toString());
                        break;
                    }
                    case UserAccessLevel: {
                        EnumSet accessLevels = AccessLevel.fromValue((UByte)((UByte)val));
                        signalId.addGenericProperty(attrId.name(), accessLevels.isEmpty() ? "" : accessLevels.toString());
                        break;
                    }
                    case MinimumSamplingInterval: {
                        if (val instanceof Double) {
                            signalId.addGenericProperty(attrId.name(), ((Double)val).toString());
                            break;
                        }
                        signalId.addGenericProperty(attrId.name(), Double.valueOf(((Integer)val).doubleValue()).toString());
                        break;
                    }
                    case Historizing: {
                        signalId.addGenericProperty(attrId.name(), ((Boolean)val).toString());
                        break;
                    }
                }
                ++i;
            }
            if (valueAttrId != null && value != null && !isArrayDimensionRelevant.booleanValue()) {
                switch (dataType) {
                    case Boolean: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Boolean)value.getValue()).toString());
                        break;
                    }
                    case Byte: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Byte)value.getValue()).toString());
                        break;
                    }
                    case DateTime: {
                        signalId.addGenericProperty(valueAttrId.name(), ((DateTime)value.getValue()).toString());
                        break;
                    }
                    case Double: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Double)value.getValue()).toString());
                        break;
                    }
                    case Float: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Float)value.getValue()).toString());
                        break;
                    }
                    case Int16: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Short)value.getValue()).toString());
                        break;
                    }
                    case Int32: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Integer)value.getValue()).toString());
                        break;
                    }
                    case Int64: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Integer)value.getValue()).toString());
                        break;
                    }
                    case UInt16: {
                        signalId.addGenericProperty(valueAttrId.name(), ((UShort)value.getValue()).toString());
                        break;
                    }
                    case UInt32: {
                        signalId.addGenericProperty(valueAttrId.name(), ((UInteger)value.getValue()).toString());
                        break;
                    }
                    case UInt64: {
                        signalId.addGenericProperty(valueAttrId.name(), ((ULong)value.getValue()).toString());
                        break;
                    }
                    case Integer: {
                        signalId.addGenericProperty(valueAttrId.name(), ((Integer)value.getValue()).toString());
                        break;
                    }
                    case String: {
                        signalId.addGenericProperty(valueAttrId.name(), (String)value.getValue());
                    }
                    default: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error reading properties", (Throwable)e);
        }
        return signalId;
    }

    private SignalDataValue convertDataValue(DataValue[] dataValue) {
        SignalDataValue clientDataValue = new SignalDataValue();
        if (dataValue.length > 0) {
            Variant variant = dataValue[0].getValue();
            Object val = variant.getValue();
            if (val instanceof UByte) {
                val = ((UByte)val).byteValue();
            } else if (val instanceof UShort) {
                val = ((UShort)val).intValue();
            } else if (val instanceof UInteger) {
                val = ((UInteger)val).intValue();
            } else if (val instanceof ULong) {
                val = ((ULong)val).toBigInteger();
            } else if (val instanceof ByteString) {
                val = ((ByteString)val).toString();
            } else if (val instanceof DateTime) {
                val = Instant.ofEpochMilli(((DateTime)val).getJavaTime());
            } else if (val instanceof LocalizedText) {
                val = new de.elpro.ewms.core.datasource.opcua.datatypes.LocalizedText(((LocalizedText)val).getLocale(), ((LocalizedText)val).getText());
            } else if (val instanceof QualifiedName) {
                val = new de.elpro.ewms.core.datasource.opcua.datatypes.QualifiedName(Integer.valueOf(((QualifiedName)val).getNamespaceIndex().intValue()), ((QualifiedName)val).getName());
            }
            clientDataValue.setValue(val);
            if (dataValue.length > 1 && dataValue[1].getValue().getValue() != null) {
                if (((NodeId)dataValue[1].getValue().getValue()).getType() == IdType.Numeric) {
                    int vt = ((UInteger)((NodeId)dataValue[1].getValue().getValue()).getIdentifier()).intValue();
                    clientDataValue.setValueTypeId(SignalValueDataType.getValue((int)vt));
                } else {
                    int vt = ((UInteger)((ExpandedNodeId)dataValue[0].getValue().getDataType().get()).getIdentifier()).intValue();
                    clientDataValue.setValueTypeId(SignalValueDataType.getValue((int)vt));
                }
            } else {
                clientDataValue.setValueTypeId(SignalValueDataType.None);
            }
            if (dataValue[0].getStatusCode().isGood()) {
                clientDataValue.setStatusCode(SignalStatusCode.GOOD);
            }
            clientDataValue.setSourceTime(Instant.ofEpochMilli(dataValue[0].getSourceTime().getJavaTime()));
            clientDataValue.setServerTime(Instant.ofEpochMilli(dataValue[0].getServerTime().getJavaTime()));
            if (dataValue[0].getSourcePicoseconds() != null) {
                clientDataValue.setSourcePicoseconds(de.elpro.ewms.core.primitivetypes.UInteger.valueOf((int)dataValue[0].getSourcePicoseconds().intValue()));
            } else {
                clientDataValue.setSourcePicoseconds(null);
            }
            if (dataValue[0].getSourcePicoseconds() != null) {
                clientDataValue.setServerPicoseconds(de.elpro.ewms.core.primitivetypes.UInteger.valueOf((int)dataValue[0].getServerPicoseconds().intValue()));
            } else {
                clientDataValue.setSourcePicoseconds(null);
            }
        }
        return clientDataValue;
    }

    private static Double tryReadDouble(Variant variant) {
        boolean opcBoolValue;
        double doubleValue = variant.getValue() instanceof Boolean ? ((opcBoolValue = ((Boolean)variant.getValue()).booleanValue()) ? 1.0 : 0.0) : (variant.getValue() instanceof Number ? ((Number)variant.getValue()).doubleValue() : Double.NaN);
        return doubleValue;
    }

    private static synchronized DataGroupProperties getDataGroupProperties(String propertiesDefinition) {
        if (propertiesDefinition == null || propertiesDefinition.isBlank()) {
            return null;
        }
        DataGroupProperties properties = dataGroupPropertiesCache.get(propertiesDefinition);
        if (properties != null) {
            return properties;
        }
        try {
            properties = DataGroupProperties.parse(propertiesDefinition);
        }
        catch (Exception exc) {
            logger.errorf("Error parsing datagroup properties", (Throwable)exc, new Object[0]);
        }
        dataGroupPropertiesCache.put(propertiesDefinition, properties);
        return properties;
    }

    private static ArrayList<NodeId> getHistorizingNodes(Collection<NodeId> nodes, DataGroupProperties properties) {
        ArrayList<Object> nodeIds;
        if (properties != null && properties.getHistorizingProperties() != null && properties.getHistorizingProperties().getReplacements() != null) {
            nodeIds = new ArrayList();
            for (NodeId nodeId : nodes) {
                if (nodeId.getIdentifier() instanceof String) {
                    String identifier = (String)nodeId.getIdentifier();
                    DataGroupProperties.IdentifierAdjustment[] identifierAdjustmentArray = properties.getHistorizingProperties().getReplacements();
                    int n = identifierAdjustmentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DataGroupProperties.IdentifierAdjustment adjustment = identifierAdjustmentArray[n2];
                        identifier = identifier.replaceAll(adjustment.getTarget(), adjustment.getReplacement());
                        ++n2;
                    }
                    nodeIds.add(new NodeId(nodeId.getNamespaceIndex(), identifier));
                    continue;
                }
                nodes.add(nodeId);
            }
        } else {
            nodeIds = new ArrayList<NodeId>(nodes);
        }
        return nodeIds;
    }

    private static /* synthetic */ OpcUaClientConfig lambda$5(String string, IdentityProvider identityProvider, Supplier supplier, KeyStoreLoader keyStoreLoader, ClientCertificateValidator clientCertificateValidator, OpcUaClientConfigBuilder configBuilder) {
        return configBuilder.setApplicationName(LocalizedText.english((String)APPLICATION_NAME)).setApplicationUri(string).setIdentityProvider(identityProvider).setRequestTimeout(REQUEST_TIMEOUT).setSessionName(supplier).setCertificate(keyStoreLoader.getClientCertificate()).setKeyPair(keyStoreLoader.getClientKeyPair()).setSessionTimeout(SESSION_TIMEOUT).setCertificateValidator(clientCertificateValidator).build();
    }
}

