/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.application;

import de.elpro.ewms.server.datasource.opcua.milo.bundle.Activator;
import java.io.File;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.DirectoryCertificateValidator;
import org.eclipse.milo.opcua.stack.core.util.validation.CertificateValidationUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;

public class ClientDirectoryCertificateValidator
extends DirectoryCertificateValidator
implements ClientCertificateValidator {
    private final Logger logger = Activator.loggerFactory.createLogger(ClientDirectoryCertificateValidator.class.getName());

    public ClientDirectoryCertificateValidator(File baseDir, Set<ValidationCheck> validationChecks) throws IOException {
        super(baseDir, validationChecks);
    }

    public void validateCertificateChain(List<X509Certificate> certificateChain, String applicationUri, String ... validHostNames) throws UaException {
        this.validateCertificateChain(certificateChain);
        X509Certificate certificate = certificateChain.get(0);
        CertificateValidationUtil.checkApplicationUri((X509Certificate)certificate, (String)applicationUri);
        try {
            CertificateValidationUtil.checkHostnameOrIpAddress((X509Certificate)certificate, (String[])validHostNames);
        }
        catch (UaException e) {
            if (this.validationChecks.contains((Object)ValidationCheck.HOSTNAME)) {
                throw e;
            }
            this.logger.warningf("check suppressed: certificate failed hostname check: %s", new Object[]{certificate.getSubjectX500Principal().getName()});
        }
    }
}

