/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.profinet.s7connector;

import com.github.s7connector.api.DaveArea;
import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.api.factory.S7ConnectorFactory;
import com.github.s7connector.impl.S7TCPConnection;
import com.github.s7connector.impl.serializer.converter.BitConverter;
import com.github.s7connector.impl.serializer.converter.ByteConverter;
import com.github.s7connector.impl.serializer.converter.IntegerConverter;
import com.github.s7connector.impl.serializer.converter.LongConverter;
import com.github.s7connector.impl.serializer.converter.RealConverter;
import com.google.common.collect.Table;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.profinet.s7connector.S7DBProperties;
import de.elpro.ewms.server.datasource.profinet.s7connector.S7Instance;
import de.elpro.ewms.server.datasource.profinet.s7connector.S7SignalId;
import de.elpro.ewms.server.datasource.profinet.s7connector.S7ValueType;
import de.elpro.ewms.server.datasource.profinet.s7connector.bundle.Activator;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.fx.core.log.Logger;

public class ProcessInterface
implements IProcessInterface<S7SignalId> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ProcessInterface.class.getName());
    static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.UPPER_CAMEL_CASE).create();
    private static final S7Serializable BIT_CONVERETER = new BitConverter();
    private static final S7Serializable BYTE_CONVERETER = new ByteConverter();
    private static final S7Serializable WORD_CONVERETER = new IntegerConverter();
    private static final S7Serializable DWORD_CONVERETER = new LongConverter();
    private static final S7Serializable REAL_CONVERETER = new RealConverter();
    private final String hostIdentifier;
    private final S7ConnectorFactory.TCPConnectionBuilder connectionBuilder;
    private final IDataSource dataSource;
    private S7TCPConnection connector;
    private volatile DataClientState state = DataClientState.New;
    private final S7Instance s7InstanceConfig;
    private double lastSequenceNr = Double.NEGATIVE_INFINITY;

    public ProcessInterface(IDataSource dataSource) {
        this.dataSource = dataSource;
        boolean useIpAddr = dataSource.getHostIpAddr() != null && !dataSource.getHostIpAddr().isEmpty();
        this.hostIdentifier = useIpAddr ? dataSource.getHostIpAddr() : dataSource.getHostName();
        this.connectionBuilder = S7ConnectorFactory.buildTCPConnector();
        this.connectionBuilder.withHost(this.hostIdentifier);
        if (dataSource.getHostPortNr() != null) {
            this.connectionBuilder.withPort(dataSource.getHostPortNr().intValue());
        }
        S7Instance config = null;
        if (dataSource.getInstance() != null) {
            try {
                config = (S7Instance)GSON.fromJson(dataSource.getInstance(), S7Instance.class);
                if (config.getRack() != null) {
                    this.connectionBuilder.withRack(config.getRack().intValue());
                }
                if (config.getSlot() != null) {
                    this.connectionBuilder.withSlot(config.getSlot().intValue());
                }
            }
            catch (JsonSyntaxException exc) {
                config = null;
                logger.error("Error reading instance definition", (Throwable)exc);
                logger.error(String.format("Instance definition example: %s", GSON.toJson((Object)new S7Instance())));
            }
        }
        this.s7InstanceConfig = config;
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public OperationResult doConnect() {
        try {
            this.state = DataClientState.Connecting;
            this.connector = (S7TCPConnection)this.connectionBuilder.build();
            this.state = DataClientState.Connected;
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            this.state = DataClientState.Fault;
            return new OperationResult(ResultType.UnexprectedError, String.format("Cannot extablish S7 Connection. Error: %s", exc.getLocalizedMessage()));
        }
    }

    public void doDisconnect() {
        try {
            if (this.connector != null) {
                this.connector.close();
            }
            this.state = DataClientState.Disconnected;
        }
        catch (IOException exc) {
            this.state = DataClientState.Fault;
            logger.error("Disconnection error", (Throwable)exc);
        }
    }

    public DataClientState getState() {
        return this.state;
    }

    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException, UnsupportedOperationException {
        return null;
    }

    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        return signalId;
    }

    public SignalDataValue getCurrentValue(SignalId node) throws ExecutionException {
        return null;
    }

    public Map<String, S7SignalId> createNodes(DataGroup group, Collection<String> dataSourceKeys) {
        TreeMap<String, S7SignalId> nodes = new TreeMap<String, S7SignalId>();
        for (String dataSourceKey : dataSourceKeys) {
            try {
                S7SignalId signalId = (S7SignalId)GSON.fromJson(dataSourceKey, S7SignalId.class);
                nodes.put(dataSourceKey, signalId);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                logger.error(String.format("Cannot parse signal '%s'. S7Connector SignalId example: %s", dataSourceKey, GSON.toJson((Object)new S7SignalId(S7ValueType.REAL, 12, 0))));
            }
        }
        return nodes;
    }

    public boolean[] checkIsPresent(DataGroup group, ArrayList<S7SignalId> toolboxNodes) {
        boolean[] result = new boolean[toolboxNodes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    public boolean[] checkCanRead(DataGroup group, ArrayList<S7SignalId> toolboxNodes) {
        boolean[] result = new boolean[toolboxNodes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = true;
            ++i;
        }
        return result;
    }

    private int getDb(String namespace) throws ExecutionException {
        try {
            return Integer.parseInt(namespace.toLowerCase().replaceAll("db", ""));
        }
        catch (Exception exc) {
            throw new ExecutionException("Cannot convert namespace to db nummer. Example: DB103", exc);
        }
    }

    private S7DBProperties getDbProperties(String propertiesDefinition) throws ExecutionException {
        block3: {
            try {
                if (propertiesDefinition != null && !propertiesDefinition.trim().isEmpty()) break block3;
                return null;
            }
            catch (Exception exc) {
                throw new ExecutionException("Cannot convert namespace to db nummer. Example: DB103", exc);
            }
        }
        return (S7DBProperties)GSON.fromJson(propertiesDefinition, S7DBProperties.class);
    }

    public Map<S7SignalId, List<MeasuredValue>> readValues(DataGroup group, Set<S7SignalId> toolboxNodes, long requestTs, long executionInterval, long timeoutMs, long maxAgeMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        HashMap<S7SignalId, List<MeasuredValue>> values = new HashMap<S7SignalId, List<MeasuredValue>>();
        int db = this.getDb(group.getResultNamespace(this.getDataSource()));
        S7DBProperties properties = this.getDbProperties(group.getPropertiesDefinition());
        int minByte = Integer.MAX_VALUE;
        int maxByte = Integer.MIN_VALUE;
        for (S7SignalId signalId : toolboxNodes) {
            minByte = Math.min(signalId.getByteOffset(), minByte);
            maxByte = Math.max(signalId.getByteOffset() + signalId.getBytes(), maxByte);
        }
        if (properties != null && properties.getUseSequenceNr()) {
            int revisionByteBegin = properties.getSequenceNrByteOffset();
            int revisionByteEnd = revisionByteBegin + properties.getSequenceNrType().getBytes();
            minByte = Math.min(minByte, revisionByteBegin);
            maxByte = Math.max(maxByte, revisionByteEnd);
        }
        byte[] data = this.loadBytes(db, minByte, maxByte - minByte);
        if (properties != null && properties.getUseSequenceNr()) {
            double sequenceNr = ProcessInterface.extractValue(properties.getSequenceNrType(), data, properties.getSequenceNrByteOffset() - minByte, properties.getSequenceNrBitOffset());
            while (sequenceNr == this.lastSequenceNr) {
                if ((double)Instant.now().toEpochMilli() > (double)requestTs + (double)executionInterval * 0.9) {
                    logger.debug(String.format("Timeout reached while waiting for new data. Current sequence: %f", sequenceNr));
                    return values;
                }
                Thread.sleep(5L);
                byte[] revisionBytes = this.loadBytes(db, properties.getSequenceNrByteOffset(), properties.getSequenceNrType().getBytes());
                sequenceNr = ProcessInterface.extractValue(properties.getSequenceNrType(), revisionBytes, 0, properties.getSequenceNrBitOffset());
                if (sequenceNr == this.lastSequenceNr) continue;
                data = this.loadBytes(db, minByte, maxByte - minByte);
                break;
            }
            this.lastSequenceNr = sequenceNr;
        }
        long startTimestamp = requestTs - executionInterval;
        for (S7SignalId signalId : toolboxNodes) {
            int valuesCount = signalId.getValuesCount();
            ArrayList<MeasuredValue> signalIdValues = new ArrayList<MeasuredValue>(valuesCount);
            values.put(signalId, signalIdValues);
            int i = 0;
            while (i < valuesCount) {
                int startByte = signalId.getByteOffset() - minByte + i * signalId.getType().getBytes();
                double value = ProcessInterface.extractValue(signalId.getType(), data, startByte, signalId.getBitOffset());
                long valueStartTs = startTimestamp + (long)i * executionInterval / (long)valuesCount;
                long valueEndTs = startTimestamp + (long)(i + 1) * executionInterval / (long)valuesCount;
                MeasuredValue mv = new MeasuredValue(valueStartTs, valueEndTs, value, 1.0);
                signalIdValues.add(mv);
                ++i;
            }
        }
        return values;
    }

    private byte[] loadBytes(int dbNum, int byteOffset, int size) throws IOException, InterruptedException {
        boolean disableReadOverUploadData;
        boolean bl = disableReadOverUploadData = this.s7InstanceConfig != null && this.s7InstanceConfig.isDisableReadOverUploadData();
        if (disableReadOverUploadData || size <= 96 || byteOffset / size > 2) {
            return this.connector.read(DaveArea.DB, dbNum, size, byteOffset);
        }
        return this.connector.uploadData(DaveArea.DB, dbNum, size, byteOffset);
    }

    private static double extractValue(S7ValueType type, byte[] data, int startByte, int bitOffset) {
        switch (type) {
            case BOOL: {
                boolean bVal = (Boolean)BIT_CONVERETER.extract(Boolean.class, data, startByte, bitOffset);
                return bVal ? 1.0 : 0.0;
            }
            case BYTE: {
                return ((Byte)BYTE_CONVERETER.extract(Byte.class, data, startByte, bitOffset)).byteValue();
            }
            case WORD: {
                return ((Integer)WORD_CONVERETER.extract(Integer.class, data, startByte, bitOffset)).intValue();
            }
            case DWORD: {
                return ((Long)DWORD_CONVERETER.extract(Long.class, data, startByte, bitOffset)).longValue();
            }
            case REAL: {
                return (Double)REAL_CONVERETER.extract(Double.class, data, startByte, bitOffset);
            }
        }
        return 0.0;
    }

    public Map<VariableInstance, Boolean> writeValues(DataGroup group, Table<S7SignalId, VariableInstance, IVarValue> writeValues, long requestTs, long executionInterval, long timeoutMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        return null;
    }
}

