/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.profinet.s7connector;

import de.elpro.ewms.server.datasource.profinet.s7connector.ProcessInterface;
import de.elpro.ewms.server.datasource.profinet.s7connector.S7ValueType;

public class S7SignalId {
    private S7ValueType type = S7ValueType.REAL;
    private int byteOffset = 0;
    private int bitOffset = 0;
    private int valuesCount = 1;

    public S7SignalId() {
    }

    public S7SignalId(S7ValueType type, int byteOffset, int bitOffset) {
        this(type, byteOffset, bitOffset, 1);
    }

    public S7SignalId(S7ValueType type, int byteOffset, int bitOffset, int valuesCount) {
        this.setType(type);
        this.setByteOffset(byteOffset);
        this.setBitOffset(bitOffset);
        this.setValuesCount(valuesCount);
    }

    public S7ValueType getType() {
        return this.type != null ? this.type : S7ValueType.REAL;
    }

    public void setType(S7ValueType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public void setBitOffset(int bitOffset) {
        this.bitOffset = bitOffset;
    }

    public int getValuesCount() {
        return this.valuesCount > 0 ? this.valuesCount : 1;
    }

    public void setValuesCount(int valuesCount) {
        if (valuesCount < 1) {
            throw new IllegalArgumentException();
        }
        this.valuesCount = valuesCount;
    }

    public int getBytes() {
        return this.type.getBytes() * this.valuesCount;
    }

    public int hashCode() {
        return S7SignalId.class.hashCode() + 17 * (this.type != null ? this.type.hashCode() : 0) + 17 ^ 2 * this.byteOffset + 17 ^ 3 * this.bitOffset + 13 * this.valuesCount;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof S7SignalId)) {
            return false;
        }
        S7SignalId s = (S7SignalId)obj;
        return this.type == s.type && this.byteOffset == s.byteOffset && this.bitOffset == s.bitOffset && this.valuesCount == s.valuesCount;
    }

    public String toString() {
        return ProcessInterface.GSON.toJson((Object)this);
    }
}

