/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.core.worker.WorkerState;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.DataReader;
import de.elpro.ewms.server.datasource.ToolboxNodes;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.datasource.component.DataSourceServer;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.fx.core.log.Logger;

public abstract class AbstractToolboxConnector<N>
extends AbstractWorker {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataReader.class.getName());
    private final DataClient<N> client;
    private final DataGroup group;
    private final ToolboxNodes<N> toolboxNodes;

    static {
        TransactionChangeset.addPostCommitEventHandler(Object.class, (changes, properties) -> {
            for (Modification change : changes) {
                Object old = change.getObject();
                if (!(old instanceof Variable) && !(old instanceof VariableInstance) && !(old instanceof StructureObject)) continue;
                HashSet activeConnectors = new HashSet();
                for (AbstractToolboxConnector<?> connector : DataSourceServer.getToolboxConnectors()) {
                    DataClientState clientState = connector.getClient().getState();
                    if (clientState == DataClientState.New || clientState == DataClientState.Disconnected) continue;
                    activeConnectors.add(connector);
                }
                if (!activeConnectors.isEmpty()) {
                    new Thread(() -> activeConnectors.forEach(c -> {
                        try {
                            c.updateToolboxNodes();
                        }
                        catch (Exception exc) {
                            logger.error("Error updating toolbox nodes", (Throwable)exc);
                        }
                    }), "Reastart connectors Thread").start();
                }
                return;
            }
        });
    }

    public AbstractToolboxConnector(String idPrefix, DataClient<N> client, DataGroup group) {
        super(AbstractToolboxConnector.generateId(idPrefix, group), group.getName(), group.getSampleRaster().toMilli(), true);
        this.client = client;
        this.group = group;
        this.toolboxNodes = new ToolboxNodes(group);
        this.setErrorEscalationThreshold(20);
        this.setErrorIncrement(1);
        this.setErrorDecrement(10);
    }

    protected final boolean doStart() {
        while (this.getClient().getState() == DataClientState.Connecting) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.error("Waiting for client connection failed", (Throwable)e);
            }
        }
        if (this.getClient().getState() != DataClientState.Connected && this.getClient().connect().getType() != ResultType.Success) {
            logger.errorf("Connecting client for reader '%s' failed. Force disconnect ...", new Object[]{this.getName()});
            this.getClient().disconnect();
            this.getClient().switchToAlternativeProcessInterface();
            return false;
        }
        boolean result = this.initToolboxNodes();
        if (!result) {
            this.doStop();
            this.getClient().switchToAlternativeProcessInterface();
        }
        return result;
    }

    public ToolboxNodes<N> getToolboxNodes() {
        return this.toolboxNodes;
    }

    public final boolean initToolboxNodes() {
        this.getToolboxNodes().clear();
        return this.updateToolboxNodes();
    }

    protected abstract boolean updateToolboxNodes();

    protected void onErrorEscalation() {
        logger.error("Error threshold reached. Restart client ...");
        this.stopSync();
        logger.debugf("Force disconnect data source %s", new Object[]{this.client.getProcessInterface().getDataSource()});
        this.client.disconnect();
        this.client.switchToAlternativeProcessInterface();
        logger.debug("Client disconnected. Try to connect ...");
        WorkerState state = this.startSync();
        if (state != WorkerState.Running) {
            logger.error("Error ocured during restarting of toolbox connector after to many errors. Autostart is disabled, client will be closed.");
        }
    }

    public abstract boolean[] checkNodeIsAvailable(ArrayList<N> var1);

    protected final void onError(String errorMessage, int escalation, int totalError) {
        logger.error(String.format("%s. Error count %d/%d", errorMessage, escalation, totalError));
    }

    protected static String generateId(String idPrefix, DataGroup group) {
        return String.valueOf(idPrefix) + group.getName() + "-" + group.getId();
    }

    public DataClient<N> getClient() {
        return this.client;
    }

    public DataGroup getGroup() {
        return this.group;
    }
}

