/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataReader;
import de.elpro.ewms.server.datasource.DataWriter;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.ProcessInterfaceWrapper;
import de.elpro.ewms.server.datasource.bundle.Activator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.fx.core.log.Logger;

public class DataClient<N> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataClient.class.getName());
    private final DataSource datasourceDefinition;
    private final EntityManagerFactory entityManagerFactory;
    private final ProcessInterfaceWrapper<N> interfaceWrapper;

    public DataClient(DataSource datasourceDefinition, EntityManagerFactory entityManagerFactory, ProcessInterfaceWrapper<N> processInterfaceWrapper) {
        this.datasourceDefinition = datasourceDefinition;
        this.entityManagerFactory = entityManagerFactory;
        this.interfaceWrapper = processInterfaceWrapper;
    }

    public final List<VariableInstance> getInstances(DataGroup readGroup) {
        LinkedList<VariableInstance> readInstances = new LinkedList<VariableInstance>();
        try (EntityManager em = this.entityManagerFactory.createEntityManager();){
            try {
                for (VariableInstance archiveInstance : em.createQuery("SELECT vi FROM VariableInstance vi WHERE vi.type = :type AND (vi.plcDataGroup = :dg OR (vi.plcDataGroup IS NULL AND vi.variable.plcDefaultDataGroup = :dg))", VariableInstance.class).setParameter("type", (Object)VariableInstanceType.PLC).setParameter("dg", (Object)readGroup).getResultList()) {
                    try {
                        archiveInstance = ORMCache.getVariableInstance((int)archiveInstance.getId());
                        readInstances.add(archiveInstance);
                    }
                    catch (Exception ex) {
                        String msg = String.format("Error by reading instance %s", archiveInstance.toString());
                        logger.error(msg, (Throwable)ex);
                    }
                }
            }
            catch (Exception exc) {
                logger.error("Error loading dataGroup instances", (Throwable)exc);
                em.close();
            }
        }
        return readInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult connect() {
        OperationResult result = new OperationResult(ResultType.UnexprectedError, "Not Initialized");
        try {
            ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
            synchronized (processInterfaceWrapper) {
                result = this.interfaceWrapper.doConnect();
            }
            return result;
        }
        catch (Exception exc) {
            logger.error(String.format("Error connecting to datasource %s", this.datasourceDefinition), (Throwable)exc);
            String message = String.format("Error connecting to datasource %s", this.datasourceDefinition);
            return new OperationResult(ResultType.UnexprectedError, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
            synchronized (processInterfaceWrapper) {
                DataClientState state = this.getState();
                if (state != DataClientState.Disconnected && state != DataClientState.New) {
                    this.interfaceWrapper.doDisconnect();
                }
            }
        }
        catch (Exception exc) {
            logger.error(String.format("Error disconnecting from datasource %s", this.datasourceDefinition), (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void switchToAlternativeProcessInterface() {
        ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
        synchronized (processInterfaceWrapper) {
            this.interfaceWrapper.switchToAlternativeProcessInterface();
        }
    }

    public DataSource getDataSource() {
        return this.datasourceDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataClientState getState() {
        ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
        synchronized (processInterfaceWrapper) {
            return this.interfaceWrapper.getState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException {
        ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
        synchronized (processInterfaceWrapper) {
            return this.interfaceWrapper.getSignals(rootNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
        synchronized (processInterfaceWrapper) {
            return this.interfaceWrapper.getFullSignalDefinition(signalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalDataValue getCurrentValue(SignalId signalId) throws ExecutionException {
        ProcessInterfaceWrapper<N> processInterfaceWrapper = this.interfaceWrapper;
        synchronized (processInterfaceWrapper) {
            return this.interfaceWrapper.getCurrentValue(signalId);
        }
    }

    public final IProcessInterface<N> getProcessInterface() {
        return this.interfaceWrapper;
    }

    public AbstractToolboxConnector<?> createToolboxConnector(DataGroup group) {
        if (group.getType().isRead()) {
            return new DataReader(this, group);
        }
        if (group.getType().isWrite()) {
            return new DataWriter(this, group);
        }
        return null;
    }
}

