/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.fx.core.log.Logger;

class DataReader<N>
extends AbstractToolboxConnector<N> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataReader.class.getName());
    private static final String ID_PREFIX = "dataclient-";

    public DataReader(DataClient<N> client, DataGroup group) {
        super(ID_PREFIX, client, group);
    }

    @Override
    protected boolean updateToolboxNodes() {
        DataGroup dataGroup = this.getGroup();
        HashSet<VariableInstance> newInstances = new HashSet<VariableInstance>(this.getClient().getInstances(dataGroup));
        try {
            this.getToolboxNodes().writeLock.lock();
            Table oldInstanceNodes = this.getToolboxNodes().getNodes();
            Set oldInstances = oldInstanceNodes.rowKeySet();
            if (newInstances.isEmpty()) {
                this.getToolboxNodes().removeInstances(oldInstances);
                logger.warningf("Read group is empty. Nothing to read for %s", new Object[]{this.getName()});
                return true;
            }
            Set<VariableInstance> instancesToRemove = oldInstances.stream().filter(o -> !newInstances.contains(o)).collect(Collectors.toSet());
            HashBasedTable newInstanceNodes = HashBasedTable.create();
            for (VariableInstance archiveInstance : newInstances) {
                Map newNodes;
                String plcDatasourceKey = archiveInstance.getResultPlcDatasourceKey();
                if (plcDatasourceKey == null || plcDatasourceKey.trim().isEmpty()) continue;
                plcDatasourceKey = plcDatasourceKey.trim();
                FormulaNode oldFormula = this.getToolboxNodes().getInstanceFormulas().get(archiveInstance);
                FormulaNode newFormula = null;
                try {
                    HashSet<String> dataSourceKeys = new HashSet<String>();
                    switch (archiveInstance.getPLCInstanceType()) {
                        case Direct: {
                            dataSourceKeys.add(plcDatasourceKey);
                            break;
                        }
                        case Calculated: {
                            newFormula = ScriptParser.parseFormula((String)plcDatasourceKey);
                            for (String textConstant : newFormula.getAllTextConstants()) {
                                dataSourceKeys.add(textConstant.trim());
                            }
                            break;
                        }
                    }
                    newNodes = this.getClient().getProcessInterface().createNodes(dataGroup, dataSourceKeys);
                }
                catch (Exception exc) {
                    logger.error(String.format("Error creating NodeId for archive instance [%s-%s]", archiveInstance.getVariable(), archiveInstance.getStructureObject()), (Throwable)exc);
                    newNodes = null;
                }
                if (newNodes == null) {
                    if (!oldInstances.contains(archiveInstance)) continue;
                    instancesToRemove.add(archiveInstance);
                    continue;
                }
                Map oldNodes = oldInstanceNodes.row((Object)archiveInstance);
                boolean sameNodes = true;
                if (oldNodes == null || oldNodes.size() != newNodes.size()) {
                    sameNodes = false;
                } else if (oldFormula != newFormula) {
                    sameNodes = false;
                } else {
                    for (String string : newNodes.keySet()) {
                        if (oldNodes.keySet().contains(string)) continue;
                        sameNodes = false;
                        break;
                    }
                }
                this.getToolboxNodes().updateInstance(archiveInstance);
                if (sameNodes) continue;
                this.getToolboxNodes().removeInstances(Collections.singleton(archiveInstance));
                if (newFormula != null) {
                    this.getToolboxNodes().addInstanceFormula(archiveInstance, newFormula);
                }
                for (Map.Entry entry : newNodes.entrySet()) {
                    String key = (String)entry.getKey();
                    Object node = entry.getValue();
                    if (key == null || key.trim().isEmpty() || node == null) continue;
                    newInstanceNodes.put((Object)archiveInstance, (Object)key, node);
                }
            }
            ArrayList allNodes = new ArrayList(new HashSet(newInstanceNodes.values()));
            boolean[] availableNodesArray = this.checkNodeIsAvailable(allNodes);
            HashSet availableNodes = new HashSet();
            int i = 0;
            while (i < availableNodesArray.length) {
                if (availableNodesArray[i]) {
                    availableNodes.add(allNodes.get(i));
                }
                ++i;
            }
            for (VariableInstance archiveInstance : newInstanceNodes.rowKeySet()) {
                for (Map.Entry entry : newInstanceNodes.row((Object)archiveInstance).entrySet()) {
                    String key = (String)entry.getKey();
                    Object v = entry.getValue();
                    this.getToolboxNodes().addInstanceNode(archiveInstance, key, v);
                    if (this.getToolboxNodes().isInAvailableNodes(v) || !this.getToolboxNodes().isInUnavailableNodes(v) && availableNodes.contains(v)) {
                        this.getToolboxNodes().addAvailableToolboxNodeInstance(v, archiveInstance);
                        logger.debug(String.format("Subscribing node %s for instance %s-%s", v, archiveInstance.getVariable(), archiveInstance.getStructureObject()));
                        continue;
                    }
                    this.getToolboxNodes().addUnavailableToolboxNodeInstance(v, archiveInstance);
                    logger.error(String.format("Node %s for archive instance [%s-%s] is not available.", archiveInstance.getVariable(), archiveInstance, v));
                }
            }
            this.getToolboxNodes().removeInstances(instancesToRemove);
            Multimap availableNodeInstances = this.getToolboxNodes().getAvailableNodeInstances();
            if (availableNodeInstances.size() == 0) {
                logger.warningf("Could not initialize read all of %d nodes and have nothing to read for %s", new Object[]{newInstances.size(), this.getName()});
                return false;
            }
            logger.infof("Total nodes subscribed: %s [%s]", new Object[]{availableNodeInstances.size(), this.getName()});
            return true;
        }
        finally {
            this.getToolboxNodes().writeLock.unlock();
        }
    }

    @Override
    public boolean[] checkNodeIsAvailable(ArrayList<N> nodes) {
        boolean[] availableNodes = new boolean[nodes.size()];
        boolean[] presentNodes = this.getClient().getProcessInterface().checkIsPresent(this.getGroup(), nodes);
        LinkedHashMap<Integer, N> checkCanRead = new LinkedHashMap<Integer, N>();
        int i = 0;
        while (i < nodes.size()) {
            N node = nodes.get(i);
            if (!presentNodes[i]) {
                logger.errorf("Node %s is not present.", new Object[]{node});
            } else {
                checkCanRead.put(i, node);
            }
            ++i;
        }
        boolean[] canRead = this.getClient().getProcessInterface().checkCanRead(this.getGroup(), new ArrayList(checkCanRead.values()));
        int index = 0;
        for (Map.Entry entry : checkCanRead.entrySet()) {
            boolean readable = canRead[index++];
            availableNodes[((Integer)entry.getKey()).intValue()] = true;
            if (readable) continue;
            logger.warningf("Node %s is present but currently not readable as a number.", new Object[]{entry.getValue()});
        }
        return availableNodes;
    }

    protected void doStop() {
        try {
            this.getClient().disconnect();
        }
        catch (Exception exc) {
            logger.error("Error during disconnect of client", (Throwable)exc);
        }
    }

    protected boolean canDoWork() {
        try {
            this.getToolboxNodes().readLock.lock();
            boolean bl = !this.getToolboxNodes().getAvailableNodeInstances().isEmpty();
            return bl;
        }
        finally {
            this.getToolboxNodes().readLock.unlock();
        }
    }

    protected Callable<Void> createWorkTask() {
        return () -> {
            Map values;
            Map<VariableInstance, FormulaNode> instanceFormulas;
            Table instanceNodes;
            LinkedHashMultimap activeNodeInstances;
            long timeoutMs;
            long requestTs;
            block25: {
                Multimap availableNodeInstances;
                requestTs = this.getNextExecution();
                timeoutMs = (long)((double)this.getExecutionInterval() * 0.95);
                long maxAgeMs = (long)((double)this.getExecutionInterval() * 0.5);
                activeNodeInstances = LinkedHashMultimap.create();
                try {
                    this.getToolboxNodes().readLock.lock();
                    availableNodeInstances = this.getToolboxNodes().getAvailableNodeInstances();
                    instanceNodes = this.getToolboxNodes().getNodes();
                    instanceFormulas = this.getToolboxNodes().getInstanceFormulas();
                }
                finally {
                    this.getToolboxNodes().readLock.unlock();
                }
                Instant requestTimestamp = Instant.ofEpochMilli(requestTs);
                for (Map.Entry availableNodeInstance : availableNodeInstances.entries()) {
                    if (!((VariableInstance)availableNodeInstance.getValue()).getStructureObject().isPresent(requestTimestamp)) continue;
                    activeNodeInstances.put(availableNodeInstance.getKey(), (Object)((VariableInstance)availableNodeInstance.getValue()));
                }
                if (activeNodeInstances.isEmpty()) {
                    return null;
                }
                values = this.getClient().getProcessInterface().readValues(this.getGroup(), activeNodeInstances.keySet(), requestTs, this.getExecutionInterval(), timeoutMs, maxAgeMs);
                if (values != null && !values.isEmpty()) break block25;
                return null;
            }
            try {
                HashMap<VariableInstance, List<Object>> instanceValues = new HashMap<VariableInstance, List<Object>>();
                block12: for (VariableInstance instance : activeNodeInstances.values()) {
                    Map nodes = instanceNodes.row((Object)instance);
                    long acceptedFromTs = requestTs - MeasurementsPool.POOL_WIDTH;
                    long acceptedToTs = requestTs;
                    switch (instance.getPLCInstanceType()) {
                        case Direct: {
                            Object node;
                            List<MeasuredValue> nodeValues;
                            if (nodes.size() != 1 || (nodeValues = values.get(node = nodes.values().iterator().next())) == null || nodeValues.isEmpty()) continue block12;
                            boolean checkResult = DataReader.checkValues(acceptedFromTs, acceptedToTs, nodeValues);
                            if (!checkResult) {
                                LocalDateTime ldtFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(acceptedFromTs), ZoneId.systemDefault());
                                LocalDateTime ldtTo = LocalDateTime.ofInstant(Instant.ofEpochMilli(acceptedToTs), ZoneId.systemDefault());
                                logger.error(String.format("Measured Values for Variable Instance %s are not in expexted measurement interval [%s - %s] or inconsistent: %s", instance.getFullName(), ldtFrom, ldtTo, nodeValues));
                                break;
                            }
                            ArrayList<MeasuredValue> measuredInstanceValues = new ArrayList<MeasuredValue>();
                            instanceValues.put(instance, measuredInstanceValues);
                            for (MeasuredValue value : nodeValues) {
                                double dVal;
                                if (Double.isFinite(value.getValue())) {
                                    MeasuringUnit datasourceUnit = instance.getResultArchiveMeasuringUnit();
                                    MeasuringUnit variableUnit = instance.getVariable().getMeasuringUnit();
                                    dVal = variableUnit.convert(value.getValue(), datasourceUnit);
                                } else {
                                    dVal = Double.NaN;
                                }
                                measuredInstanceValues.add(value.copy(dVal));
                            }
                            continue block12;
                        }
                        case Calculated: {
                            FormulaNode formula = instanceFormulas.get(instance);
                            HashMap aggregatedValues = new HashMap();
                            List<MeasuredValue> nodeValues = null;
                            boolean checkResult = true;
                            for (Object node : nodes.values()) {
                                nodeValues = values.get(node);
                                if (nodeValues == null || nodeValues.isEmpty()) break;
                                if (!(checkResult &= DataReader.checkValues(acceptedFromTs, acceptedToTs, nodeValues))) continue;
                                aggregatedValues.put(node, DataReader.aggregate(instance.getResultPlcRawValueAggregation(), nodeValues));
                            }
                            if (!checkResult) {
                                LocalDateTime ldtFrom = LocalDateTime.ofInstant(Instant.ofEpochMilli(acceptedFromTs), ZoneId.systemDefault());
                                LocalDateTime ldtTo = LocalDateTime.ofInstant(Instant.ofEpochMilli(acceptedToTs), ZoneId.systemDefault());
                                logger.error(String.format("Measured Values for Variable Instance %s are not in expexted measurement interval [%s - %s] or inconsistent: %s", instance.getFullName(), ldtFrom, ldtTo, nodeValues));
                                break;
                            }
                            Double dVal = this.evaluate(formula, aggregatedValues, nodes);
                            if (dVal != null && Double.isFinite(dVal)) {
                                MeasuringUnit datasourceUnit = instance.getResultArchiveMeasuringUnit();
                                MeasuringUnit variableUnit = instance.getVariable().getMeasuringUnit();
                                dVal = variableUnit.convert(dVal.doubleValue(), datasourceUnit);
                            } else {
                                dVal = Double.NaN;
                            }
                            if (Double.isFinite(dVal)) {
                                instanceValues.put(instance, Collections.singletonList(new MeasuredValue(requestTs - MeasurementsPool.POOL_WIDTH, requestTs, dVal.doubleValue(), 1.0)));
                                break;
                            }
                            instanceValues.put(instance, Collections.singletonList(new MeasuredValue(requestTs - MeasurementsPool.POOL_WIDTH, requestTs, Double.NaN, 0.0)));
                        }
                    }
                }
                MeasurementsPool.appendValues(instanceValues);
                MeasurementsPool.applyChanges((boolean)false);
            }
            catch (TimeoutException exc) {
                logger.error(String.format("Timeout of %d ms reached reading %d values (%s)", timeoutMs, activeNodeInstances.size(), this.getName()));
                throw exc;
            }
            catch (Exception exc) {
                logger.error(String.format("Exception reading %d nodes", activeNodeInstances.size()), (Throwable)exc);
                throw exc;
            }
            Instant now = Instant.now();
            if (now.toEpochMilli() - requestTs > timeoutMs) {
                logger.warning(String.format("Timeout reached on datagroup %s. Execution time %d ms", this.getGroup(), now.toEpochMilli() - requestTs));
            }
            return null;
        };
    }

    /*
     * Unable to fully structure code
     */
    private static boolean checkValues(long fromTs, long toTs, List<MeasuredValue> values) {
        iterator = values.iterator();
        prevValue = iterator.next();
        value = prevValue;
        if (value.getStartTimestamp() >= fromTs && value.getEndTimestamp() > value.getStartTimestamp()) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            value = iterator.next();
            if (value.getEndTimestamp() <= value.getStartTimestamp()) {
                return false;
            }
            if (value.getStartTimestamp() < prevValue.getEndTimestamp()) {
                return false;
            }
            prevValue = value;
lbl12:
            // 2 sources

            ** while (iterator.hasNext())
        }
lbl13:
        // 1 sources

        return value.getEndTimestamp() <= toTs;
    }

    private static MeasuredValue aggregate(Aggregation aggregation, List<MeasuredValue> values) {
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        long startTs = 0L;
        long endTs = 0L;
        double[] dVals = new double[values.size()];
        int i = 0;
        long missingInterval = 0L;
        MeasuredValue prevValue = null;
        for (MeasuredValue value : values) {
            if (i == 0) {
                startTs = value.getStartTimestamp();
            }
            if (prevValue != null) {
                missingInterval += Math.max(0L, value.getStartTimestamp() - prevValue.getEndTimestamp());
            }
            dVals[i++] = value.getValue();
            if (i == values.size()) {
                endTs = value.getEndTimestamp();
            }
            prevValue = value;
        }
        long tsLength = endTs - startTs;
        return new MeasuredValue(startTs, endTs, aggregation.aggregate(dVals), (double)(tsLength - missingInterval) / (double)tsLength);
    }

    private Double evaluate(FormulaNode node, Map<N, MeasuredValue> nodeValues, Map<String, N> nodeNames) {
        switch (node.getType()) {
            case Constant: {
                return (Double)node.getNodeObject();
            }
            case Text: {
                String dataSourceKey = node.getName();
                N nodeId = nodeNames.get(dataSourceKey);
                MeasuredValue value = nodeValues.get(nodeId);
                return value != null && value.isValid() ? Double.valueOf(value.getValue()) : null;
            }
            case Operation: {
                FormulaOperation operation = (FormulaOperation)node.getNodeObject();
                if (operation == FormulaOperation.Map) {
                    int size = node.getParameters().size();
                    if (size <= 3) {
                        return null;
                    }
                    Double arg = this.evaluate((FormulaNode)node.getParameters().get(0), nodeValues, nodeNames);
                    if (arg == null) {
                        return null;
                    }
                    int i = 1;
                    while (i < node.getParameters().size()) {
                        if (size <= i + 1) {
                            return null;
                        }
                        Double testValue = this.evaluate((FormulaNode)node.getParameters().get(i), nodeValues, nodeNames);
                        if (arg instanceof Double && testValue instanceof Double && Double.compare(arg, testValue) == 0) {
                            return this.evaluate((FormulaNode)node.getParameters().get(i + 1), nodeValues, nodeNames);
                        }
                        if (arg instanceof String && testValue instanceof String && ((String)((Object)arg)).equals(testValue)) {
                            return this.evaluate((FormulaNode)node.getParameters().get(i + 1), nodeValues, nodeNames);
                        }
                        i += 2;
                    }
                    return null;
                }
                Double[] params = new Double[node.getParameters().size()];
                int i = 0;
                while (i < params.length) {
                    Double valObj = this.evaluate((FormulaNode)node.getParameters().get(i), nodeValues, nodeNames);
                    if (valObj == null) {
                        return null;
                    }
                    params[i] = valObj;
                    ++i;
                }
                double result = 0.0;
                switch (operation) {
                    case Abs: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return Math.abs(params[0]);
                    }
                    case Div: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] / params[1];
                    }
                    case Mult: {
                        result = 1.0;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Double paramObj = doubleArray[n2];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result *= paramObj.doubleValue();
                            ++n2;
                        }
                        return result;
                    }
                    case Min: {
                        int count = 0;
                        result = Double.POSITIVE_INFINITY;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Double paramObj = doubleArray[n3];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result = Math.min(result, paramObj);
                            ++count;
                            ++n3;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Max: {
                        int count = 0;
                        result = Double.NEGATIVE_INFINITY;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Double paramObj = doubleArray[n4];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result = Math.max(result, paramObj);
                            ++count;
                            ++n4;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Avg: 
                    case Average: {
                        int count = 0;
                        result = 0.0;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int n5 = 0;
                        while (n5 < n) {
                            Double paramObj = doubleArray[n5];
                            if (!(paramObj instanceof Double)) {
                                return null;
                            }
                            result += paramObj.doubleValue();
                            ++count;
                            ++n5;
                        }
                        if (count > 0) {
                            return result / (double)count;
                        }
                        return null;
                    }
                    case Sum: {
                        result = 0.0;
                        Double[] doubleArray = params;
                        int n = params.length;
                        int paramObj = 0;
                        while (paramObj < n) {
                            Double paramObj2 = doubleArray[paramObj];
                            if (!(paramObj2 instanceof Double)) {
                                return null;
                            }
                            result += paramObj2.doubleValue();
                            ++paramObj;
                        }
                        return result;
                    }
                    case Diff: {
                        int i2 = 0;
                        while (i2 < params.length) {
                            if (!(params[i2] instanceof Double)) {
                                return null;
                            }
                            result = i2 == 0 ? params[i2] : (result -= params[i2].doubleValue());
                            ++i2;
                        }
                        return result;
                    }
                    case Eq: {
                        boolean eq = true;
                        Double prevValue = params[0];
                        int i3 = 1;
                        while (i3 < params.length) {
                            Double nextValue = params[i3];
                            if (prevValue instanceof Double && nextValue instanceof Double) {
                                eq &= Double.compare(prevValue, nextValue) == 0;
                            } else if (prevValue instanceof String && nextValue instanceof String) {
                                eq &= ((String)((Object)prevValue)).equals(nextValue);
                            } else {
                                return null;
                            }
                            ++i3;
                        }
                        return eq ? 1.0 : 0.0;
                    }
                    case If: {
                        if (params.length != 3 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return params[0] != 0.0 ? params[1] : params[2];
                    }
                    case Gt: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] > params[1] ? 1.0 : 0.0;
                    }
                    case Ge: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] >= params[1] ? 1.0 : 0.0;
                    }
                    case Lt: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] < params[1] ? 1.0 : 0.0;
                    }
                    case Le: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return params[0] <= params[1] ? 1.0 : 0.0;
                    }
                    case Power: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return Math.pow(params[0], params[1]);
                    }
                }
                return null;
            }
        }
        return null;
    }
}

