/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataGroupType;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.IHistorizableProcessInterface;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.ProcessInterfaceWrapper;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.datasource.component.DataSourceServer;
import de.elpro.ewms.server.db.rawmeasurements.MeasurementsStorageUtils;
import de.elpro.ewms.server.logger.LogDB;
import de.elpro.ewms.server.storage.MeasurementsStorage;
import de.elpro.ui.formats.TimeFormatType;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.fx.core.log.Logger;

public class DataSourceUtils {
    private static final Object IMPORT_HIST_VALUES_SYNC_OBJ = new Object();
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataSourceUtils.class.getCanonicalName());
    private static final int MAX_NODES_PER_REQEST = Math.max(1, Integer.parseInt(System.getProperty("datasource.historical_import.max_nodes_per_request", "50")));
    private static final int MAX_INTERVALS_PER_INSTANCE = Math.max(1, Integer.parseInt(System.getProperty("datasource.historical_import.max_intervals_per_instance", "12")));
    private static final int FLUSH_RECORDS = 200000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long importHistoricalValues(Instant from, Instant to, Raster step) throws Exception {
        Object object = IMPORT_HIST_VALUES_SYNC_OBJ;
        synchronized (object) {
            LocalDateTime localFrom = LocalDateTime.ofInstant(from, ZoneOffset.systemDefault());
            LocalDateTime localTo = LocalDateTime.ofInstant(to, ZoneOffset.systemDefault());
            logger.debugf("Try import historical data for time range from %s to %s", new Object[]{TimeFormatType.DateTimeHMs.format((TemporalAccessor)localFrom), TimeFormatType.DateTimeHMs.format((TemporalAccessor)localTo)});
            long fromTs = from.toEpochMilli();
            long toTs = to.toEpochMilli();
            if (toTs <= fromTs) {
                throw new IllegalArgumentException();
            }
            long stepBegin = fromTs;
            long stepEnd = Math.min(toTs, step.getRasterEnd(fromTs));
            if (stepEnd == fromTs) {
                stepEnd += step.toMilli();
            }
            long importedValuesCount = 0L;
            HashBasedTable isHistorizing = HashBasedTable.create();
            while (stepBegin < toTs) {
                importedValuesCount += DataSourceUtils.importHistoricalValues(Instant.ofEpochMilli(stepBegin), Instant.ofEpochMilli(stepEnd), isHistorizing);
                stepBegin = stepEnd;
                stepEnd = Math.min(toTs, stepEnd + step.toMilli());
            }
            return importedValuesCount;
        }
    }

    private static long importHistoricalValues(Instant from, Instant to, Table<AbstractToolboxConnector<?>, Object, Boolean> isHistorizing) throws Exception {
        LocalDateTime localFrom = LocalDateTime.ofInstant(from, ZoneOffset.systemDefault());
        LocalDateTime localTo = LocalDateTime.ofInstant(to, ZoneOffset.systemDefault());
        logger.debugf("Partial import of historical data for time range from %s to %s", new Object[]{TimeFormatType.DateTimeHMs.format((TemporalAccessor)localFrom), TimeFormatType.DateTimeHMs.format((TemporalAccessor)localTo)});
        HashSet connectedInstances = new HashSet();
        for (AbstractToolboxConnector<?> connector : DataSourceServer.getToolboxConnectors()) {
            DataClient<?> client = connector.getClient();
            if (client.getState() != DataClientState.Connected) continue;
            IProcessInterface pi = client.getProcessInterface();
            if (pi instanceof ProcessInterfaceWrapper) {
                pi = ((ProcessInterfaceWrapper)pi).getCurrentInterface();
            }
            if (!(pi instanceof IHistorizableProcessInterface)) continue;
            connectedInstances.addAll(connector.getToolboxNodes().getAvailableNodeInstances().values());
            DataSourceUtils.activateUnavailableNodes(connector, true);
        }
        Map instanceMissingIntervals = MeasurementsStorage.getInstance().getMissingIntervals(connectedInstances, from.toEpochMilli(), to.toEpochMilli());
        for (Map.Entry entry : instanceMissingIntervals.entrySet()) {
            TsIntervals intervals = (TsIntervals)entry.getValue();
            if (intervals == null || intervals.getIntervals().size() <= MAX_INTERVALS_PER_INSTANCE) continue;
            ArrayList intervalsList = (ArrayList)intervals.getIntervals();
            while (intervals.getIntervals().size() > MAX_INTERVALS_PER_INSTANCE) {
                long dist = ((TsInterval)intervalsList.get(1)).getFromTs() - ((TsInterval)intervalsList.get(0)).getToTs();
                int index = 0;
                int i = 1;
                while (i < intervalsList.size() - 1) {
                    long distCandidate = ((TsInterval)intervalsList.get(i + 1)).getFromTs() - ((TsInterval)intervalsList.get(i)).getToTs();
                    if (distCandidate < dist) {
                        dist = distCandidate;
                        index = i;
                    }
                    ++i;
                }
                TsInterval interval = (TsInterval)intervalsList.get(index);
                TsInterval nextInterval = (TsInterval)intervalsList.remove(index + 1);
                intervalsList.set(index, new TsInterval(interval.getFromTs(), nextInterval.getToTs()));
            }
        }
        HashMultimap hashMultimap = HashMultimap.create();
        instanceMissingIntervals.forEach((arg_0, arg_1) -> DataSourceUtils.lambda$0((Multimap)hashMultimap, arg_0, arg_1));
        long importedValuesCount = 0L;
        for (AbstractToolboxConnector<?> connector : DataSourceServer.getToolboxConnectors()) {
            try {
                importedValuesCount += DataSourceUtils.importHistoricalValues((Multimap<TsIntervals, VariableInstance>)hashMultimap, isHistorizing, connector);
            }
            catch (Exception exc) {
                logger.errorf("Error importing connector '%s' data", (Throwable)exc, new Object[]{connector.getName()});
            }
        }
        return importedValuesCount;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static <N> long importHistoricalValues(Multimap<TsIntervals, VariableInstance> missingIntervals, Table<AbstractToolboxConnector<?>, Object, Boolean> isHistorizing, AbstractToolboxConnector<N> connector) throws Exception {
        client = connector.getClient();
        if (client.getState() != DataClientState.Connected) {
            return 0L;
        }
        pi = client.getProcessInterface();
        if (pi instanceof ProcessInterfaceWrapper) {
            pi = ((ProcessInterfaceWrapper)pi).getCurrentInterface();
        }
        hpi = null;
        if (!(pi instanceof IHistorizableProcessInterface)) {
            return 0L;
        }
        hpi = (IHistorizableProcessInterface)pi;
        dg = connector.getGroup();
        raster = dg.getSampleRaster();
        if (dg.getType() != DataGroupType.Read || dg.isDisableHistoricalImport()) {
            return 0L;
        }
        connectedNodes = connector.getToolboxNodes().getAvailableNodeInstances();
        checkHistorizingNodes = connectedNodes.keys().stream().filter((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(com.google.common.collect.Table de.elpro.ewms.server.datasource.AbstractToolboxConnector java.lang.Object ), (Ljava/lang/Object;)Z)(isHistorizing, connector)).collect(Collectors.toSet());
        hpi.isHistorizing(dg.getResultNamespace(client.getProcessInterface().getDataSource()), dg.getPropertiesDefinition(), checkHistorizingNodes).forEach((BiConsumer<Object, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$2(com.google.common.collect.Table de.elpro.ewms.server.datasource.AbstractToolboxConnector java.lang.Object java.lang.Boolean ), (Ljava/lang/Object;Ljava/lang/Boolean;)V)(isHistorizing, connector));
        connectedInstances = new HashMap<VariableInstance, K>();
        for (Map.Entry entry : connectedNodes.entries()) {
            connectedInstances.put((VariableInstance)entry.getValue(), entry.getKey());
        }
        DataSourceUtils.printMissingIntervalsMsg(dg, missingIntervals, connectedInstances, isHistorizing.row(connector));
        stats = new ImportStitistics<V>(missingIntervals, connectedInstances, isHistorizing.row(connector));
        importedValuesCount = 0L;
        measuredValuesCount = 0;
        importValues = new HashMap<VariableInstance, IVarValuesCollection>();
        try {
            for (Map.Entry<K, V> missingIntervalsEntry : missingIntervals.asMap().entrySet()) {
                intervals = (TsIntervals)missingIntervalsEntry.getKey();
                instances = (Collection)missingIntervalsEntry.getValue();
                if (intervals.isEmpty()) continue;
                filteredInstances = instances.stream().filter((Predicate<VariableInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$4(java.util.Map de.elpro.ewms.core.variable.VariableInstance ), (Lde/elpro/ewms/core/variable/VariableInstance;)Z)(connectedInstances)).collect(Collectors.toSet());
                requestNodes = new HashSet<Object>();
                for (VariableInstance instance : filteredInstances) {
                    nodeId = connectedInstances.get(instance);
                    nodeHistorizable = (Boolean)isHistorizing.get(connector, nodeId);
                    if (nodeHistorizable == null || !nodeHistorizable.booleanValue()) continue;
                    requestNodes.add(nodeId);
                }
                if (requestNodes.isEmpty()) continue;
                nodesPool = new LinkedList<E>(requestNodes);
                requestNodes.clear();
                ** GOTO lbl96
                {
                    requestNodes.add(nodesPool.removeFirst());
                    do {
                        if (requestNodes.size() < DataSourceUtils.MAX_NODES_PER_REQEST && !nodesPool.isEmpty()) continue block7;
                        for (TsInterval interval : intervals.getIntervals()) {
                            importFrom = Instant.ofEpochMilli(raster.getRasterBegin(interval.getFromTs()));
                            importTo = Instant.ofEpochMilli(raster.getRasterEnd(interval.getToTs()));
                            historicalValues = null;
                            try {
                                historicalValues = hpi.readHistoricalValues(dg.getResultNamespace(client.getProcessInterface().getDataSource()), dg.getPropertiesDefinition(), requestNodes, importFrom, importTo, dg.getSampleRaster());
                                stats.updateStats(requestNodes, historicalValues);
                                lm = stats.getIntermidiateMessage();
                                if (lm != null) {
                                    DataSourceUtils.logger.debug(lm.getMessage());
                                    LogDB.addMessage((LogMessage)lm);
                                }
                            }
                            catch (Exception exc) {
                                DataSourceUtils.logger.error("Error reading historical data", (Throwable)exc);
                            }
                            if (historicalValues == null) continue;
                            for (E nodeId : requestNodes) {
                                instances = connectedNodes.get(nodeId);
                                nodeValuesList = historicalValues.get(nodeId);
                                if (nodeValuesList == null || nodeValuesList.isEmpty()) continue;
                                for (VariableInstance instance : instances) {
                                    datasourceUnit = instance.getResultArchiveMeasuringUnit();
                                    variableUnit = instance.getVariable().getMeasuringUnit();
                                    mvals = (IVarValuesCollection)importValues.get(instance);
                                    if (mvals == null) {
                                        mvals = new IVarValuesCollection();
                                        importValues.put(instance, mvals);
                                    }
                                    for (IVarValue val : nodeValuesList) {
                                        mv = (MeasuredValue)val;
                                        if (!datasourceUnit.equals((Object)variableUnit)) {
                                            mv = mv.copy(variableUnit.convert(mv.getValue(), datasourceUnit));
                                        }
                                        mvals.add((IVarValue)mv);
                                        ++measuredValuesCount;
                                    }
                                }
                            }
                        }
                        requestNodes.clear();
                        if (measuredValuesCount < 200000) continue;
                        DataSourceUtils.logger.infof("Flush import of %d values", new Object[]{measuredValuesCount});
                        importValues.values().forEach((Consumer<IVarValuesCollection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$5(de.elpro.ewms.core.variable.value.IVarValuesCollection ), (Lde/elpro/ewms/core/variable/value/IVarValuesCollection;)V)());
                        MeasurementsStorageUtils.importMeasurements((long)0x7FFFFFFFFFFFFFFFL, importValues, (boolean)true);
                        importValues.clear();
                        importedValuesCount += (long)measuredValuesCount;
                        measuredValuesCount = 0;
lbl96:
                        // 3 sources

                    } while (!nodesPool.isEmpty());
                }
            }
            lm = stats.getLogMessage();
            if (lm != null) {
                DataSourceUtils.logger.debug(lm.getMessage());
                LogDB.addMessage((LogMessage)lm);
            }
            if (measuredValuesCount > 0) {
                DataSourceUtils.logger.infof("Flush import of %d values", new Object[]{measuredValuesCount});
                importValues.values().forEach((Consumer<IVarValuesCollection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$6(de.elpro.ewms.core.variable.value.IVarValuesCollection ), (Lde/elpro/ewms/core/variable/value/IVarValuesCollection;)V)());
                MeasurementsStorageUtils.importMeasurements((long)0x7FFFFFFFFFFFFFFFL, importValues, (boolean)true);
                importValues.clear();
                importedValuesCount += (long)measuredValuesCount;
            }
        }
        catch (Throwable var39_40) {
            importValues.values().forEach((Consumer<IVarValuesCollection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$3(de.elpro.ewms.core.variable.value.IVarValuesCollection ), (Lde/elpro/ewms/core/variable/value/IVarValuesCollection;)V)());
            throw var39_40;
        }
        importValues.values().forEach((Consumer<IVarValuesCollection>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$3(de.elpro.ewms.core.variable.value.IVarValuesCollection ), (Lde/elpro/ewms/core/variable/value/IVarValuesCollection;)V)());
        return importedValuesCount;
    }

    public static <N> void activateUnavailableNodes(AbstractToolboxConnector<N> toolboxConnector) {
        DataSourceUtils.activateUnavailableNodes(toolboxConnector, false);
    }

    public static <N> void activateUnavailableNodes(AbstractToolboxConnector<N> toolboxConnector, boolean silent) {
        LinkedList<N> reactivatedNodes = new LinkedList<N>();
        ArrayList<N> unavailalbleNodes = new ArrayList<N>(toolboxConnector.getToolboxNodes().getUnavailableNodes());
        boolean[] nodesAvailable = toolboxConnector.checkNodeIsAvailable(unavailalbleNodes);
        int i = 0;
        while (i < unavailalbleNodes.size()) {
            if (nodesAvailable[i]) {
                N node2 = unavailalbleNodes.get(i);
                reactivatedNodes.add(node2);
            }
            ++i;
        }
        if (!reactivatedNodes.isEmpty()) {
            toolboxConnector.getToolboxNodes().activateNodes(reactivatedNodes);
            if (!silent) {
                reactivatedNodes.forEach(node -> logger.debug(String.format("Activate %s", node)));
            }
        }
    }

    private static <N> void printMissingIntervalsMsg(DataGroup dataGroup, Multimap<TsIntervals, VariableInstance> missingIntervals, Map<VariableInstance, N> instanceNodes, Map<Object, Boolean> isHistorizing) {
        if (!instanceNodes.isEmpty()) {
            int count = 0;
            StringBuilder missingIntervalsMsg = new StringBuilder("");
            for (Map.Entry entry : missingIntervals.entries()) {
                N nodeId = instanceNodes.get(entry.getValue());
                Boolean nodeHistorizable = isHistorizing.get(nodeId);
                if (nodeHistorizable == null || !nodeHistorizable.booleanValue()) continue;
                for (TsInterval interval : ((TsIntervals)entry.getKey()).getIntervals()) {
                    if (++count < 30) {
                        if (missingIntervalsMsg.length() != 0) {
                            missingIntervalsMsg.append("\r\n");
                        }
                        missingIntervalsMsg.append(String.format("%s -> %s", ((VariableInstance)entry.getValue()).getFullName(), interval.toString()));
                        continue;
                    }
                    if (count != 30) continue;
                    missingIntervalsMsg.append("\r\n ...");
                }
            }
            if (count > 0) {
                StringBuilder msg = new StringBuilder(String.format("Found %d missing intervals for historizable signal nodes at %s (%s)\r\n", count, dataGroup.getDataSource().toString(), dataGroup.toString()));
                msg.append(missingIntervalsMsg.toString());
                LogMessage logMessage = new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, "Historical Import", msg.toString());
                LogDB.addMessage((LogMessage)logMessage);
                logger.info(msg.toString());
            }
        }
    }

    private static /* synthetic */ void lambda$0(Multimap multimap, VariableInstance instance, TsIntervals intervals) {
        boolean bl = multimap.put((Object)intervals, (Object)instance);
    }

    private static /* synthetic */ boolean lambda$1(Table table, AbstractToolboxConnector abstractToolboxConnector, Object n) {
        return !table.row((Object)abstractToolboxConnector).keySet().contains(n);
    }

    private static /* synthetic */ void lambda$2(Table table, AbstractToolboxConnector abstractToolboxConnector, Object n, Boolean historizing) {
        Object object = table.put((Object)abstractToolboxConnector, n, (Object)historizing);
    }

    private static /* synthetic */ boolean lambda$4(Map map, VariableInstance i) {
        return map.containsKey(i);
    }

    private static /* synthetic */ void lambda$5(IVarValuesCollection c) {
        c.close();
    }

    private static /* synthetic */ void lambda$6(IVarValuesCollection c) {
        c.close();
    }

    private static /* synthetic */ void lambda$3(IVarValuesCollection c) {
        c.close();
    }

    private static class ImportStitistics<N> {
        private final long initialTime;
        private long time;
        private int importedValues;
        private int stepsDone;
        private final int totalSteps;
        private boolean updated;

        public ImportStitistics(Multimap<TsIntervals, VariableInstance> missingIntervals, Map<VariableInstance, N> connectedInstances, Map<Object, Boolean> isHistorizing) {
            this.time = this.initialTime = System.nanoTime();
            this.importedValues = 0;
            this.stepsDone = 0;
            this.updated = false;
            int totalSteps = 0;
            for (Map.Entry missingIntervalsEntry : missingIntervals.asMap().entrySet()) {
                TsIntervals intervals = (TsIntervals)missingIntervalsEntry.getKey();
                Collection instances = (Collection)missingIntervalsEntry.getValue();
                if (intervals.isEmpty()) continue;
                Set filteredInstances = instances.stream().filter(i -> connectedInstances.containsKey(i)).collect(Collectors.toSet());
                HashSet<N> filteredNodes = new HashSet<N>();
                for (VariableInstance instance : filteredInstances) {
                    N nodeId = connectedInstances.get(instance);
                    Boolean nodeHistorizable = isHistorizing.get(nodeId);
                    if (nodeHistorizable != null && !nodeHistorizable.booleanValue()) continue;
                    filteredNodes.add(nodeId);
                }
                int intervalSteps = filteredNodes.size() / MAX_NODES_PER_REQEST;
                if (intervalSteps * MAX_NODES_PER_REQEST < filteredNodes.size()) {
                    ++intervalSteps;
                }
                totalSteps += intervalSteps * intervals.getIntervals().size();
            }
            this.totalSteps = totalSteps;
        }

        public void updateStats(Set<N> requestNodes, Map<N, IVarValuesCollection> historicalValues) {
            ++this.stepsDone;
            for (N nodeId : requestNodes) {
                IVarValuesCollection values = historicalValues.get(nodeId);
                this.importedValues += values.size();
            }
            this.updated = true;
        }

        public LogMessage getLogMessage() {
            if (!this.updated) {
                return null;
            }
            long now = System.nanoTime();
            long span = now - this.initialTime;
            double sek = (double)span / 1.0E9;
            double done = (double)this.stepsDone / (double)this.totalSteps * 100.0;
            String msg = String.format("%s values imported in %.1f seconds (%.1f%% done)", this.importedValues, sek, done);
            this.time = now;
            this.updated = false;
            return new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, "Historical Import", msg);
        }

        public LogMessage getIntermidiateMessage() {
            long now = System.nanoTime();
            if (now - this.time > 10000000000L) {
                return this.getLogMessage();
            }
            return null;
        }
    }
}

