/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataGroupType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.valueswriter.MeasurementsPool;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import org.eclipse.fx.core.log.Logger;

class DataWriter<N>
extends AbstractToolboxConnector<N> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataWriter.class.getName());
    private static final String ID_PREFIX = "datawriter-";

    public DataWriter(DataClient<N> client, DataGroup group) {
        super(ID_PREFIX, client, group);
    }

    @Override
    protected boolean updateToolboxNodes() {
        DataGroup dataGroup = this.getGroup();
        HashSet<VariableInstance> newInstances = new HashSet<VariableInstance>(this.getClient().getInstances(dataGroup));
        try {
            this.getToolboxNodes().writeLock.lock();
            Table oldInstanceNodes = this.getToolboxNodes().getNodes();
            Set oldInstances = oldInstanceNodes.rowKeySet();
            if (newInstances.isEmpty()) {
                this.getToolboxNodes().removeInstances(oldInstances);
                logger.warningf("Write group is empty. Nothing to write for %s", new Object[]{this.getName()});
                return true;
            }
            for (VariableInstance archiveInstance : newInstances) {
                Object node;
                if (archiveInstance.getWriteValuesSource() == null) {
                    logger.error(String.format("No Write Values Source for write archive instance [%s] specified", archiveInstance.getFullName()));
                    continue;
                }
                VariableInstance writeValuesSource = ORMCache.getVariableInstance((int)archiveInstance.getWriteValuesSource().getId());
                if (!writeValuesSource.getVariable().getPhysicalUnit().equals((Object)archiveInstance.getVariable().getPhysicalUnit())) {
                    logger.error(String.format("Write archive instance [%s] and their values source [%s] are of different physical units", archiveInstance.getFullName(), writeValuesSource.getFullName()));
                    continue;
                }
                String dataSourceKey = archiveInstance.getResultPlcDatasourceKey();
                try {
                    if (dataSourceKey == null || dataSourceKey.trim().isEmpty()) continue;
                    dataSourceKey = dataSourceKey.trim();
                    node = this.getClient().getProcessInterface().createNodes(dataGroup, Collections.singletonList(dataSourceKey)).get(dataSourceKey);
                }
                catch (Exception exc) {
                    logger.error(String.format("Error creating NodeId for archive instance [%s-%s]", archiveInstance.getVariable(), archiveInstance), (Throwable)exc);
                    continue;
                }
                ArrayList singleNode = new ArrayList();
                singleNode.add(node);
                this.getToolboxNodes().removeInstances(Collections.singleton(archiveInstance));
                this.getToolboxNodes().addInstanceNode(archiveInstance, dataSourceKey, node);
                if (this.getToolboxNodes().isInAvailableNodes(node) || !this.getToolboxNodes().isInUnavailableNodes(node) && this.checkNodeIsAvailable(singleNode)[0]) {
                    this.getToolboxNodes().addAvailableToolboxNodeInstance(node, archiveInstance);
                    continue;
                }
                this.getToolboxNodes().addUnavailableToolboxNodeInstance(node, archiveInstance);
                logger.error(String.format("Node %s for archive instance [%s-%s] is not available.", archiveInstance.getVariable(), archiveInstance, node));
            }
            Multimap availableNodeInstances = this.getToolboxNodes().getAvailableNodeInstances();
            if (availableNodeInstances.size() == 0) {
                logger.warningf("Could not initialize all of %d read nodes and have nothing to write for %s", new Object[]{newInstances.size(), this.getName()});
                return false;
            }
            for (Map.Entry entry : availableNodeInstances.entries()) {
                Object node = entry.getKey();
                VariableInstance instance = (VariableInstance)entry.getValue();
                logger.debug(String.format("Subscribing node %s for instance %s-%s", node, instance.getVariable(), instance.getStructureObject()));
            }
            logger.infof("Total nodes subscribed: %s [%s]", new Object[]{availableNodeInstances.size(), this.getName()});
            return true;
        }
        finally {
            this.getToolboxNodes().writeLock.unlock();
        }
    }

    @Override
    public boolean[] checkNodeIsAvailable(ArrayList<N> nodes) {
        boolean[] isPresent = this.getClient().getProcessInterface().checkIsPresent(this.getGroup(), nodes);
        return isPresent;
    }

    protected void doStop() {
        try {
            this.getClient().disconnect();
        }
        catch (Exception exc) {
            logger.error("Error during disconnect of client", (Throwable)exc);
        }
    }

    protected Callable<Void> createWorkTask() {
        return () -> {
            HashBasedTable values;
            LinkedHashMultimap activeNodeInstances;
            long timeoutMs;
            long requestTs;
            block18: {
                Multimap availableNodeInstances;
                requestTs = this.getNextExecution();
                timeoutMs = (long)((double)this.getExecutionInterval() * 0.95);
                Raster sampleRaster = this.getGroup().getSampleRaster();
                activeNodeInstances = LinkedHashMultimap.create();
                try {
                    this.getToolboxNodes().readLock.lock();
                    availableNodeInstances = this.getToolboxNodes().getAvailableNodeInstances();
                }
                finally {
                    this.getToolboxNodes().readLock.unlock();
                }
                Instant requestTimestamp = Instant.ofEpochMilli(requestTs);
                for (Map.Entry availableNodeInstance : availableNodeInstances.entries()) {
                    if (!((VariableInstance)availableNodeInstance.getValue()).getStructureObject().isPresent(requestTimestamp)) continue;
                    activeNodeInstances.put(availableNodeInstance.getKey(), (Object)((VariableInstance)availableNodeInstance.getValue()));
                }
                RasterizedValues rasterizedValues = Server.getRawValuesViews().getValuesView(this.getGroup().getWriteValueSource(), null);
                if (rasterizedValues == null || rasterizedValues.getComputationBounds() == null) {
                    return null;
                }
                values = HashBasedTable.create();
                ArrayList nodes = new ArrayList();
                ArrayList writeInstances = new ArrayList();
                activeNodeInstances.forEach((node, writeInstance) -> {
                    nodes.add(node);
                    writeInstances.add(writeInstance);
                });
                long writeValueMaxAge = (long)Math.max(0, this.getGroup().getWriteValueLastValidValueSearchTimespan()) * rasterizedValues.getRaster().toMilli();
                IVarValue[] lastCoreValues = rasterizedValues.getLastValidValueSync((VariableInstance[])writeInstances.stream().map(i -> i.getWriteValuesSource()).toArray(VariableInstance[]::new), writeValueMaxAge);
                int i2 = 0;
                while (i2 < writeInstances.size()) {
                    IVarValue value = lastCoreValues[i2];
                    VariableInstance writeInstance2 = (VariableInstance)writeInstances.get(i2);
                    VariableInstance sourceInstance = writeInstance2.getWriteValuesSource();
                    if (value.isValid()) {
                        double plcValue = writeInstance2.getResultArchiveMeasuringUnit().convert(value.getValue(), sourceInstance.getVariable().getMeasuringUnit());
                        value = new VarValue(value.getEndTimestamp(), plcValue, value.getQuality(), value.getValueSource());
                    }
                    values.put(nodes.get(i2), (Object)((VariableInstance)writeInstances.get(i2)), (Object)value);
                    ++i2;
                }
                if (this.getGroup().getType() == DataGroupType.WriteAndLog) {
                    HashMap<VariableInstance, List<MeasuredValue>> writeValues = new HashMap<VariableInstance, List<MeasuredValue>>();
                    long valueEndTs = sampleRaster.getRasterEnd(requestTs);
                    long valueStartTs = valueEndTs - sampleRaster.toMilli();
                    int i3 = 0;
                    while (i3 < writeInstances.size()) {
                        IVarValue value = lastCoreValues[i3];
                        VariableInstance writeInstance3 = (VariableInstance)writeInstances.get(i3);
                        VariableInstance sourceInstance = writeInstance3.getWriteValuesSource();
                        if (value.isValid()) {
                            double archivValue = writeInstance3.getVariable().getMeasuringUnit().convert(value.getValue(), sourceInstance.getVariable().getMeasuringUnit());
                            writeValues.put(writeInstance3, Collections.singletonList(new MeasuredValue(valueStartTs, valueEndTs, archivValue, value.getQuality())));
                        }
                        ++i3;
                    }
                    if (!writeValues.isEmpty()) {
                        MeasurementsPool.appendValues(writeValues);
                    }
                }
                if (!values.isEmpty()) break block18;
                return null;
            }
            try {
                Map<VariableInstance, Boolean> result = this.getClient().getProcessInterface().writeValues(this.getGroup(), values, requestTs, this.getExecutionInterval(), timeoutMs);
                Object[] errorInstances = (VariableInstance[])result.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(entry -> (VariableInstance)entry.getKey()).toArray(VariableInstance[]::new);
                if (errorInstances.length != 0) {
                    throw new Exception(String.format("Cannot write values for instances %s", Arrays.toString(errorInstances)));
                }
            }
            catch (TimeoutException exc) {
                logger.error(String.format("Timeout of %d ms reached reading %d values (%s)", timeoutMs, activeNodeInstances.size(), this.getName()));
                throw exc;
            }
            catch (Exception exc) {
                logger.error(String.format("Exception writing %d nodes", activeNodeInstances.size()), (Throwable)exc);
                throw exc;
            }
            Instant now = Instant.now();
            if (now.toEpochMilli() - requestTs > timeoutMs) {
                logger.warning(String.format("Timeout reached on datagroup %s. Execution time %d ms", this.getGroup(), now.toEpochMilli() - requestTs));
            }
            return null;
        };
    }

    protected boolean canDoWork() {
        try {
            this.getToolboxNodes().readLock.lock();
            boolean bl = !this.getToolboxNodes().getAvailableNodeInstances().isEmpty();
            return bl;
        }
        finally {
            this.getToolboxNodes().readLock.unlock();
        }
    }
}

