/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public interface IProcessInterface<N> {
    public IDataSource getDataSource();

    public OperationResult doConnect();

    public void doDisconnect();

    public DataClientState getState();

    public SignalId[] getSignals(SignalId var1) throws ExecutionException, UnsupportedOperationException;

    public SignalId getFullSignalDefinition(SignalId var1) throws ExecutionException;

    public SignalDataValue getCurrentValue(SignalId var1) throws ExecutionException;

    public Map<String, N> createNodes(DataGroup var1, Collection<String> var2) throws Exception;

    public boolean[] checkIsPresent(DataGroup var1, ArrayList<N> var2);

    public boolean[] checkCanRead(DataGroup var1, ArrayList<N> var2);

    public Map<N, List<MeasuredValue>> readValues(DataGroup var1, Set<N> var2, long var3, long var5, long var7, long var9) throws TimeoutException, ExecutionException, InterruptedException, IOException;

    public Map<VariableInstance, Boolean> writeValues(DataGroup var1, Table<N, VariableInstance, IVarValue> var2, long var3, long var5, long var7) throws TimeoutException, ExecutionException, InterruptedException, IOException;
}

