/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.MeasuredValue;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.bundle.Activator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.fx.core.log.Logger;

public class ProcessInterfaceWrapper<N>
implements IProcessInterface<N> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ProcessInterfaceWrapper.class.getName());
    private final IProcessInterface<N> masterInterface;
    private final List<IProcessInterface<N>> slaveInterfaces;
    private IProcessInterface<N> currentInterface;
    private int nextSlaveInterfaceIndex = 0;

    public ProcessInterfaceWrapper(IProcessInterface<N> masterInterface, List<IProcessInterface<N>> slaveInterfaces) {
        this.masterInterface = masterInterface;
        this.slaveInterfaces = slaveInterfaces;
        this.currentInterface = masterInterface;
    }

    public synchronized IProcessInterface<N> getCurrentInterface() {
        return this.currentInterface;
    }

    public synchronized void switchToAlternativeProcessInterface() {
        if (this.slaveInterfaces.isEmpty()) {
            return;
        }
        if (this.nextSlaveInterfaceIndex >= this.slaveInterfaces.size()) {
            this.currentInterface = this.masterInterface;
            this.nextSlaveInterfaceIndex = 0;
            logger.info(String.format("Switching to master process interface '%s'", this.currentInterface.getDataSource()));
        } else {
            this.currentInterface = this.slaveInterfaces.get(this.nextSlaveInterfaceIndex++);
            logger.info(String.format("Switching to alternative process interface '%s'", this.currentInterface.getDataSource()));
        }
    }

    @Override
    public IDataSource getDataSource() {
        return this.getCurrentInterface().getDataSource();
    }

    @Override
    public OperationResult doConnect() {
        return this.getCurrentInterface().doConnect();
    }

    @Override
    public void doDisconnect() {
        this.getCurrentInterface().doDisconnect();
    }

    @Override
    public DataClientState getState() {
        return this.getCurrentInterface().getState();
    }

    @Override
    public SignalId[] getSignals(SignalId rootNode) throws ExecutionException, UnsupportedOperationException {
        return this.getCurrentInterface().getSignals(rootNode);
    }

    @Override
    public SignalId getFullSignalDefinition(SignalId signalId) throws ExecutionException {
        return this.getCurrentInterface().getFullSignalDefinition(signalId);
    }

    @Override
    public SignalDataValue getCurrentValue(SignalId node) throws ExecutionException {
        return this.getCurrentInterface().getCurrentValue(node);
    }

    @Override
    public Map<String, N> createNodes(DataGroup group, Collection<String> dataSourceKeys) throws Exception {
        return this.getCurrentInterface().createNodes(group, dataSourceKeys);
    }

    @Override
    public boolean[] checkIsPresent(DataGroup group, ArrayList<N> toolboxNode) {
        return this.getCurrentInterface().checkIsPresent(group, toolboxNode);
    }

    @Override
    public boolean[] checkCanRead(DataGroup group, ArrayList<N> toolboxNode) {
        return this.getCurrentInterface().checkCanRead(group, toolboxNode);
    }

    @Override
    public Map<N, List<MeasuredValue>> readValues(DataGroup group, Set<N> nodes, long requestTs, long executionInterval, long timeoutMs, long maxAgeMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        return this.getCurrentInterface().readValues(group, nodes, requestTs, executionInterval, timeoutMs, maxAgeMs);
    }

    @Override
    public Map<VariableInstance, Boolean> writeValues(DataGroup group, Table<N, VariableInstance, IVarValue> writeValues, long requestTs, long executionInterval, long timeoutMs) throws TimeoutException, ExecutionException, InterruptedException, IOException {
        return this.getCurrentInterface().writeValues(group, writeValues, requestTs, executionInterval, timeoutMs);
    }
}

