/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ToolboxNodes<N> {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    final Lock readLock = this.readWriteLock.readLock();
    final Lock writeLock = this.readWriteLock.writeLock();
    private final DataGroup group;
    private final Multimap<N, VariableInstance> availableNodeInstances;
    private final Multimap<N, VariableInstance> unavailableNodeInstances;
    private final Table<VariableInstance, String, N> instanceNodes;
    private final Map<VariableInstance, FormulaNode> instanceFormulas;

    public ToolboxNodes(DataGroup group) {
        this.group = group;
        this.availableNodeInstances = LinkedHashMultimap.create();
        this.unavailableNodeInstances = LinkedHashMultimap.create();
        this.instanceNodes = HashBasedTable.create();
        this.instanceFormulas = new HashMap<VariableInstance, FormulaNode>();
    }

    void clear() {
        try {
            this.writeLock.lock();
            this.availableNodeInstances.clear();
            this.unavailableNodeInstances.clear();
            this.instanceNodes.clear();
            this.instanceFormulas.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void addInstanceNode(VariableInstance instance, String dataSourceKey, N node) {
        this.instanceNodes.put((Object)instance, (Object)dataSourceKey, node);
    }

    void addAvailableToolboxNodeInstance(N node, VariableInstance instance) {
        this.availableNodeInstances.put(node, (Object)instance);
    }

    void addUnavailableToolboxNodeInstance(N node, VariableInstance instance) {
        this.unavailableNodeInstances.put(node, (Object)instance);
    }

    boolean isInAvailableNodes(N node) {
        return this.availableNodeInstances.containsKey(node);
    }

    boolean isInUnavailableNodes(N node) {
        return this.unavailableNodeInstances.containsKey(node);
    }

    Table<VariableInstance, String, N> getNodes() {
        return HashBasedTable.create(this.instanceNodes);
    }

    void addInstanceFormula(VariableInstance instance, FormulaNode formula) {
        this.instanceFormulas.put(instance, formula);
    }

    Map<VariableInstance, FormulaNode> getInstanceFormulas() {
        return Collections.unmodifiableMap(this.instanceFormulas);
    }

    void removeInstances(Collection<VariableInstance> instances) {
        for (VariableInstance instance : instances) {
            Map nodes = this.instanceNodes.row((Object)instance);
            for (Object n : nodes.values()) {
                this.availableNodeInstances.remove(n, (Object)instance);
                this.unavailableNodeInstances.remove(n, (Object)instance);
            }
            this.instanceFormulas.remove(instance);
            for (String key : nodes.keySet()) {
                this.instanceNodes.remove((Object)instance, (Object)key);
            }
        }
    }

    void updateInstance(VariableInstance instance) {
        Map nodes = this.instanceNodes.row((Object)instance);
        for (Map.Entry entry : nodes.entrySet()) {
            String key = (String)entry.getKey();
            Object n = entry.getValue();
            this.instanceNodes.remove((Object)instance, (Object)key);
            this.instanceNodes.put((Object)instance, (Object)key, n);
            if (this.availableNodeInstances.containsKey(n)) {
                this.availableNodeInstances.remove(n, (Object)instance);
                this.availableNodeInstances.put(n, (Object)instance);
            }
            if (!this.unavailableNodeInstances.containsKey(n)) continue;
            this.unavailableNodeInstances.remove(n, (Object)instance);
            this.unavailableNodeInstances.put(n, (Object)instance);
        }
        FormulaNode formulaNode = this.instanceFormulas.remove(instance);
        if (formulaNode != null) {
            this.instanceFormulas.put(instance, formulaNode);
        }
    }

    public Multimap<N, VariableInstance> getAvailableNodeInstances() {
        try {
            this.readLock.lock();
            LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create(this.availableNodeInstances);
            return linkedHashMultimap;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Collection<N> getUnavailableNodes() {
        try {
            this.readLock.lock();
            Set set = Collections.unmodifiableSet(this.unavailableNodeInstances.keySet());
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void activateNodes(Collection<N> nodes) {
        try {
            this.writeLock.lock();
            for (N node : nodes) {
                Collection instances = this.unavailableNodeInstances.removeAll(node);
                if (instances.isEmpty()) continue;
                this.availableNodeInstances.putAll(node, (Iterable)instances);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

