/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.commands;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.datasource.component.DataSourceServer;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="datasource/source/datasource/datagroup")
public class DataGroupService {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataGroupService.class.getName());

    @GET
    @Path(value="/background_worker/restart/data_group_id={id}")
    @Produces(value={"application/json"})
    public OperationResult restartBackgroundWorker(@PathParam(value="id") int dataGroupId) {
        AbstractToolboxConnector<?> worker = DataSourceServer.getBackgroundWorker(dataGroupId);
        if (worker != null) {
            new Thread(() -> {
                try {
                    worker.restartAsync();
                }
                catch (InterruptedException exc) {
                    logger.error("Error restarting data group background worker", (Throwable)exc);
                }
            }).start();
            return OperationResult.SUCCESS;
        }
        return new OperationResult(ResultType.UnexprectedError, "background worker not found");
    }
}

