/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.commands;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.datasource.DataSourceUtils;
import de.elpro.ewms.server.storage.TimeRangeMetadata;
import java.time.Instant;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Secured
@Path(value="datasource/server")
public class DataSourceServerService {
    @GET
    @Path(value="/import_historical_values/from={from}&to={to}")
    @Produces(value={"application/json"})
    public OperationResult importHistoricalValues(@PathParam(value="from") long from, @PathParam(value="to") long to) {
        try {
            long importedValuesCount;
            TimeRangeMetadata realtimeViewMeta = Server.getRawValuesViews().getRealtimeView().getArchiveStorage().getCachedMetadata();
            if (realtimeViewMeta != null && realtimeViewMeta.getTimeRangeEnd() != null) {
                Instant maxTo = Instant.ofEpochMilli(realtimeViewMeta.getTimeRangeEnd()).minusMillis(Server.getRawValuesWriter().getExecutionInterval() * 2L);
                to = Math.min(to, maxTo.toEpochMilli());
            }
            if ((importedValuesCount = DataSourceUtils.importHistoricalValues(Instant.ofEpochMilli(from), Instant.ofEpochMilli(to), Server.getConfig().getRawValuesClusterSize())) == 0L) {
                return new OperationResult(ResultType.Success, "No historical data found");
            }
            return new OperationResult(ResultType.Success, String.format("Imported %d values", importedValuesCount));
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedError, "Error importing historical values", exc.getMessage());
        }
    }
}

