/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.commands;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.IdentifierType;
import de.elpro.ewms.core.datasource.SignalId;
import de.elpro.ewms.core.datasource.SignalType;
import de.elpro.ewms.core.datasource.handlers.ImportSignalIdsRequest;
import de.elpro.ewms.core.datasource.opcua.datatypes.SignalDataValue;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.datasource.component.DataSourceServer;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.structure.StructureObjectRestService;
import de.elpro.ewms.server.http.rest.transaction.TransactionRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="datasource/source")
public class DataSourceService
extends AuthenticatedRestService {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(DataSourceService.class.getName());

    @GET
    @Path(value="/client/get_state/id={id}")
    @Produces(value={"application/json"})
    public DataClientState getClientState(@PathParam(value="id") int id) {
        try {
            return DataSourceServer.getDataClient(id).getState();
        }
        catch (Exception exc) {
            logger.error("Error at 'datasource -> get all clients'", (Throwable)exc);
            return DataClientState.Disconnected;
        }
    }

    @GET
    @Path(value="/client/connect/id={id}")
    @Produces(value={"application/json"})
    public OperationResult clientConnect(@PathParam(value="id") int id) {
        try {
            DataClient<?> client = DataSourceServer.getDataClient(id);
            if (client == null) {
                String errorMsg = String.format("DataClient with id=%d not found", id);
                logger.error(errorMsg);
                return new OperationResult(ResultType.UnexprectedError, errorMsg);
            }
            return client.connect();
        }
        catch (Exception exc) {
            logger.error("Error at 'datasource -> connect client'", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @GET
    @Path(value="/client/disconnect/id={id}")
    @Produces(value={"application/json"})
    public OperationResult clientDisconnect(@PathParam(value="id") int id) {
        try {
            DataClient<?> client = DataSourceServer.getDataClient(id);
            if (client != null) {
                client.disconnect();
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error at 'datasource -> diconnect client'", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    @GET
    @Path(value="/client/root_signals/get/id={id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getRootSignals(@PathParam(value="id") int id) {
        try {
            return Response.ok((Object)DataSourceServer.getDataClient(id).getSignals(null)).build();
        }
        catch (Exception exc) {
            if (exc.getCause() instanceof DAOOperationException) {
                return Response.serverError().entity((Object)((DAOOperationException)exc.getCause()).getOperationResult()).build();
            }
            logger.error("Error at 'datasource -> get root signals'", (Throwable)exc);
            return Response.serverError().entity((Object)new OperationResult(ResultType.UnexprectedError, exc.getMessage())).build();
        }
    }

    @POST
    @Path(value="/client/child_signals/get/id={id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SignalId[] getSignals(@PathParam(value="id") int id, SignalId parentSignalId) {
        try {
            SignalId[] signals = DataSourceServer.getDataClient(id).getSignals(parentSignalId);
            if (signals == null) {
                return new SignalId[0];
            }
            return signals;
        }
        catch (Exception exc) {
            logger.error("Error at 'datasource -> get signals'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/client/load_signal_attributes/get/id={id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SignalId getAttributes(@PathParam(value="id") int id, SignalId signalId) {
        try {
            return DataSourceServer.getDataClient(id).getFullSignalDefinition(signalId);
        }
        catch (Exception exc) {
            logger.error("Error at 'datasource -> get Attributes'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/client/value/get/id={id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public SignalDataValue getCurrentValue(@PathParam(value="id") int id, SignalId signalId) {
        try {
            SignalDataValue value = DataSourceServer.getDataClient(id).getCurrentValue(signalId);
            if (value == null) {
                System.out.println("So was darfst du nicht zur\u00fcck geben");
            }
            return value;
        }
        catch (Exception exc) {
            logger.error("Error at 'datasource -> get curren value'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/client/import_signal_ids")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult importSignalIds(ImportSignalIdsRequest request) {
        StructureClass structureClass;
        StructureObject parent;
        Variable insertVariable;
        Throwable throwable;
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        LinkedList<SignalId> matchingSignals = new LinkedList<SignalId>();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (Transaction trx = EntityManagerPool.createServersideTransaction((User)this.getUser());){
                OperationResult result;
                Object dataClient;
                EntityManager em = EntityManagerPool.getEntityManager((Transaction)trx, (User)this.getUser());
                HashSet<String> existingIds = new HashSet<String>();
                insertVariable = (Variable)em.find(Variable.class, (Object)request.getInsertVariable().getId());
                parent = (StructureObject)em.find(StructureObject.class, (Object)request.getParentObject().getId());
                DataSource dataSource = (DataSource)em.find(DataSource.class, (Object)request.getDataSource().getId());
                structureClass = insertVariable.getStructureClass();
                if (request.isOnlyUnusedSignals()) {
                    for (VariableInstance instance : ORMCache.getVariableInstances()) {
                        if (instance.getType() != VariableInstanceType.PLC) continue;
                        existingIds.add(instance.getResultPlcDatasourceKey());
                    }
                }
                if (((DataClient)(dataClient = DataSourceServer.getDataClient(dataSource.getId()))).getState() != DataClientState.Connected && (result = ((DataClient)dataClient).connect()).getType() != ResultType.Success) {
                    return result;
                }
                SignalId searchRootId = request.getSearchRootNamespace() != null && !request.getSearchRootNamespace().isEmpty() && request.getSearchRootIdentifier() != null && !request.getSearchRootIdentifier().isEmpty() ? new SignalId(request.getSearchRootNamespace(), request.getSearchRootIdentifier(), IdentifierType.String) : null;
                LinkedList<SignalId> searchIdPool = new LinkedList<SignalId>(Arrays.asList(((DataClient)dataClient).getSignals(searchRootId)));
                HashSet<SignalId> visitedFolders = new HashSet<SignalId>();
                Pattern signalIdPattern = request.getSignalIdRegex() != null && !request.getSignalIdRegex().isEmpty() ? Pattern.compile(request.getSignalIdRegex()) : null;
                Pattern searchFolderPattern = request.getSearchFolderRegex() != null && !request.getSearchFolderRegex().isEmpty() ? Pattern.compile(request.getSearchFolderRegex()) : null;
                while (!searchIdPool.isEmpty()) {
                    SignalDataValue currentValue;
                    Object o;
                    boolean matching;
                    SignalId signal = searchIdPool.removeFirst();
                    if (signal.getType() == SignalType.Folder) {
                        boolean bl = matching = searchFolderPattern == null || searchFolderPattern.matcher(signal.getIdentifier()).matches();
                        if (!matching) continue;
                        visitedFolders.add(signal);
                        List<SignalId> unvisitedChildren = Arrays.stream(((DataClient)dataClient).getSignals(signal)).filter(s -> !visitedFolders.contains(s)).toList();
                        for (SignalId child : unvisitedChildren) {
                            searchIdPool.addFirst(child);
                        }
                        continue;
                    }
                    boolean bl = matching = signalIdPattern == null || signalIdPattern.matcher(signal.getIdentifier()).matches();
                    if (!matching || existingIds.contains(signal.getIdentifier()) || signal.getType() != SignalType.Variable || !((o = (currentValue = ((DataClient)dataClient).getCurrentValue(signal)).getValue()) instanceof Number) && !(o instanceof Boolean)) continue;
                    try {
                        Number n = currentValue.getNummericValue();
                        if (n == null || !Double.isFinite(n.doubleValue())) continue;
                        matchingSignals.add(signal);
                        logger.info("Found signal " + signal.toString());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception exc) {
            logger.error("Error importing Signal Ids", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
        if (matchingSignals.isEmpty()) {
            logger.info("Not matching Signals found");
            return OperationResult.SUCCESS;
        }
        HashMap<Integer, SignalId> signalIdObjects = new HashMap<Integer, SignalId>();
        try {
            throwable = null;
            Object var9_10 = null;
            try (Transaction trx = EntityManagerPool.createServersideTransaction((User)this.getUser());){
                for (SignalId signal : matchingSignals) {
                    Pattern p;
                    String identifier = signal.getIdentifier();
                    if (request.getRemoveNamingPrefixRegex() != null && !request.getRemoveNamingPrefixRegex().isEmpty()) {
                        p = Pattern.compile(request.getRemoveNamingPrefixRegex());
                        Matcher m = p.matcher(identifier);
                        if (!m.find()) {
                            logger.warning(String.format("Prefix pattern '%s' does not match identifier '%s'", request.getRemoveNamingPrefixRegex(), identifier));
                            continue;
                        }
                        identifier = m.group(2);
                    }
                    if (request.getRemoveNamingSuffixRegex() != null && !request.getRemoveNamingSuffixRegex().isEmpty()) {
                        p = Pattern.compile(request.getRemoveNamingSuffixRegex());
                        Matcher m = p.matcher(identifier);
                        if (!m.find()) {
                            logger.warning(String.format("Suffix pattern '%s' does not match identifier '%s'", request.getRemoveNamingSuffixRegex(), identifier));
                            continue;
                        }
                        identifier = m.group(1);
                    }
                    StructureObject object = new StructureObject();
                    object.getParents().add(parent);
                    object.setName(identifier);
                    object.setStructureClass(structureClass);
                    int structureObjectId = (Integer)StructureObjectRestService.saveStructureObject((int)trx.getId(), (User)this.getUser(), (StructureObject)object).getObjectId();
                    signalIdObjects.put(structureObjectId, signal);
                }
                EntityManager em = EntityManagerPool.getEntityManager((Transaction)trx, (User)this.getUser());
                for (VariableInstance instance : ((Variable)em.find(Variable.class, (Object)insertVariable.getId())).getInstances()) {
                    SignalId signalId = (SignalId)signalIdObjects.get(instance.getStructureObject().getId());
                    if (signalId == null) continue;
                    instance.setPlcDatasourceKey(signalId.getIdentifier());
                    em.merge((Object)instance);
                    TransactionChangeset.changedOrNew((int)trx.getId(), (Object)instance);
                }
                TransactionRestService.commitTransactionSync((int)trx.getId(), (User)this.getUser());
                logger.debugf("Import Signals: %d objects created", new Object[]{signalIdObjects.size()});
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            logger.error("Error creating structure objects", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
        return OperationResult.SUCCESS;
    }
}

