/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.component;

import de.elpro.ewms.core.datasource.DataGroup;
import de.elpro.ewms.core.datasource.DataGroupType;
import de.elpro.ewms.core.datasource.DataSource;
import de.elpro.ewms.core.datasource.DataSourceAlt;
import de.elpro.ewms.core.datasource.IDataSource;
import de.elpro.ewms.core.datasource.ToolboxDescriptor;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.IProcessInterfaceFactory;
import de.elpro.ewms.server.datasource.ProcessInterfaceWrapper;
import de.elpro.ewms.server.model.IServerComponent;
import de.elpro.ewms.server.model.ServerComponentInfo;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component
public class DataSourceServer
implements IServerComponent {
    public static final String WORKER_READ_GROUP_ID = "data-readers";
    public static final String WORKER_WRITE_GROUP_ID = "data-writers";
    private static final Map<Integer, DataClient<?>> clients = new HashMap();
    private static final Map<DataGroup, AbstractToolboxConnector<?>> dataGroupBackgroundWorkers = new HashMap();
    private static final Map<String, IProcessInterfaceFactory<?>> factories = new HashMap();
    @Log
    @Inject
    private Logger logger;
    @Inject
    private EntityManagerFactory entityManagerFactory;

    public DataSourceServer() {
        TransactionChangeset.addPostCommitEventHandler(Object.class, (changes, properties) -> {
            for (Modification change : changes) {
                Object o = change.getObject();
                if (!(o instanceof DataSource) && !(o instanceof DataSourceAlt) && !(o instanceof DataGroup)) continue;
                this.stop();
                clients.clear();
                for (Map.Entry<DataGroup, AbstractToolboxConnector<?>> entry : dataGroupBackgroundWorkers.entrySet()) {
                    DataGroup dataGroup = entry.getKey();
                    AbstractToolboxConnector<?> worker = entry.getValue();
                    Server.removeWorker((String)(dataGroup.getType() == DataGroupType.Read ? WORKER_READ_GROUP_ID : WORKER_WRITE_GROUP_ID), worker);
                    worker.terminate();
                }
                dataGroupBackgroundWorkers.clear();
                this.start();
                return;
            }
        });
    }

    public ServerComponentInfo getInfo() {
        return new ServerComponentInfo("com.eos.server.datasource", "1.0.0");
    }

    public boolean start() {
        block9: {
            EntityManager em = this.entityManagerFactory.createEntityManager();
            try {
                try {
                    for (DataSource ds : em.createQuery("SELECT o FROM DataSource o", DataSource.class).getResultList()) {
                        try {
                            ds.getGroups().size();
                            IProcessInterfaceFactory<?> providerFactory = factories.get(ds.getToolboxId());
                            if (providerFactory == null) {
                                throw new Exception(String.format("Provider with id %s not found", ds.getToolboxId()));
                            }
                            clients.put(ds.getId(), new DataClient(ds, this.entityManagerFactory, DataSourceServer.createProcessInterfaceWrapper(providerFactory, ds)));
                        }
                        catch (Exception exc) {
                            this.logger.error("Cannot create data client", (Throwable)exc);
                        }
                    }
                }
                catch (Exception exc) {
                    this.logger.error("Error reading datasources", (Throwable)exc);
                    em.close();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                em.close();
                throw throwable;
            }
            em.close();
        }
        new Thread(() -> {
            for (DataClient<?> dataClient : clients.values()) {
                for (DataGroup group : dataClient.getDataSource().getGroups()) {
                    AbstractToolboxConnector<?> connector = dataClient.createToolboxConnector(group);
                    connector.setAutostart(group.getDataSource().isAutoconnect());
                    dataGroupBackgroundWorkers.put(group, connector);
                    if (group.getType().isRead()) {
                        Server.addWorker((String)WORKER_READ_GROUP_ID, connector);
                        continue;
                    }
                    if (!group.getType().isWrite()) continue;
                    Server.addWorker((String)WORKER_WRITE_GROUP_ID, connector);
                }
            }
        }).start();
        return true;
    }

    private static <N> ProcessInterfaceWrapper<N> createProcessInterfaceWrapper(IProcessInterfaceFactory<N> factory, DataSource dataSource) {
        IProcessInterface<N> masterInterface = factory.createProcessInterface((IDataSource)dataSource);
        ArrayList alternaticeDataSources = new ArrayList(dataSource.getAlternativeDataSources());
        Collections.sort(alternaticeDataSources, new Comparator<DataSourceAlt>(){

            @Override
            public int compare(DataSourceAlt o1, DataSourceAlt o2) {
                int result = Integer.compare(o1.getPriority(), o2.getPriority());
                return result == 0 ? o1.toString().compareTo(o2.toString()) : result;
            }
        });
        ArrayList slaveInterfaces = new ArrayList(alternaticeDataSources.size());
        for (DataSourceAlt altSource : alternaticeDataSources) {
            slaveInterfaces.add(factory.createProcessInterface((IDataSource)altSource));
        }
        return new ProcessInterfaceWrapper<N>(masterInterface, slaveInterfaces);
    }

    public void stop() {
        for (AbstractWorker abstractWorker : dataGroupBackgroundWorkers.values()) {
            abstractWorker.setAutostart(false);
            abstractWorker.stopAsync();
        }
        for (DataClient dataClient : clients.values()) {
            dataClient.disconnect();
        }
    }

    @PostConstruct
    public void init() {
        this.loadProcessInterfaceProviders();
        Server.createWorkerGroup((String)WORKER_READ_GROUP_ID, (String)"Data Readers");
        Server.createWorkerGroup((String)WORKER_WRITE_GROUP_ID, (String)"Data Writers");
    }

    private void loadProcessInterfaceProviders() {
        for (IProcessInterfaceFactory provider : ServiceUtils.getServiceList(IProcessInterfaceFactory.class)) {
            factories.put(provider.getDescriptor().getId(), provider);
        }
    }

    public static ToolboxDescriptor getToolboxDescriptor(String id) {
        IProcessInterfaceFactory<?> factory = factories.get(id);
        if (factory == null) {
            return null;
        }
        return factory.getDescriptor();
    }

    public static ToolboxDescriptor[] getAllToolboxDescriptors() {
        return (ToolboxDescriptor[])factories.values().stream().map(f -> f.getDescriptor()).toArray(ToolboxDescriptor[]::new);
    }

    public static DataClient<?> getDataClient(int dataSourceId) {
        return clients.get(dataSourceId);
    }

    public static AbstractToolboxConnector<?> getBackgroundWorker(int dataGroupId) {
        return dataGroupBackgroundWorkers.get(new DataGroup(dataGroupId));
    }

    public static Collection<AbstractToolboxConnector<?>> getToolboxConnectors() {
        return dataGroupBackgroundWorkers.values();
    }
}

