/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.schedules;

import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.core.worker.WorkerState;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataSourceUtils;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.datasource.component.DataSourceServer;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import java.time.Instant;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component(service={ScheduleJobDefinition.class})
public class ActivateUnavailableToolboxNodesJob
extends ScheduleJobDefinition {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ActivateUnavailableToolboxNodesJob.class.getName());

    public ActivateUnavailableToolboxNodesJob() {
        super("de.elpro.ewms.server.datasource.schedules.activateunavailabletoolboxnodes", "Activate Unavailable Toolbox Nodes", null, null);
    }

    public void run(Schedule schedule, Instant executionTimestamp) {
        for (AbstractToolboxConnector<?> toolboxConnector : DataSourceServer.getToolboxConnectors()) {
            try {
                if (toolboxConnector.getState() != WorkerState.Running || toolboxConnector.getClient().getState() != DataClientState.Connected) continue;
                DataSourceUtils.activateUnavailableNodes(toolboxConnector);
            }
            catch (Exception exc) {
                logger.error("Error Retry Read Toolbox nodes", (Throwable)exc);
            }
        }
    }
}

