/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.datasource.schedules;

import de.elpro.ewms.core.datasource.DataClientState;
import de.elpro.ewms.core.schedules.Schedule;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.datasource.AbstractToolboxConnector;
import de.elpro.ewms.server.datasource.DataClient;
import de.elpro.ewms.server.datasource.DataSourceUtils;
import de.elpro.ewms.server.datasource.IHistorizableProcessInterface;
import de.elpro.ewms.server.datasource.IProcessInterface;
import de.elpro.ewms.server.datasource.ProcessInterfaceWrapper;
import de.elpro.ewms.server.datasource.bundle.Activator;
import de.elpro.ewms.server.datasource.component.DataSourceServer;
import de.elpro.ewms.server.model.ScheduleJobDefinition;
import java.time.Instant;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component(service={ScheduleJobDefinition.class})
public class ImportHistoricalValuesJob
extends ScheduleJobDefinition {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ImportHistoricalValuesJob.class.getCanonicalName());
    private Instant upToDate = null;

    public ImportHistoricalValuesJob() {
        super("de.elpro.ewms.server.datasource.schedules.importhistoricalvaluesjog", "Import Historical Values Job", null, null);
    }

    public synchronized void run(Schedule schedule, Instant executionTimestamp) {
        Instant importFrom;
        if (Server.getStartTime() == null) {
            return;
        }
        if (this.upToDate == null) {
            this.upToDate = Server.getLastStartCurrentValueTimestamp() != null ? Server.getLastStartCurrentValueTimestamp() : executionTimestamp;
        }
        boolean onlinePhiInterface = false;
        for (AbstractToolboxConnector<?> connector : DataSourceServer.getToolboxConnectors()) {
            DataClient<?> client = connector.getClient();
            if (client.getState() != DataClientState.Connected) continue;
            IProcessInterface<Object> pi = client.getProcessInterface();
            if (pi instanceof ProcessInterfaceWrapper) {
                pi = ((ProcessInterfaceWrapper)pi).getCurrentInterface();
            }
            if (!(pi instanceof IHistorizableProcessInterface)) continue;
            onlinePhiInterface = true;
            break;
        }
        if (!onlinePhiInterface) {
            return;
        }
        long executionInterval = schedule.getExecutionInterval().getRasterEnd(executionTimestamp).toEpochMilli() - schedule.getExecutionInterval().getRasterBegin(executionTimestamp).toEpochMilli();
        Instant importTo = executionTimestamp.minusMillis(Server.getRawValuesWriter().getExecutionInterval() * 2L);
        if (!importTo.isAfter(importFrom = this.upToDate.minusMillis(Server.getRawValuesWriter().getExecutionInterval() * 2L + Server.getRawValuesViews().getGlobalView().getRaster().toMilli() + executionInterval))) {
            return;
        }
        try {
            DataSourceUtils.importHistoricalValues(importFrom, importTo, Server.getConfig().getRawValuesClusterSize());
            this.upToDate = importTo;
        }
        catch (Exception exc) {
            logger.errorf("Error importing historical values", (Throwable)exc, new Object[0]);
        }
    }
}

