/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export;

import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.server.export.IExportDataWriter;
import de.elpro.ewms.server.export.VarValuesInvalidatedTracker;
import de.elpro.ewms.server.export.bundle.Activator;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.fx.core.log.Logger;

public class ExportDataSchedule
extends AbstractWorker {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ExportDataSchedule.class.getName());
    private final RasterizedValues rasterizedValues;
    private final ExportDataProfile exportJob;
    private final VarValuesInvalidatedTracker invalidationTracker;
    private final DataWriterContainer<?> dataWriterContainer;

    public ExportDataSchedule(RasterizedValues rasterizedValues, ExportDataProfile exportProfile, IExportDataWriter<?> dataWriter, VarValuesInvalidatedTracker invalidationTracker) {
        super(String.format("com.eos.server.export.exportdataprofile.%d", exportProfile.getId()), exportProfile.getLocalName(), exportProfile.getExecutionInterval().toMilli(), true);
        this.rasterizedValues = rasterizedValues;
        this.exportJob = exportProfile;
        this.dataWriterContainer = new DataWriterContainer(exportProfile.getDataWriterOptions(), dataWriter);
        this.invalidationTracker = invalidationTracker;
    }

    public ExportDataProfile getExportJob() {
        return this.exportJob;
    }

    public VarValuesInvalidatedTracker getInvalidationTracker() {
        return this.invalidationTracker;
    }

    protected boolean doStart() {
        return true;
    }

    protected boolean canDoWork() {
        return !this.invalidationTracker.getInvalidatedIntervals(false).isEmpty();
    }

    protected Callable<Void> createWorkTask() {
        return () -> {
            Map<VariableInstance, TsIntervals> invalidatedIntervals = this.invalidationTracker.getInvalidatedIntervals(true);
            if (invalidatedIntervals.isEmpty()) {
                return null;
            }
            try {
                Map<VariableInstance, TsIntervals> stillIvalidIntervals = this.dataWriterContainer.export(this.exportJob.getLocalName(), this.rasterizedValues, this.exportJob.getDataRaster(), this.exportJob.getDataSliceSize(), invalidatedIntervals);
                if (stillIvalidIntervals != null && !stillIvalidIntervals.isEmpty()) {
                    this.invalidationTracker.addInvalidatedIntervals(stillIvalidIntervals);
                }
                this.exportJob.setLastExecution(Instant.ofEpochMilli(this.getLastExecution()));
            }
            catch (Exception exc) {
                logger.errorf("Error during export data on schedule '%s': %s", (Throwable)exc, new Object[]{this.exportJob.getLocalName(), exc.getMessage()});
                this.invalidationTracker.addInvalidatedIntervals(invalidatedIntervals);
            }
            return null;
        };
    }

    protected void doStop() {
    }

    private static class DataWriterContainer<O> {
        private final O options;
        private final IExportDataWriter<O> writer;

        public DataWriterContainer(String optionsText, IExportDataWriter<O> writer) {
            this.options = writer.parseOptions(optionsText);
            this.writer = writer;
        }

        public Map<VariableInstance, TsIntervals> export(String jobName, RasterizedValues rasterizedValues, ComplexRaster dataRaster, ComplexRaster dataSliceSize, Map<VariableInstance, TsIntervals> invalidatedIntervals) throws Exception {
            return this.writer.export(jobName, this.options, rasterizedValues, dataRaster, dataSliceSize, invalidatedIntervals);
        }
    }
}

