/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export;

import de.elpro.ewms.core.export.ExportDataWriterDescriptor;
import de.elpro.ewms.core.export.IExportDataWriterDescriptor;
import de.elpro.ewms.server.export.IExportDataWriter;
import de.elpro.ewms.server.export.bundle.Activator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.fx.core.ServiceUtils;
import org.eclipse.fx.core.log.Logger;

public class ExportDataWriters {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(ExportDataWriters.class.getName());
    private static final Map<String, IExportDataWriter<?>> dataWriters = new HashMap();

    static {
        List writers = ServiceUtils.getServiceList(IExportDataWriter.class);
        for (IExportDataWriter dataWriter : writers) {
            if (dataWriters.containsKey(dataWriter.getDescriptor().getId())) {
                logger.error("Duplicate data writer for id: " + dataWriter.getDescriptor().getId());
                continue;
            }
            dataWriters.put(dataWriter.getDescriptor().getId(), dataWriter);
        }
    }

    public static IExportDataWriter<?> get(String id) {
        return dataWriters.get(id);
    }

    public static ExportDataWriterDescriptor[] getDescriptors() {
        return (ExportDataWriterDescriptor[])dataWriters.values().stream().map(w -> ExportDataWriterDescriptor.create((IExportDataWriterDescriptor)w.getDescriptor())).toArray(ExportDataWriterDescriptor[]::new);
    }
}

