/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.export.IExportDataWriterDescriptor;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;

public interface IExportDataWriter<O> {
    public IExportDataWriterDescriptor getDescriptor();

    public O parseOptions(String var1);

    public Map<VariableInstance, TsIntervals> export(String var1, O var2, RasterizedValues var3, ComplexRaster var4, ComplexRaster var5, Map<VariableInstance, TsIntervals> var6) throws Exception;

    default public Table<VariableInstance, Instant, TsIntervals> splitToSlices(ComplexRaster dataSliceSize, Map<VariableInstance, TsIntervals> invalidatedIntervals) {
        HashBasedTable slicedInvalidatedIntervals = HashBasedTable.create();
        if (ComplexRaster.YEAR.equals((Object)dataSliceSize)) {
            Instant sliceBegin = Instant.ofEpochMilli(0L);
            for (Map.Entry<VariableInstance, TsIntervals> entry : invalidatedIntervals.entrySet()) {
                slicedInvalidatedIntervals.put((Object)entry.getKey(), (Object)sliceBegin, (Object)entry.getValue());
            }
        } else {
            for (Map.Entry<VariableInstance, TsIntervals> entry : invalidatedIntervals.entrySet()) {
                TsIntervals[] tsIntervalsArray = entry.getValue().split(dataSliceSize);
                int n = tsIntervalsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TsIntervals intervals = tsIntervalsArray[n2];
                    if (!intervals.isEmpty()) {
                        VariableInstance instance = entry.getKey();
                        Instant firstIntervalBegin = Instant.ofEpochMilli(((TsInterval)intervals.getIntervals().iterator().next()).getFromTs());
                        Instant sliceBegin = dataSliceSize.getRasterBegin(firstIntervalBegin.plusNanos(1L));
                        slicedInvalidatedIntervals.put((Object)instance, (Object)sliceBegin, (Object)intervals);
                    }
                    ++n2;
                }
            }
        }
        return slicedInvalidatedIntervals;
    }

    default public InvalidationIntervals splitByTimestamp(Instant timestamp, Map<VariableInstance, TsIntervals> invalidatedIntervals) {
        InvalidationIntervals intervals = new InvalidationIntervals(timestamp);
        for (Map.Entry<VariableInstance, TsIntervals> entry : invalidatedIntervals.entrySet()) {
            VariableInstance instance = entry.getKey();
            TsIntervals toSplit = entry.getValue();
            for (TsInterval interval : toSplit.getIntervals()) {
                TsIntervals afterIntervals;
                TsIntervals beforeIntervals;
                if (interval.getToTs() <= timestamp.toEpochMilli()) {
                    beforeIntervals = intervals.getBeforeTsIntervals().get(instance);
                    if (beforeIntervals == null) {
                        beforeIntervals = new TsIntervals();
                        intervals.getBeforeTsIntervals().put(instance, beforeIntervals);
                    }
                    beforeIntervals.addInterval(interval);
                    continue;
                }
                if (interval.getFromTs() >= timestamp.toEpochMilli()) {
                    TsIntervals afterIntervals2 = intervals.getAfterTsIntervals().get(instance);
                    if (afterIntervals2 == null) {
                        afterIntervals2 = new TsIntervals();
                        intervals.getAfterTsIntervals().put(instance, afterIntervals2);
                    }
                    afterIntervals2.addInterval(interval);
                    continue;
                }
                beforeIntervals = intervals.getBeforeTsIntervals().get(instance);
                if (beforeIntervals == null) {
                    beforeIntervals = new TsIntervals();
                    intervals.getBeforeTsIntervals().put(instance, beforeIntervals);
                }
                if ((afterIntervals = intervals.getAfterTsIntervals().get(instance)) == null) {
                    afterIntervals = new TsIntervals();
                    intervals.getAfterTsIntervals().put(instance, afterIntervals);
                }
                beforeIntervals.addInterval(interval.getFromTs(), timestamp.toEpochMilli());
                afterIntervals.addInterval(timestamp.toEpochMilli(), interval.getToTs());
            }
        }
        return intervals;
    }

    public static class InvalidationIntervals {
        private final Instant timestamp;
        private final Map<VariableInstance, TsIntervals> beforeTsIntervals = new HashMap<VariableInstance, TsIntervals>();
        private final Map<VariableInstance, TsIntervals> afterTsIntervals = new HashMap<VariableInstance, TsIntervals>();

        public InvalidationIntervals(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public Instant getTimestamp() {
            return this.timestamp;
        }

        public Map<VariableInstance, TsIntervals> getBeforeTsIntervals() {
            return this.beforeTsIntervals;
        }

        public Map<VariableInstance, TsIntervals> getAfterTsIntervals() {
            return this.afterTsIntervals;
        }
    }
}

