/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export;

import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesInvalidatedListener;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValuesState;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class VarValuesInvalidatedTracker
implements IVarValuesInvalidatedListener {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private final ExportDataProfile exportJob;
    private Map<VariableInstance, TsIntervals> invalidatedIntervals = new HashMap<VariableInstance, TsIntervals>();

    public VarValuesInvalidatedTracker(ExportDataProfile job) {
        this.exportJob = job;
    }

    public void valuesInvalidated(RasterizedValues rasterizedValues, VariableInstance instance, long from, long to) {
        if (rasterizedValues.getState() == RasterizedValuesState.Initialization) {
            return;
        }
        if (!this.exportJob.applyInvalidationListener(instance)) {
            return;
        }
        this.writeLock.lock();
        try {
            TsIntervals intervals = this.invalidatedIntervals.get(instance);
            if (intervals == null) {
                intervals = new TsIntervals();
                this.invalidatedIntervals.put(instance, intervals);
            }
            intervals.addInterval(from, to);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<VariableInstance, TsIntervals> getInvalidatedIntervals(boolean clear) {
        this.writeLock.lock();
        try {
            Map<VariableInstance, TsIntervals> result = Collections.unmodifiableMap(this.invalidatedIntervals);
            if (clear) {
                this.invalidatedIntervals = new HashMap<VariableInstance, TsIntervals>();
            }
            Map<VariableInstance, TsIntervals> map = result;
            return map;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addInvalidatedIntervals(Map<VariableInstance, TsIntervals> intervals) {
        this.writeLock.lock();
        try {
            for (Map.Entry<VariableInstance, TsIntervals> entry : intervals.entrySet()) {
                TsIntervals prevTsIntervals = this.invalidatedIntervals.get(entry.getKey());
                if (prevTsIntervals == null) {
                    this.invalidatedIntervals.put(entry.getKey(), entry.getValue());
                    continue;
                }
                for (TsInterval interval : entry.getValue().getIntervals()) {
                    prevTsIntervals.addInterval(interval);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

