/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export.acron;

import com.google.common.collect.Table;
import de.elpro.ewms.core.export.ExportDataWriterDescriptor;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.ArchiveValue;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.server.export.IExportDataWriter;
import de.elpro.ewms.server.export.acron.AcronExportOptions;
import de.elpro.ewms.server.export.bundle.Activator;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component
public class AcronCSVDataWriter
implements IExportDataWriter<AcronExportOptions> {
    private static final String EXPORT_DIR_PATH;
    private static final Logger logger;
    private static final DateTimeFormatter FILE_TIMESTAMP_PATTERN;
    private static final DateTimeFormatter VALUE_TIMESTAMP_PATTERN;
    public static final ExportDataWriterDescriptor DESCRIPTOR;
    private static final File BASE_EXPORT_DIR;

    static {
        File baseExportDir;
        EXPORT_DIR_PATH = System.getProperty("com.eos.server.export.acron_csv.export_path");
        logger = Activator.getLoggerFactory().createLogger(AcronCSVDataWriter.class.getName());
        FILE_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy_MM_dd__HH_mm_ss");
        VALUE_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd HH-mm-ss");
        DESCRIPTOR = new ExportDataWriterDescriptor("com.eos.server.export.acroncsvdatawriter", "Acron CSV Data Writer", null, null);
        if (EXPORT_DIR_PATH != null && !EXPORT_DIR_PATH.isBlank()) {
            try {
                baseExportDir = new File(new URI(EXPORT_DIR_PATH));
            }
            catch (URISyntaxException e) {
                logger.error("Cannot parse export dir path", (Throwable)e);
                baseExportDir = null;
            }
        } else {
            baseExportDir = Activator.getWorkspaceLocation().append("export").toFile();
        }
        BASE_EXPORT_DIR = baseExportDir;
        logger.debug("ACRON CSV Export Dir: " + baseExportDir.toString());
    }

    public ExportDataWriterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    @Override
    public Map<VariableInstance, TsIntervals> export(String jobName, AcronExportOptions options, RasterizedValues rasterizedValues, ComplexRaster dataRaster, ComplexRaster dataSliceSize, Map<VariableInstance, TsIntervals> invalidatedIntervals) {
        if (BASE_EXPORT_DIR == null) {
            return null;
        }
        long tsBegin = System.nanoTime();
        String folderName = String.format("%s (%s, Raster %s, Slice %s)", jobName, rasterizedValues.getType(), dataRaster.name(), dataSliceSize.name());
        File folder = new File(BASE_EXPORT_DIR, folderName);
        folder.mkdirs();
        Table<VariableInstance, Instant, TsIntervals> slicesIntervals = this.splitToSlices(dataSliceSize, invalidatedIntervals);
        logger.debugf("For split %s, %.2f ms", new Object[]{rasterizedValues.getType(), (double)(System.nanoTime() - tsBegin) / 1000000.0});
        for (Instant sliceBegin : slicesIntervals.columnKeySet()) {
            System.nanoTime();
            LocalDateTime sliceBeginLDT = LocalDateTime.ofInstant(sliceBegin, ZoneOffset.systemDefault());
            LocalDateTime sliceEndLDT = LocalDateTime.ofInstant(dataSliceSize.getRasterEnd(sliceBegin), ZoneOffset.systemDefault());
            String fileBeginTimestamp = FILE_TIMESTAMP_PATTERN.format(sliceBeginLDT);
            String fileEndTimestamp = FILE_TIMESTAMP_PATTERN.format(sliceEndLDT);
            String fileDestName = String.format("A_FROM_%s_TO_%s.CSV", fileBeginTimestamp, fileEndTimestamp);
            String fileTempName = String.format("_A_TEMP_FROM_%s_TO_%s.CSV", fileBeginTimestamp, fileEndTimestamp);
            File fileDest = new File(folder, fileDestName);
            File fileTemp = new File(folder, fileTempName);
            if (fileTemp.exists()) {
                fileTemp.delete();
            }
            Map<String, IVarValuesCollection> prevValues = null;
            if (fileDest.exists()) {
                fileDest.renameTo(fileTemp);
                try {
                    prevValues = AcronCSVDataWriter.readCSV(fileTemp);
                }
                catch (IOException e) {
                    logger.error(String.format("Error reading temp file %s", fileTemp), (Throwable)e);
                }
            }
            slicesIntervals.column((Object)sliceBegin);
            Map<String, IVarValuesCollection> mergedValues = AcronCSVDataWriter.mergeValues(rasterizedValues, dataRaster, prevValues, slicesIntervals.column((Object)sliceBegin));
            try {
                Throwable throwable = null;
                Object var25_27 = null;
                try (BufferedOutputStream out = new BufferedOutputStream(FileUtils.openOutputStream((File)fileTemp, (boolean)false));){
                    String lineEnding = null;
                    if (lineEnding == null) {
                        lineEnding = System.lineSeparator();
                    }
                    for (Map.Entry<String, IVarValuesCollection> entry : mergedValues.entrySet()) {
                        String varName = entry.getKey();
                        IVarValuesCollection values = entry.getValue();
                        if (values.isEmpty()) continue;
                        ArchiveValue prevAV = null;
                        for (IVarValue val : values) {
                            ArchiveValue av;
                            if (val instanceof ArchiveValue) {
                                av = (ArchiveValue)val;
                            } else {
                                long startTs = dataRaster.getRasterBegin(Instant.ofEpochMilli(val.getEndTimestamp())).toEpochMilli();
                                av = new ArchiveValue(startTs, val.getEndTimestamp(), val.getValue(), val.getQuality());
                            }
                            if (prevAV == null) {
                                prevAV = av;
                                continue;
                            }
                            if (prevAV.equalValue(val) && prevAV.getEndTimestamp() == av.getStartTimestamp()) {
                                prevAV = (ArchiveValue)prevAV.copy(prevAV.getStartTimestamp(), av.getEndTimestamp());
                                continue;
                            }
                            AcronExportDataEntry aede = new AcronExportDataEntry(prevAV.getStartTimestamp(), varName, prevAV.getValue(), prevAV.isValid() ? 1 : 0, prevAV.getEndTimestamp(), null);
                            String line = String.valueOf(aede.toString()) + lineEnding;
                            ((OutputStream)out).write(line.getBytes(StandardCharsets.UTF_8));
                            prevAV = av;
                        }
                        if (prevAV == null) continue;
                        AcronExportDataEntry aede = new AcronExportDataEntry(prevAV.getStartTimestamp(), varName, prevAV.getValue(), prevAV.isValid() ? 1 : 0, prevAV.getEndTimestamp(), null);
                        String line = aede.toString();
                        ((OutputStream)out).write(line.getBytes());
                        ((OutputStream)out).write(lineEnding.getBytes());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exc) {
                logger.error(String.format("Cannot write CSV Data to file %s", fileTemp), (Throwable)exc);
                fileTemp.delete();
            }
            if (!fileTemp.exists()) continue;
            fileTemp.renameTo(fileDest);
        }
        logger.debugf("Execution Time for Export for %s, %.2f ms", new Object[]{rasterizedValues.getType(), (double)(System.nanoTime() - tsBegin) / 1000000.0});
        return null;
    }

    @Override
    public AcronExportOptions parseOptions(String optionsText) {
        return new AcronExportOptions();
    }

    private static Map<String, IVarValuesCollection> mergeValues(RasterizedValues rasterizedValues, ComplexRaster dataRaster, Map<String, IVarValuesCollection> prevValues, Map<VariableInstance, TsIntervals> instanceIntervals) {
        rasterizedValues.readLock();
        try {
            HashMap<String, IVarValuesCollection> newValues = new HashMap<String, IVarValuesCollection>();
            for (Map.Entry<VariableInstance, TsIntervals> entry : instanceIntervals.entrySet()) {
                VariableInstance instance = entry.getKey();
                String varName = AcronCSVDataWriter.mapToName(instance);
                for (TsInterval interval : entry.getValue().getIntervals()) {
                    Instant begin = dataRaster.getRasterBegin(Instant.ofEpochMilli(interval.getFromTs()).plusNanos(1L));
                    Instant end = dataRaster.getRasterEnd(Instant.ofEpochMilli(interval.getToTs()));
                    IVarValuesCollection values = rasterizedValues.getValues(instance, begin, end, dataRaster);
                    IVarValuesCollection prevIntervalValues = (IVarValuesCollection)newValues.get(varName);
                    if (prevIntervalValues != null) {
                        prevIntervalValues.addAll((Collection)values);
                        continue;
                    }
                    newValues.put(varName, values);
                }
            }
            if (prevValues != null && !prevValues.isEmpty()) {
                for (Map.Entry<Object, Object> entry : prevValues.entrySet()) {
                    String varName = (String)entry.getKey();
                    IVarValuesCollection prevEntryValues = (IVarValuesCollection)entry.getValue();
                    IVarValuesCollection newEntryValues = (IVarValuesCollection)newValues.get(varName);
                    if (newEntryValues == null) {
                        newValues.put(varName, prevEntryValues);
                        continue;
                    }
                    try (IVarValuesCollection newStoredValues = new IVarValuesCollection();){
                        for (IVarValue val : newEntryValues) {
                            if (val instanceof IStoredVarValue) {
                                newStoredValues.add(val);
                                continue;
                            }
                            long startTs = dataRaster.getRasterBegin(Instant.ofEpochMilli(val.getEndTimestamp())).toEpochMilli();
                            ArchiveValue av = new ArchiveValue(startTs, val.getEndTimestamp(), val.getValue(), val.getQuality());
                            newStoredValues.add((IVarValue)av);
                        }
                    }
                    newValues.put(varName, IVarValuesCollection.mergeStoredVarValues((IVarValuesCollection)newStoredValues, (IVarValuesCollection)prevEntryValues));
                }
            }
            HashMap<String, IVarValuesCollection> hashMap = newValues;
            return hashMap;
        }
        finally {
            rasterizedValues.readUnlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, IVarValuesCollection> readCSV(File file) throws FileNotFoundException, IOException {
        HashMap<String, IVarValuesCollection> result = new HashMap<String, IVarValuesCollection>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
                String line;
                block17: while ((line = br.readLine()) != null) {
                    String[] parts = line.split(";");
                    long beginTs = 0L;
                    String varName = null;
                    double value = Double.NaN;
                    int status = 0;
                    long endTs = 0L;
                    try {
                        int i = 0;
                        while (true) {
                            if (i >= 6 || i >= parts.length) {
                                if (!Double.isFinite(value) || status != true) continue block17;
                                IVarValuesCollection values = (IVarValuesCollection)result.get(varName);
                                if (values == null) {
                                    values = new IVarValuesCollection();
                                    result.put(varName, values);
                                }
                                values.add((IVarValue)new ArchiveValue(beginTs, endTs, value, 1.0));
                                continue block17;
                            }
                            switch (i) {
                                case 0: {
                                    String ts = parts[i].substring(0, parts[i].length() - 1);
                                    beginTs = LocalDateTime.parse(ts, VALUE_TIMESTAMP_PATTERN).atOffset(ZoneOffset.UTC).toInstant().toEpochMilli();
                                    break;
                                }
                                case 1: {
                                    varName = parts[i];
                                    break;
                                }
                                case 2: {
                                    value = Double.parseDouble(parts[i]);
                                    break;
                                }
                                case 3: {
                                    status = Integer.parseInt(parts[i]);
                                    break;
                                }
                                case 4: {
                                    String ts = parts[i].substring(0, parts[i].length() - 1);
                                    endTs = LocalDateTime.parse(ts, VALUE_TIMESTAMP_PATTERN).atOffset(ZoneOffset.UTC).toInstant().toEpochMilli();
                                    break;
                                }
                                case 5: {
                                    Character c;
                                    if (parts[i].length() == 1) {
                                        c = Character.valueOf(parts[i].charAt(0));
                                        break;
                                    }
                                    c = null;
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unexpected value: " + i);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception exc) {
                        logger.debug(String.format("Error reading CSV line %s", line), (Throwable)exc);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            result.values().forEach(v -> v.close());
            throw throwable;
        }
        result.values().forEach(v -> v.close());
        return result;
    }

    public static String mapToName(VariableInstance instance) {
        String baseVarName = String.format("%s->%s", instance.getVariable(), instance.getStructureObject());
        baseVarName = baseVarName.replace("\u20ac", "Euro");
        baseVarName = baseVarName.replace("\u03c9", "Omega");
        baseVarName = baseVarName.replace("\u03c1", "Rho");
        baseVarName = baseVarName.replace("\u03c9", "Omega");
        baseVarName = baseVarName.replace("\u00e4", "ae");
        baseVarName = baseVarName.replace("\u00f6", "oe");
        baseVarName = baseVarName.replace("\u00fc", "ue");
        baseVarName = baseVarName.replace("\u00df", "ss");
        baseVarName = baseVarName.replace("\u00c4", "Ae");
        baseVarName = baseVarName.replace("\u00d6", "Oe");
        baseVarName = baseVarName.replace("\u00dc", "Ue");
        return baseVarName;
    }

    private static class AcronExportDataEntry {
        private final long beginTs;
        private final String varName;
        private final double value;
        private final int status;
        private final long endTs;
        private final Character type;

        public AcronExportDataEntry(long beginTs, String varName, double value, int status, long endTs, Character type) {
            this.beginTs = beginTs;
            this.varName = varName;
            this.value = value;
            this.status = status;
            this.endTs = endTs;
            this.type = type;
        }

        public String toString() {
            String beginTsText = String.valueOf(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.beginTs), ZoneOffset.UTC).format(VALUE_TIMESTAMP_PATTERN)) + 'U';
            String endTsText = String.valueOf(LocalDateTime.ofInstant(Instant.ofEpochMilli(this.endTs), ZoneOffset.UTC).format(VALUE_TIMESTAMP_PATTERN)) + 'U';
            String doubleText = Double.isFinite(this.value) ? Double.toString(this.value) : "0";
            return String.format("%s;%s;%s;%d;%s;%s", beginTsText, this.varName, doubleText, this.status, endTsText, this.type != null ? this.type : "");
        }
    }
}

