/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export.component;

import de.elpro.ewms.core.export.ExportDataPolicy;
import de.elpro.ewms.core.export.ExportDataProfile;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.worker.AbstractWorker;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.export.ExportDataSchedule;
import de.elpro.ewms.server.export.ExportDataWriters;
import de.elpro.ewms.server.export.IExportDataWriter;
import de.elpro.ewms.server.export.VarValuesInvalidatedTracker;
import de.elpro.ewms.server.model.IServerComponent;
import de.elpro.ewms.server.model.ServerComponentInfo;
import de.elpro.ewms.server.rasterizedvalues.IVarValuesInvalidatedListener;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import de.elpro.ewms.server.transactions.Modification;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component
public class ExportDataServerComponent
implements IServerComponent {
    public static final String WORKER_EXPORT_DATA_PROFILE_GROUP_ID = "com.eos.server.export.data_profile_worker_group";
    public static final String SERVER_COMPONENT_ID = "com.eos.server.export";
    private static final ServerComponentInfo INFO = new ServerComponentInfo("com.eos.server.export", "1.0.0");
    private final Map<ExportDataProfile, ExportDataSchedule> exportJobBackgroundWorkers = new HashMap<ExportDataProfile, ExportDataSchedule>();
    @Log
    @Inject
    private Logger logger;
    @Inject
    private EntityManagerFactory entityManagerFactory;

    public ServerComponentInfo getInfo() {
        return INFO;
    }

    public boolean start() throws Exception {
        try (EntityManager em = this.entityManagerFactory.createEntityManager();){
            try {
                for (ExportDataProfile job : em.createQuery("SELECT o FROM ExportDataProfile o", ExportDataProfile.class).getResultList()) {
                    this.installProfile(job);
                }
            }
            catch (Exception exc) {
                this.logger.error("Error reading jobs", (Throwable)exc);
                em.close();
            }
        }
        return true;
    }

    @PostConstruct
    public void init() {
        Server.createWorkerGroup((String)WORKER_EXPORT_DATA_PROFILE_GROUP_ID, (String)"Export Data Profiles");
        TransactionChangeset.addPostCommitEventHandler(Object.class, (changes, properties) -> {
            try (EntityManager em = null;){
                Object o;
                for (Modification change : changes) {
                    o = change.getObject();
                    if (!(o instanceof ExportDataProfile)) continue;
                    if (em == null) {
                        em = Server.getEntityManagerFactory().createEntityManager();
                    }
                    ExportDataProfile exportDataProfile = (ExportDataProfile)o;
                    this.removeProfile(exportDataProfile);
                    ExportDataProfile persistedExportDataProfile = (ExportDataProfile)em.find(ExportDataProfile.class, (Object)exportDataProfile.getId());
                    if (persistedExportDataProfile == null) continue;
                    this.installProfile(persistedExportDataProfile);
                }
                for (Modification change : changes) {
                    o = change.getObject();
                    if (!(o instanceof VariableInstance)) continue;
                    if (em == null) {
                        em = Server.getEntityManagerFactory().createEntityManager();
                    }
                    for (ExportDataProfile p : em.createQuery("SELECT p FROM ExportDataProfile p", ExportDataProfile.class).getResultList()) {
                        if (p.getExportPolicy() != ExportDataPolicy.SelectedInstances && p.getExportPolicy() != ExportDataPolicy.UnselectedInstances) continue;
                        this.installProfile(p);
                    }
                    break;
                }
            }
        });
    }

    public synchronized ExportDataSchedule getSchedule(ExportDataProfile profile) {
        return this.exportJobBackgroundWorkers.get(profile);
    }

    private synchronized void installProfile(ExportDataProfile profile) {
        IExportDataWriter<?> dataWriter;
        if (this.exportJobBackgroundWorkers.containsKey(profile)) {
            this.removeProfile(profile);
        }
        if ((dataWriter = ExportDataWriters.get(profile.getDataWriterId())) == null) {
            this.logger.errorf("No ExportDataWriter implementation for id %s found", new Object[]{profile.getDataWriterId()});
            return;
        }
        if (profile.getExecutionInterval() == null) {
            return;
        }
        if (profile.getDataSliceSize() != null && profile.getDataSliceSize().ordinal() < profile.getDataRaster().ordinal()) {
            this.logger.errorf("Data Slice Raster %s of %s cannot be smaller than Data Raster %s", new Object[]{profile.getDataSliceSize(), profile, profile.getDataRaster()});
            return;
        }
        RasterizedValues rasterizedValues = Server.getRawValuesViews().getValuesView(profile.getDataSourceValuesViewType(), profile.getDataSourceValuesViewIndex());
        if (profile.getDataRaster().ordinal() < rasterizedValues.getRaster().ordinal()) {
            this.logger.errorf("Data Raster of %s cannot be smaller than rasterized values raster %s", new Object[]{profile, rasterizedValues.getRaster()});
            return;
        }
        if (profile.getDataSliceSize() != null && profile.getDataSliceSize().ordinal() < rasterizedValues.getRaster().ordinal()) {
            this.logger.errorf("Data Slice Raster of %s cannot be smaller than rasterized values raster %s", new Object[]{profile, rasterizedValues.getRaster()});
            return;
        }
        profile.getVariableInstances().size();
        VarValuesInvalidatedTracker invalidationTracker = new VarValuesInvalidatedTracker(profile);
        rasterizedValues.addOnVarValuesInvalidatedListener((IVarValuesInvalidatedListener)invalidationTracker);
        ExportDataSchedule schedule = new ExportDataSchedule(rasterizedValues, profile, dataWriter, invalidationTracker);
        this.exportJobBackgroundWorkers.put(profile, schedule);
        if (profile.isActive()) {
            schedule.startAsync();
        }
        Server.addWorker((String)WORKER_EXPORT_DATA_PROFILE_GROUP_ID, (AbstractWorker)schedule);
    }

    private synchronized void removeProfile(ExportDataProfile profile) {
        ExportDataSchedule schedule = this.exportJobBackgroundWorkers.get(profile);
        if (schedule == null) {
            return;
        }
        schedule.stopAsync();
        Server.removeWorker((String)WORKER_EXPORT_DATA_PROFILE_GROUP_ID, (AbstractWorker)schedule);
        this.exportJobBackgroundWorkers.remove(profile);
    }

    public void stop() {
    }
}

