/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.export.postgres;

import de.elpro.ewms.core.export.ExportDataWriterDescriptor;
import de.elpro.ewms.core.export.IExportDataWriterDescriptor;
import de.elpro.ewms.core.log.LogLevel;
import de.elpro.ewms.core.log.LogMessage;
import de.elpro.ewms.core.log.LogType;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.TsIntervals;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.server.export.IExportDataWriter;
import de.elpro.ewms.server.export.bundle.Activator;
import de.elpro.ewms.server.export.postgres.PostgresExportOptions;
import de.elpro.ewms.server.logger.LogDB;
import de.elpro.ewms.server.rasterizedvalues.RasterizedValues;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.component.annotations.Component;

@Component
public class PostgresDBDataWriter
implements IExportDataWriter<PostgresExportOptions> {
    public static final String ID = "com.eos.server.export.postgres.postgresdbdatawriter";
    public static Logger logger = Activator.getLoggerFactory().createLogger(PostgresDBDataWriter.class.getName());
    private static final PostgresExportOptions DEFAULT_OPTIONS = new PostgresExportOptions("localhost", 5432, "postgres", "sa2022pwd", "eos_export_values", "MyValuesTable", "MyVarInstanceTable", true);

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IExportDataWriterDescriptor getDescriptor() {
        return new ExportDataWriterDescriptor(ID, "Generic Postgres Data Writer", DEFAULT_OPTIONS.toJson(), "Bridge to Postgres Database");
    }

    @Override
    public PostgresExportOptions parseOptions(String optionsText) {
        return PostgresExportOptions.fromJson(optionsText);
    }

    @Override
    public Map<VariableInstance, TsIntervals> export(String jobName, PostgresExportOptions options, RasterizedValues rasterizedValues, ComplexRaster dataRaster, ComplexRaster dataSliceSize, Map<VariableInstance, TsIntervals> invalidatedIntervals) throws Exception {
        Map<VariableInstance, TsIntervals> invalidationIntervals = invalidatedIntervals;
        Map<VariableInstance, TsIntervals> leftIntervals = null;
        rasterizedValues.readLock();
        try {
            Map<VariableInstance, TsIntervals> map;
            block18: {
                Long plcNow = rasterizedValues.getPlcNow();
                boolean exportUncompleteIntervals = options.isExportUncompleteIntervals();
                if (!exportUncompleteIntervals && plcNow != null) {
                    Instant plcNowTs = Instant.ofEpochMilli(plcNow);
                    IExportDataWriter.InvalidationIntervals intervals = this.splitByTimestamp(dataRaster.getRasterBegin(plcNowTs), invalidatedIntervals);
                    if (intervals.getBeforeTsIntervals().isEmpty()) {
                        Map<VariableInstance, TsIntervals> map2 = intervals.getAfterTsIntervals();
                        return map2;
                    }
                    invalidationIntervals = intervals.getBeforeTsIntervals();
                    leftIntervals = intervals.getAfterTsIntervals();
                }
                String connectionUrl = String.format("jdbc:postgresql://%s:%d/%s", options.getHostName(), options.getPortNr(), options.getDbName());
                Throwable throwable = null;
                Object var13_16 = null;
                Connection conn = DriverManager.getConnection(connectionUrl, options.getUserName(), options.getUserPassword());
                try {
                    if (!PostgresDBDataWriter.tableExists(conn, options.getVarInstanceTableName())) {
                        PostgresDBDataWriter.createVarInstanceTable(conn, options);
                    }
                    if (!PostgresDBDataWriter.tableExists(conn, options.getValuesTableName())) {
                        PostgresDBDataWriter.createValuesTable(conn, options);
                    }
                    PostgresDBDataWriter.addVarInstanceRow(conn, options, invalidationIntervals.keySet());
                    this.removePrevValues(jobName, conn, options, dataRaster, invalidationIntervals);
                    this.insertNewValues(jobName, conn, options, rasterizedValues, dataRaster, plcNow, invalidationIntervals);
                    map = leftIntervals;
                    if (conn == null) break block18;
                }
                catch (Throwable throwable2) {
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                conn.close();
            }
            return map;
        }
        finally {
            rasterizedValues.readUnlock();
        }
    }

    private static void addVarInstanceRow(Connection conn, PostgresExportOptions options, Collection<VariableInstance> instances) throws SQLException {
        Statement stmt;
        HashMap instanceIds = new HashMap();
        instances.forEach(i -> {
            VariableInstance variableInstance = instanceIds.put(i.getId(), i);
        });
        Throwable throwable = null;
        Object var5_7 = null;
        try {
            stmt = conn.createStatement();
            try {
                LinkedList<VariableInstance> instancePool = new LinkedList<VariableInstance>(instances);
                while (!instancePool.isEmpty()) {
                    LinkedList<VariableInstance> partPool = new LinkedList<VariableInstance>();
                    while (!instancePool.isEmpty() && partPool.size() < 1000) {
                        partPool.add(instancePool.removeFirst());
                    }
                    StringBuilder idList = new StringBuilder("");
                    for (VariableInstance instance : partPool) {
                        if (idList.length() != 0) {
                            idList.append(',');
                        }
                        idList.append(instance.getId());
                    }
                    String selectRequest = String.format("SELECT var_instance_id FROM %s WHERE var_instance_id IN (%s)", options.getVarInstanceTableName(), idList.toString());
                    ResultSet rs = stmt.executeQuery(selectRequest);
                    while (rs.next()) {
                        int id = rs.getInt("var_instance_id");
                        instanceIds.remove(id);
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var5_7 = null;
        try {
            stmt = conn.prepareStatement(String.format("INSERT INTO %s(var_instance_id, var_name, obj_name, signal_id, calculation_formula, measuring_unit, aggregation, instance_type, supplement_strategy, description) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", options.getVarInstanceTableName()));
            try {
                for (VariableInstance instance : instanceIds.values()) {
                    String signalId = instance.getResultPlcDatasourceKey();
                    stmt.setInt(1, instance.getId());
                    stmt.setString(2, instance.getVariable().toString());
                    stmt.setString(3, instance.getStructureObject().toString());
                    stmt.setString(4, signalId);
                    stmt.setString(5, instance.getResultCalculationFormula());
                    stmt.setString(6, instance.getVariable().getMeasuringUnit().getId());
                    stmt.setString(7, instance.getVariable().getResultAggregation().name());
                    stmt.setString(8, instance.getType().name());
                    stmt.setString(9, instance.getSupplementValueStrategy() != null ? instance.getSupplementValueStrategy().name() : null);
                    stmt.setString(10, instance.getResultDescription());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void removePrevValues(String jobName, Connection conn, PostgresExportOptions options, ComplexRaster dataRaster, Map<VariableInstance, TsIntervals> invalidatedIntervals) throws SQLException {
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = conn.prepareStatement(String.format("DELETE FROM %s WHERE var_instance_id = ? AND begin_ts >= ? AND end_ts <= ? AND raster = ?", options.getValuesTableName()));){
            Instant beginTs;
            Instant ts = beginTs = Instant.now();
            int counter = 0;
            int instanceCounter = 0;
            for (Map.Entry<VariableInstance, TsIntervals> entry : invalidatedIntervals.entrySet()) {
                for (TsInterval interval : entry.getValue().getIntervals()) {
                    stmt.setInt(1, entry.getKey().getId());
                    Instant begin = dataRaster.getRasterBegin(Instant.ofEpochMilli(interval.getFromTs()).plusNanos(1L));
                    Instant end = dataRaster.getRasterEnd(Instant.ofEpochMilli(interval.getToTs()));
                    Timestamp fromTs = Timestamp.from(begin.minusNanos(1L));
                    Timestamp toTs = Timestamp.from(end);
                    stmt.setTimestamp(2, fromTs);
                    stmt.setTimestamp(3, toTs);
                    stmt.setString(4, dataRaster.name());
                    stmt.addBatch();
                    if (++counter < 10000) continue;
                    stmt.executeBatch();
                    counter = 0;
                }
                ++instanceCounter;
                if (Instant.now().toEpochMilli() - ts.toEpochMilli() <= 30000L) continue;
                ts = Instant.now();
                String message = String.format("Delete of '%s' old values from %s/%s/%s: %d of %d instances (%.1f%%) done in %.1f sek.", jobName, options.getHostName(), options.getDbName(), options.getValuesTableName(), instanceCounter, invalidatedIntervals.size(), 100.0 * (double)instanceCounter / (double)invalidatedIntervals.size(), (double)(ts.toEpochMilli() - beginTs.toEpochMilli()) / 1000.0);
                LogMessage logMsg = new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, ID, message);
                LogDB.addMessage((LogMessage)logMsg);
                logger.info(message);
            }
            if (counter > 0) {
                stmt.executeBatch();
            }
            if (Instant.now().toEpochMilli() - beginTs.toEpochMilli() > 30000L) {
                ts = Instant.now();
                String message = String.format("Delete of '%s' old values from %s/%s/%s: Done in %.1f sek.", jobName, options.getHostName(), options.getDbName(), options.getValuesTableName(), (double)(ts.toEpochMilli() - beginTs.toEpochMilli()) / 1000.0);
                LogMessage logMsg = new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, ID, message);
                LogDB.addMessage((LogMessage)logMsg);
                logger.info(message);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void insertNewValues(String jobName, Connection conn, PostgresExportOptions options, RasterizedValues rasterizedValues, ComplexRaster dataRaster, Long plcNow, Map<VariableInstance, TsIntervals> invalidatedIntervals) throws SQLException {
        Throwable throwable = null;
        Object var9_10 = null;
        try (PreparedStatement stmt = conn.prepareStatement(String.format("INSERT INTO %s(var_instance_id, begin_ts, end_ts, raster, value, quality) VALUES (?, ?, ?, ?, ?, ?)", options.getValuesTableName()));){
            Instant beginTs;
            Instant ts = beginTs = Instant.now();
            Raster raster = rasterizedValues.getRaster();
            int counter = 0;
            int instanceCounter = 0;
            for (Map.Entry<VariableInstance, TsIntervals> entry : invalidatedIntervals.entrySet()) {
                VariableInstance instance = entry.getKey();
                for (TsInterval interval : entry.getValue().getIntervals()) {
                    Instant begin = dataRaster.getRasterBegin(Instant.ofEpochMilli(raster.getRasterBegin(interval.getFromTs())).plusNanos(1L));
                    Instant end = dataRaster.getRasterEnd(Instant.ofEpochMilli(raster.getRasterEnd(interval.getToTs())));
                    IVarValuesCollection values = rasterizedValues.getValues(instance, begin, end, dataRaster);
                    for (IVarValue val : values) {
                        if (!val.isValid()) continue;
                        stmt.setInt(1, instance.getId());
                        Instant startTimestamp = dataRaster.getRasterBegin(Instant.ofEpochMilli(val.getEndTimestamp()));
                        stmt.setTimestamp(2, Timestamp.from(startTimestamp));
                        stmt.setTimestamp(3, Timestamp.from(Instant.ofEpochMilli(val.getEndTimestamp())));
                        stmt.setString(4, dataRaster.name());
                        stmt.setDouble(5, val.getValue());
                        stmt.setDouble(6, val.getQuality());
                        stmt.addBatch();
                        if (++counter < 10000) continue;
                        stmt.executeBatch();
                        counter = 0;
                    }
                }
                ++instanceCounter;
                if (Instant.now().toEpochMilli() - ts.toEpochMilli() <= 30000L) continue;
                ts = Instant.now();
                String message = String.format("Export of '%s' into %s/%s/%s: %d of %d instances (%.1f%%) done in %.1f sek.", jobName, options.getHostName(), options.getDbName(), options.getValuesTableName(), instanceCounter, invalidatedIntervals.size(), 100.0 * (double)instanceCounter / (double)invalidatedIntervals.size(), (double)(ts.toEpochMilli() - beginTs.toEpochMilli()) / 1000.0);
                LogMessage logMsg = new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, ID, message);
                LogDB.addMessage((LogMessage)logMsg);
                logger.info(message);
            }
            if (counter > 0) {
                stmt.executeBatch();
            }
            if (Instant.now().toEpochMilli() - beginTs.toEpochMilli() > 30000L) {
                ts = Instant.now();
                String message = String.format("Export of '%s' into %s/%s/%s: Done in %.1f sek.", jobName, options.getHostName(), options.getDbName(), options.getValuesTableName(), (double)(ts.toEpochMilli() - beginTs.toEpochMilli()) / 1000.0);
                LogMessage logMsg = new LogMessage(Instant.now(), LogType.User, LogLevel.INFO, ID, message);
                LogDB.addMessage((LogMessage)logMsg);
                logger.info(message);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void createVarInstanceTable(Connection conn, PostgresExportOptions options) throws SQLException {
        String query = String.valueOf(String.format("CREATE TABLE IF NOT EXISTS %s(", options.getVarInstanceTableName())) + "var_instance_id integer NOT NULL, var_name character varying(255) NOT NULL, obj_name character varying(255) NOT NULL, " + "signal_id character varying(255), calculation_formula text, measuring_unit character varying(255) NOT NULL, aggregation character varying(255) NOT NULL, " + "instance_type character varying(32) NOT NULL, supplement_strategy character varying(32), description text, " + String.format("CONSTRAINT %s_pkey PRIMARY KEY (var_instance_id) )", options.getVarInstanceTableName());
        Statement stmt = conn.createStatement();
        stmt.execute(query);
    }

    private static void createValuesTable(Connection conn, PostgresExportOptions options) throws SQLException {
        String query = String.valueOf(String.format("CREATE TABLE IF NOT EXISTS %s(", options.getValuesTableName())) + "var_instance_id integer, " + "begin_ts timestamp with time zone NOT NULL, " + "end_ts timestamp with time zone NOT NULL, " + "raster character varying(16) NOT NULL, " + "value numeric NOT NULL, quality numeric NOT NULL, " + String.format("CONSTRAINT %s_pkey PRIMARY KEY (var_instance_id, begin_ts, end_ts, raster), ", options.getValuesTableName()) + String.format("CONSTRAINT %s_fkey_1 FOREIGN KEY (var_instance_id) REFERENCES %s(var_instance_id) ON DELETE CASCADE)", options.getValuesTableName(), options.getVarInstanceTableName());
        Statement stmt = conn.createStatement();
        stmt.execute(query);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean tableExists(Connection conn, String tableName) throws SQLException {
        String tableNamePostgresStyle = tableName.toLowerCase();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ResultSet rs = conn.getMetaData().getTables(null, null, tableNamePostgresStyle, null);){
            String tName;
            do {
                if (rs.next()) continue;
                return false;
            } while ((tName = rs.getString("TABLE_NAME")) == null || !tName.equals(tableNamePostgresStyle));
            return true;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }
}

