/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.auth;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.server.auth.AuthenticationDatabase;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.StringTokenizer;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.fx.core.log.Logger;

@Secured
@Provider
public class AuthenticationFilter
implements ContainerRequestFilter {
    @Context
    private ResourceInfo resourceInfo;
    private static final Logger logger = Activator.getLoggerFactory().createLogger(AuthenticationFilter.class.getName());

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authorizationHeader = requestContext.getHeaderString("Authorization");
        if (authorizationHeader == null) {
            throw new NotAuthorizedException((Object)"Authorization header must be provided", new Object[0]);
        }
        String encodedUserPassword = authorizationHeader.replaceFirst("Basic ", "");
        String usernameAndPassword = null;
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(encodedUserPassword);
            usernameAndPassword = new String(decodedBytes, "UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringTokenizer tokenizer = new StringTokenizer(usernameAndPassword, ":");
        final String login = StringEscapeUtils.unescapeJava((String)tokenizer.nextToken());
        String sessionKey = tokenizer.nextToken();
        try {
            User user = this.validateSession(login, sessionKey);
            requestContext.setSecurityContext(new SecurityContext(){

                public boolean isUserInRole(String role) {
                    return true;
                }

                public boolean isSecure() {
                    return true;
                }

                public Principal getUserPrincipal() {
                    return () -> login;
                }

                public String getAuthenticationScheme() {
                    return null;
                }
            });
            if (requestContext.getHeaders().containsKey((Object)"eos-web-client")) {
                user.setIsWebUser(true);
            }
        }
        catch (Exception e) {
            throw new NotAuthorizedException((Object)e.getMessage(), new Object[0]);
        }
        Class resourceClass = this.resourceInfo.getResourceClass();
        List<String> classRoles = this.extractRoles(resourceClass);
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        List<String> methodRoles = this.extractRoles(resourceMethod);
        try {
            if (methodRoles.isEmpty()) {
                this.checkPermissions(login, classRoles);
            } else {
                this.checkPermissions(login, methodRoles);
            }
        }
        catch (Exception exception) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.FORBIDDEN).build());
        }
    }

    private User validateSession(String loginPhrase, String sessionKey) throws Exception {
        User user = ORMCache.getUser((String)loginPhrase);
        if (user == null) {
            throw new Exception(String.format("User %s not found", loginPhrase));
        }
        if (!AuthenticationDatabase.checkSession((User)user, (String)sessionKey)) {
            throw new Exception(String.format("Session not valid for user %s", loginPhrase));
        }
        return user;
    }

    private List<String> extractRoles(AnnotatedElement annotatedElement) {
        if (annotatedElement == null) {
            return new ArrayList<String>();
        }
        Secured secured = annotatedElement.getAnnotation(Secured.class);
        if (secured == null) {
            return new ArrayList<String>();
        }
        String[] allowedRoles = secured.value();
        return Arrays.asList(allowedRoles);
    }

    private void checkPermissions(String login, List<String> allowedRoles) throws Exception {
        User user = ORMCache.getUser((String)login);
        if (!user.isActive()) {
            throw new Exception(String.format("User %s is inactive!", user));
        }
    }
}

