/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.auth;

import de.elpro.ewms.core.auth.LoginRequest;
import de.elpro.ewms.core.auth.LoginResponse;
import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.StrongPasswordEncryptor;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.charts.viewprefs.Chart3DViewPrefs;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.tables.viewprefs.TableViewPrefs;
import de.elpro.ewms.server.Server;
import de.elpro.ewms.server.auth.AuthenticationDatabase;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import de.elpro.ui.net.InetUtils;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.persistence.EntityManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="auth/user")
public class UserRestService
extends AbstractRestService<User> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(UserRestService.class.getName());
    private static final Cipher AUTH_DECRYPTOR;
    private static StrongPasswordEncryptor PASSWORD_ENCRYPTOR;

    static {
        PASSWORD_ENCRYPTOR = new StrongPasswordEncryptor();
        byte[] byArray = new byte[1217];
        byArray[0] = 48;
        byArray[1] = -126;
        byArray[2] = 4;
        byArray[3] = -67;
        byArray[4] = 2;
        byArray[5] = 1;
        byArray[7] = 48;
        byArray[8] = 13;
        byArray[9] = 6;
        byArray[10] = 9;
        byArray[11] = 42;
        byArray[12] = -122;
        byArray[13] = 72;
        byArray[14] = -122;
        byArray[15] = -9;
        byArray[16] = 13;
        byArray[17] = 1;
        byArray[18] = 1;
        byArray[19] = 1;
        byArray[20] = 5;
        byArray[22] = 4;
        byArray[23] = -126;
        byArray[24] = 4;
        byArray[25] = -89;
        byArray[26] = 48;
        byArray[27] = -126;
        byArray[28] = 4;
        byArray[29] = -93;
        byArray[30] = 2;
        byArray[31] = 1;
        byArray[33] = 2;
        byArray[34] = -126;
        byArray[35] = 1;
        byArray[36] = 1;
        byArray[38] = -88;
        byArray[39] = -10;
        byArray[40] = -19;
        byArray[41] = -63;
        byArray[42] = 51;
        byArray[43] = 28;
        byArray[44] = -52;
        byArray[45] = -105;
        byArray[46] = -5;
        byArray[47] = 105;
        byArray[48] = -66;
        byArray[49] = 41;
        byArray[50] = -125;
        byArray[51] = -39;
        byArray[52] = -52;
        byArray[53] = 67;
        byArray[54] = -38;
        byArray[55] = -112;
        byArray[56] = -42;
        byArray[57] = 123;
        byArray[58] = 114;
        byArray[59] = 99;
        byArray[60] = 34;
        byArray[61] = 27;
        byArray[62] = -70;
        byArray[63] = -44;
        byArray[64] = -32;
        byArray[65] = -124;
        byArray[66] = 116;
        byArray[67] = 120;
        byArray[68] = -121;
        byArray[69] = -101;
        byArray[70] = -69;
        byArray[71] = -81;
        byArray[72] = 44;
        byArray[73] = 83;
        byArray[74] = -72;
        byArray[75] = 123;
        byArray[76] = 15;
        byArray[77] = 68;
        byArray[78] = -45;
        byArray[79] = -30;
        byArray[80] = -125;
        byArray[81] = 11;
        byArray[82] = -33;
        byArray[83] = 23;
        byArray[84] = 78;
        byArray[85] = 52;
        byArray[86] = -81;
        byArray[87] = -39;
        byArray[88] = 40;
        byArray[89] = -35;
        byArray[90] = -78;
        byArray[91] = -66;
        byArray[92] = -42;
        byArray[93] = 3;
        byArray[94] = 94;
        byArray[95] = 29;
        byArray[96] = 59;
        byArray[97] = 120;
        byArray[98] = -17;
        byArray[99] = 78;
        byArray[100] = -3;
        byArray[101] = 55;
        byArray[102] = 108;
        byArray[103] = 120;
        byArray[104] = 20;
        byArray[105] = -114;
        byArray[106] = 17;
        byArray[107] = 66;
        byArray[108] = -114;
        byArray[109] = 36;
        byArray[110] = 24;
        byArray[111] = -83;
        byArray[112] = -114;
        byArray[113] = -39;
        byArray[114] = -103;
        byArray[115] = 73;
        byArray[116] = 3;
        byArray[117] = 52;
        byArray[118] = -86;
        byArray[119] = -95;
        byArray[120] = -119;
        byArray[121] = 75;
        byArray[122] = -99;
        byArray[123] = 85;
        byArray[124] = -40;
        byArray[126] = 46;
        byArray[127] = 92;
        byArray[128] = 53;
        byArray[129] = -120;
        byArray[130] = 125;
        byArray[131] = 11;
        byArray[132] = 1;
        byArray[133] = 22;
        byArray[134] = 113;
        byArray[135] = -54;
        byArray[136] = -35;
        byArray[137] = -94;
        byArray[138] = -85;
        byArray[139] = -12;
        byArray[140] = 79;
        byArray[141] = -43;
        byArray[142] = -104;
        byArray[143] = -70;
        byArray[144] = 6;
        byArray[145] = 107;
        byArray[146] = 87;
        byArray[147] = 104;
        byArray[148] = -17;
        byArray[149] = 99;
        byArray[150] = 2;
        byArray[151] = -8;
        byArray[152] = 89;
        byArray[153] = 72;
        byArray[154] = -12;
        byArray[155] = -33;
        byArray[156] = 93;
        byArray[157] = -2;
        byArray[158] = -52;
        byArray[159] = 96;
        byArray[160] = -89;
        byArray[161] = -33;
        byArray[162] = -35;
        byArray[163] = -23;
        byArray[164] = -56;
        byArray[165] = -104;
        byArray[166] = -24;
        byArray[167] = -33;
        byArray[168] = 61;
        byArray[169] = 25;
        byArray[170] = -92;
        byArray[171] = -6;
        byArray[172] = 101;
        byArray[173] = 102;
        byArray[174] = 73;
        byArray[175] = 44;
        byArray[176] = 31;
        byArray[177] = -56;
        byArray[178] = -82;
        byArray[180] = -122;
        byArray[181] = -69;
        byArray[182] = -32;
        byArray[183] = -38;
        byArray[184] = -61;
        byArray[185] = 41;
        byArray[186] = -36;
        byArray[187] = -89;
        byArray[188] = -42;
        byArray[189] = -125;
        byArray[190] = 45;
        byArray[191] = -4;
        byArray[192] = 58;
        byArray[193] = -77;
        byArray[194] = -125;
        byArray[195] = 9;
        byArray[196] = -18;
        byArray[197] = -29;
        byArray[198] = -37;
        byArray[199] = -74;
        byArray[200] = 2;
        byArray[201] = 92;
        byArray[202] = -94;
        byArray[203] = -56;
        byArray[204] = -21;
        byArray[205] = 49;
        byArray[206] = 52;
        byArray[207] = -1;
        byArray[208] = 94;
        byArray[209] = 67;
        byArray[210] = 33;
        byArray[211] = -86;
        byArray[212] = -72;
        byArray[213] = 112;
        byArray[214] = -109;
        byArray[215] = -79;
        byArray[216] = 35;
        byArray[217] = -113;
        byArray[218] = 22;
        byArray[219] = 120;
        byArray[220] = 21;
        byArray[221] = -124;
        byArray[222] = -111;
        byArray[223] = 45;
        byArray[224] = 73;
        byArray[225] = 55;
        byArray[226] = 30;
        byArray[227] = 123;
        byArray[228] = -48;
        byArray[229] = -11;
        byArray[230] = -95;
        byArray[231] = -83;
        byArray[232] = -84;
        byArray[233] = -15;
        byArray[234] = -65;
        byArray[235] = 62;
        byArray[236] = 102;
        byArray[237] = 38;
        byArray[238] = -37;
        byArray[239] = 58;
        byArray[240] = 90;
        byArray[241] = -36;
        byArray[242] = 87;
        byArray[243] = 88;
        byArray[244] = 126;
        byArray[245] = -28;
        byArray[246] = -64;
        byArray[247] = 73;
        byArray[248] = -88;
        byArray[249] = 127;
        byArray[250] = -22;
        byArray[251] = 7;
        byArray[252] = 47;
        byArray[253] = -65;
        byArray[254] = 31;
        byArray[255] = 83;
        byArray[256] = -31;
        byArray[257] = -107;
        byArray[258] = -36;
        byArray[259] = -32;
        byArray[260] = 68;
        byArray[261] = 75;
        byArray[262] = -23;
        byArray[263] = 51;
        byArray[264] = 97;
        byArray[265] = -106;
        byArray[266] = -87;
        byArray[267] = -7;
        byArray[268] = -47;
        byArray[269] = 34;
        byArray[270] = 47;
        byArray[271] = 18;
        byArray[272] = -69;
        byArray[273] = 2;
        byArray[274] = 84;
        byArray[275] = -42;
        byArray[276] = -21;
        byArray[277] = 112;
        byArray[278] = 10;
        byArray[279] = 49;
        byArray[280] = -96;
        byArray[281] = -43;
        byArray[282] = -85;
        byArray[283] = 2;
        byArray[284] = -59;
        byArray[285] = -99;
        byArray[286] = -71;
        byArray[287] = -119;
        byArray[288] = 96;
        byArray[289] = 111;
        byArray[290] = 75;
        byArray[291] = 105;
        byArray[292] = 8;
        byArray[293] = -107;
        byArray[294] = 2;
        byArray[295] = 3;
        byArray[296] = 1;
        byArray[298] = 1;
        byArray[299] = 2;
        byArray[300] = -126;
        byArray[301] = 1;
        byArray[303] = 36;
        byArray[304] = 65;
        byArray[305] = 7;
        byArray[306] = 118;
        byArray[307] = -62;
        byArray[308] = -18;
        byArray[309] = -44;
        byArray[310] = -1;
        byArray[311] = 111;
        byArray[312] = 84;
        byArray[313] = -101;
        byArray[314] = 22;
        byArray[315] = -15;
        byArray[316] = 81;
        byArray[317] = -108;
        byArray[318] = 64;
        byArray[319] = -94;
        byArray[320] = -17;
        byArray[321] = 28;
        byArray[322] = -10;
        byArray[323] = 83;
        byArray[324] = -18;
        byArray[325] = -19;
        byArray[326] = 108;
        byArray[327] = -95;
        byArray[328] = -61;
        byArray[329] = -9;
        byArray[330] = -128;
        byArray[331] = -76;
        byArray[332] = 53;
        byArray[334] = 115;
        byArray[335] = -21;
        byArray[336] = -21;
        byArray[337] = -124;
        byArray[338] = 73;
        byArray[339] = 90;
        byArray[340] = 118;
        byArray[341] = 29;
        byArray[342] = 42;
        byArray[343] = -103;
        byArray[344] = -124;
        byArray[345] = 42;
        byArray[346] = -74;
        byArray[347] = 43;
        byArray[348] = 98;
        byArray[349] = 38;
        byArray[350] = -57;
        byArray[351] = -85;
        byArray[352] = 75;
        byArray[353] = -97;
        byArray[354] = 55;
        byArray[355] = 34;
        byArray[356] = -103;
        byArray[357] = 75;
        byArray[358] = -10;
        byArray[359] = 97;
        byArray[360] = 5;
        byArray[361] = 72;
        byArray[362] = -77;
        byArray[363] = -124;
        byArray[364] = 53;
        byArray[365] = -96;
        byArray[366] = -93;
        byArray[367] = 121;
        byArray[368] = -60;
        byArray[369] = -78;
        byArray[370] = 52;
        byArray[371] = 97;
        byArray[372] = -125;
        byArray[373] = -76;
        byArray[374] = 88;
        byArray[375] = 14;
        byArray[376] = 107;
        byArray[377] = 127;
        byArray[378] = 17;
        byArray[379] = 53;
        byArray[380] = -112;
        byArray[381] = -78;
        byArray[382] = -3;
        byArray[383] = 99;
        byArray[384] = -9;
        byArray[385] = 81;
        byArray[386] = 44;
        byArray[387] = 70;
        byArray[388] = 80;
        byArray[389] = 27;
        byArray[390] = 14;
        byArray[391] = -66;
        byArray[392] = -29;
        byArray[393] = -50;
        byArray[394] = 32;
        byArray[395] = -63;
        byArray[396] = 35;
        byArray[397] = -47;
        byArray[398] = 81;
        byArray[399] = -19;
        byArray[400] = -116;
        byArray[401] = -89;
        byArray[402] = -51;
        byArray[403] = -75;
        byArray[404] = -77;
        byArray[405] = -80;
        byArray[406] = 69;
        byArray[407] = -106;
        byArray[408] = -123;
        byArray[409] = -93;
        byArray[410] = -58;
        byArray[411] = -8;
        byArray[412] = 116;
        byArray[413] = 109;
        byArray[414] = -103;
        byArray[415] = 3;
        byArray[416] = 20;
        byArray[417] = 34;
        byArray[418] = -92;
        byArray[419] = 66;
        byArray[420] = -42;
        byArray[421] = -126;
        byArray[422] = -90;
        byArray[423] = -97;
        byArray[424] = 87;
        byArray[425] = -59;
        byArray[426] = -19;
        byArray[427] = -123;
        byArray[428] = 2;
        byArray[429] = 26;
        byArray[430] = -90;
        byArray[431] = 74;
        byArray[432] = 41;
        byArray[433] = -105;
        byArray[434] = 30;
        byArray[435] = -73;
        byArray[436] = 21;
        byArray[437] = -121;
        byArray[438] = -44;
        byArray[439] = 47;
        byArray[440] = 106;
        byArray[441] = 61;
        byArray[442] = 35;
        byArray[443] = -33;
        byArray[444] = -124;
        byArray[445] = -53;
        byArray[446] = 25;
        byArray[447] = 83;
        byArray[448] = 60;
        byArray[449] = 38;
        byArray[450] = -10;
        byArray[451] = 74;
        byArray[452] = 40;
        byArray[453] = -41;
        byArray[454] = 123;
        byArray[455] = -31;
        byArray[456] = -30;
        byArray[457] = -3;
        byArray[458] = 84;
        byArray[459] = -52;
        byArray[460] = -4;
        byArray[461] = 58;
        byArray[462] = 63;
        byArray[463] = -43;
        byArray[464] = 116;
        byArray[465] = 14;
        byArray[466] = -49;
        byArray[467] = 14;
        byArray[468] = -2;
        byArray[469] = -58;
        byArray[470] = 71;
        byArray[471] = -31;
        byArray[472] = 60;
        byArray[473] = -71;
        byArray[474] = 34;
        byArray[475] = 20;
        byArray[476] = -79;
        byArray[477] = -124;
        byArray[478] = -52;
        byArray[479] = -33;
        byArray[480] = 62;
        byArray[481] = -93;
        byArray[482] = -83;
        byArray[483] = 8;
        byArray[484] = -86;
        byArray[485] = -77;
        byArray[486] = 127;
        byArray[487] = 101;
        byArray[488] = -102;
        byArray[489] = 86;
        byArray[490] = 50;
        byArray[491] = -46;
        byArray[492] = -31;
        byArray[493] = -45;
        byArray[494] = 11;
        byArray[495] = -8;
        byArray[496] = -72;
        byArray[497] = -4;
        byArray[498] = -74;
        byArray[499] = 56;
        byArray[500] = 72;
        byArray[501] = 83;
        byArray[502] = -127;
        byArray[503] = 77;
        byArray[504] = -19;
        byArray[505] = -36;
        byArray[506] = -22;
        byArray[507] = 125;
        byArray[508] = -18;
        byArray[509] = 15;
        byArray[510] = -121;
        byArray[511] = 56;
        byArray[512] = 122;
        byArray[513] = -65;
        byArray[514] = 100;
        byArray[515] = 108;
        byArray[516] = -48;
        byArray[517] = -5;
        byArray[518] = 39;
        byArray[519] = 28;
        byArray[520] = 27;
        byArray[521] = 63;
        byArray[522] = 14;
        byArray[523] = -81;
        byArray[524] = 106;
        byArray[525] = 66;
        byArray[526] = 127;
        byArray[527] = 76;
        byArray[528] = -7;
        byArray[529] = -70;
        byArray[530] = 5;
        byArray[531] = -22;
        byArray[532] = -29;
        byArray[533] = -8;
        byArray[534] = -35;
        byArray[535] = -49;
        byArray[536] = 51;
        byArray[537] = -73;
        byArray[538] = -117;
        byArray[539] = 113;
        byArray[540] = 14;
        byArray[541] = -111;
        byArray[542] = 34;
        byArray[543] = 58;
        byArray[544] = -51;
        byArray[545] = 118;
        byArray[546] = -125;
        byArray[547] = 45;
        byArray[548] = -104;
        byArray[549] = -24;
        byArray[550] = 28;
        byArray[551] = -128;
        byArray[552] = 84;
        byArray[553] = -8;
        byArray[554] = -109;
        byArray[555] = 97;
        byArray[556] = 86;
        byArray[557] = 29;
        byArray[558] = 41;
        byArray[559] = 2;
        byArray[560] = -127;
        byArray[561] = -127;
        byArray[563] = -11;
        byArray[564] = 67;
        byArray[565] = -128;
        byArray[566] = 116;
        byArray[567] = 37;
        byArray[568] = -113;
        byArray[569] = 6;
        byArray[570] = 104;
        byArray[571] = -2;
        byArray[572] = -3;
        byArray[573] = 44;
        byArray[574] = -31;
        byArray[575] = -80;
        byArray[576] = 39;
        byArray[577] = 105;
        byArray[578] = 90;
        byArray[579] = 77;
        byArray[580] = -47;
        byArray[581] = 42;
        byArray[582] = 109;
        byArray[583] = 63;
        byArray[584] = -82;
        byArray[585] = -32;
        byArray[586] = -119;
        byArray[587] = -42;
        byArray[588] = 7;
        byArray[589] = 83;
        byArray[590] = -96;
        byArray[591] = -2;
        byArray[592] = 113;
        byArray[593] = -73;
        byArray[594] = 105;
        byArray[595] = -66;
        byArray[596] = -36;
        byArray[597] = 116;
        byArray[598] = 77;
        byArray[599] = 35;
        byArray[600] = -15;
        byArray[601] = 47;
        byArray[602] = -45;
        byArray[603] = -11;
        byArray[604] = 31;
        byArray[605] = -98;
        byArray[606] = 47;
        byArray[607] = -36;
        byArray[608] = 18;
        byArray[609] = 104;
        byArray[610] = 120;
        byArray[611] = -70;
        byArray[612] = -28;
        byArray[613] = -123;
        byArray[614] = -115;
        byArray[615] = 65;
        byArray[616] = 5;
        byArray[617] = 18;
        byArray[618] = -125;
        byArray[619] = -47;
        byArray[620] = 37;
        byArray[621] = 93;
        byArray[622] = 125;
        byArray[623] = 95;
        byArray[624] = 58;
        byArray[625] = 63;
        byArray[626] = -97;
        byArray[627] = -116;
        byArray[628] = 122;
        byArray[629] = -52;
        byArray[630] = -71;
        byArray[631] = -126;
        byArray[632] = 1;
        byArray[633] = 6;
        byArray[634] = -42;
        byArray[635] = -75;
        byArray[636] = 69;
        byArray[637] = 58;
        byArray[638] = -14;
        byArray[639] = -36;
        byArray[640] = -122;
        byArray[641] = 51;
        byArray[642] = -11;
        byArray[643] = -121;
        byArray[644] = -22;
        byArray[645] = 86;
        byArray[646] = 23;
        byArray[647] = 23;
        byArray[648] = -16;
        byArray[649] = -108;
        byArray[650] = -127;
        byArray[651] = 36;
        byArray[652] = 32;
        byArray[653] = 28;
        byArray[654] = 72;
        byArray[655] = 79;
        byArray[656] = -57;
        byArray[657] = -87;
        byArray[658] = 73;
        byArray[659] = 115;
        byArray[660] = 110;
        byArray[661] = 40;
        byArray[662] = 78;
        byArray[663] = -55;
        byArray[664] = -107;
        byArray[665] = -101;
        byArray[666] = -80;
        byArray[667] = 2;
        byArray[668] = 61;
        byArray[669] = -113;
        byArray[670] = 28;
        byArray[671] = 24;
        byArray[672] = 11;
        byArray[673] = 114;
        byArray[674] = 56;
        byArray[675] = -108;
        byArray[676] = -27;
        byArray[677] = 12;
        byArray[678] = 33;
        byArray[679] = 118;
        byArray[680] = -27;
        byArray[681] = 42;
        byArray[682] = -88;
        byArray[683] = -104;
        byArray[684] = -83;
        byArray[685] = -127;
        byArray[686] = 13;
        byArray[687] = -32;
        byArray[688] = -105;
        byArray[689] = 79;
        byArray[690] = -121;
        byArray[691] = 2;
        byArray[692] = -127;
        byArray[693] = -127;
        byArray[695] = -80;
        byArray[696] = 92;
        byArray[697] = 101;
        byArray[698] = 112;
        byArray[699] = 67;
        byArray[700] = 39;
        byArray[701] = -11;
        byArray[702] = -116;
        byArray[703] = -6;
        byArray[704] = 102;
        byArray[705] = -91;
        byArray[706] = 116;
        byArray[707] = -80;
        byArray[708] = 34;
        byArray[709] = -6;
        byArray[710] = -45;
        byArray[711] = 98;
        byArray[712] = -14;
        byArray[713] = -5;
        byArray[714] = 121;
        byArray[715] = 31;
        byArray[716] = -21;
        byArray[717] = 89;
        byArray[718] = -108;
        byArray[719] = 62;
        byArray[720] = 116;
        byArray[721] = 34;
        byArray[722] = 80;
        byArray[723] = -58;
        byArray[724] = 10;
        byArray[725] = -104;
        byArray[726] = 83;
        byArray[727] = -76;
        byArray[728] = -110;
        byArray[729] = -78;
        byArray[730] = 40;
        byArray[731] = -69;
        byArray[732] = 54;
        byArray[733] = -67;
        byArray[734] = 62;
        byArray[735] = -28;
        byArray[736] = 102;
        byArray[737] = -110;
        byArray[738] = 9;
        byArray[739] = -59;
        byArray[740] = -98;
        byArray[741] = -42;
        byArray[742] = -55;
        byArray[743] = -74;
        byArray[744] = -33;
        byArray[745] = -73;
        byArray[746] = 62;
        byArray[747] = -48;
        byArray[748] = -119;
        byArray[749] = -23;
        byArray[750] = 38;
        byArray[751] = 96;
        byArray[752] = -46;
        byArray[753] = -70;
        byArray[754] = -88;
        byArray[755] = -15;
        byArray[756] = 60;
        byArray[757] = 74;
        byArray[758] = 31;
        byArray[759] = 36;
        byArray[760] = -33;
        byArray[761] = -62;
        byArray[762] = -1;
        byArray[763] = 42;
        byArray[764] = -106;
        byArray[765] = 120;
        byArray[766] = -50;
        byArray[767] = -109;
        byArray[768] = 33;
        byArray[769] = 98;
        byArray[770] = 81;
        byArray[771] = 87;
        byArray[772] = -74;
        byArray[773] = 68;
        byArray[774] = 72;
        byArray[775] = -45;
        byArray[776] = 85;
        byArray[777] = -84;
        byArray[778] = -16;
        byArray[779] = -77;
        byArray[780] = 29;
        byArray[781] = 50;
        byArray[782] = 125;
        byArray[783] = 5;
        byArray[784] = 81;
        byArray[785] = 89;
        byArray[786] = -37;
        byArray[787] = -108;
        byArray[788] = 36;
        byArray[789] = 122;
        byArray[790] = 16;
        byArray[791] = -1;
        byArray[792] = 79;
        byArray[793] = 51;
        byArray[794] = 62;
        byArray[795] = 63;
        byArray[796] = 99;
        byArray[797] = 58;
        byArray[798] = -23;
        byArray[799] = 88;
        byArray[800] = 43;
        byArray[801] = 96;
        byArray[802] = -112;
        byArray[803] = 85;
        byArray[804] = -68;
        byArray[805] = 82;
        byArray[806] = -54;
        byArray[807] = 21;
        byArray[808] = 74;
        byArray[809] = -124;
        byArray[810] = -103;
        byArray[811] = 84;
        byArray[812] = -77;
        byArray[813] = -126;
        byArray[814] = -26;
        byArray[815] = -77;
        byArray[816] = -84;
        byArray[817] = -95;
        byArray[818] = -51;
        byArray[819] = -11;
        byArray[820] = 38;
        byArray[821] = -106;
        byArray[822] = 3;
        byArray[823] = 2;
        byArray[824] = -127;
        byArray[825] = -128;
        byArray[826] = 116;
        byArray[827] = -20;
        byArray[828] = 64;
        byArray[829] = 49;
        byArray[830] = -98;
        byArray[831] = -78;
        byArray[832] = 39;
        byArray[833] = -127;
        byArray[834] = 40;
        byArray[835] = -122;
        byArray[836] = 115;
        byArray[837] = -66;
        byArray[838] = 7;
        byArray[839] = -25;
        byArray[840] = 81;
        byArray[841] = -1;
        byArray[842] = 61;
        byArray[843] = -9;
        byArray[844] = -56;
        byArray[845] = 61;
        byArray[846] = 26;
        byArray[847] = -51;
        byArray[848] = -8;
        byArray[849] = -73;
        byArray[850] = 93;
        byArray[851] = 52;
        byArray[852] = 82;
        byArray[853] = -10;
        byArray[854] = -2;
        byArray[855] = 54;
        byArray[856] = 34;
        byArray[857] = 21;
        byArray[858] = 36;
        byArray[859] = 107;
        byArray[860] = 30;
        byArray[861] = 122;
        byArray[862] = -93;
        byArray[863] = -10;
        byArray[864] = -40;
        byArray[865] = 49;
        byArray[866] = 56;
        byArray[867] = -69;
        byArray[868] = 97;
        byArray[869] = 3;
        byArray[870] = 57;
        byArray[871] = -20;
        byArray[873] = -88;
        byArray[874] = 5;
        byArray[875] = -104;
        byArray[876] = -23;
        byArray[877] = -34;
        byArray[878] = 36;
        byArray[879] = 48;
        byArray[880] = 17;
        byArray[881] = -38;
        byArray[882] = -117;
        byArray[883] = 123;
        byArray[884] = 63;
        byArray[885] = -83;
        byArray[886] = -124;
        byArray[887] = 23;
        byArray[888] = 85;
        byArray[889] = -69;
        byArray[890] = 111;
        byArray[891] = 18;
        byArray[892] = 31;
        byArray[893] = -59;
        byArray[894] = 20;
        byArray[895] = 39;
        byArray[896] = -1;
        byArray[897] = 37;
        byArray[898] = -98;
        byArray[899] = 119;
        byArray[900] = 41;
        byArray[901] = -102;
        byArray[902] = 27;
        byArray[903] = -19;
        byArray[904] = 82;
        byArray[905] = -103;
        byArray[906] = -21;
        byArray[907] = -72;
        byArray[908] = -104;
        byArray[909] = 96;
        byArray[910] = 28;
        byArray[911] = 6;
        byArray[912] = -110;
        byArray[913] = 21;
        byArray[914] = 90;
        byArray[915] = -82;
        byArray[916] = -128;
        byArray[917] = 45;
        byArray[918] = 44;
        byArray[919] = -13;
        byArray[920] = 103;
        byArray[921] = 77;
        byArray[922] = -33;
        byArray[923] = -36;
        byArray[924] = -107;
        byArray[925] = 20;
        byArray[926] = -78;
        byArray[927] = 95;
        byArray[928] = 67;
        byArray[929] = 64;
        byArray[930] = 78;
        byArray[931] = 97;
        byArray[932] = 32;
        byArray[933] = 119;
        byArray[934] = 105;
        byArray[935] = 51;
        byArray[936] = 19;
        byArray[937] = -71;
        byArray[938] = -53;
        byArray[939] = -87;
        byArray[940] = -63;
        byArray[941] = -11;
        byArray[942] = -74;
        byArray[943] = 35;
        byArray[944] = -100;
        byArray[945] = 9;
        byArray[946] = -111;
        byArray[947] = -9;
        byArray[948] = -84;
        byArray[949] = -3;
        byArray[950] = 123;
        byArray[951] = -93;
        byArray[952] = 70;
        byArray[953] = -61;
        byArray[954] = 2;
        byArray[955] = -127;
        byArray[956] = -128;
        byArray[957] = 62;
        byArray[958] = -22;
        byArray[959] = 119;
        byArray[960] = 117;
        byArray[961] = -71;
        byArray[962] = 63;
        byArray[963] = -124;
        byArray[964] = 38;
        byArray[965] = 43;
        byArray[966] = 30;
        byArray[967] = 123;
        byArray[968] = 96;
        byArray[969] = 73;
        byArray[970] = -123;
        byArray[971] = -15;
        byArray[972] = 29;
        byArray[973] = -128;
        byArray[974] = 107;
        byArray[975] = 86;
        byArray[976] = -77;
        byArray[977] = 59;
        byArray[978] = 99;
        byArray[979] = -26;
        byArray[980] = -83;
        byArray[981] = 48;
        byArray[982] = 42;
        byArray[983] = -106;
        byArray[984] = 35;
        byArray[985] = 98;
        byArray[986] = -61;
        byArray[987] = 92;
        byArray[988] = -36;
        byArray[989] = 95;
        byArray[990] = -53;
        byArray[991] = 5;
        byArray[992] = -85;
        byArray[993] = -22;
        byArray[994] = 61;
        byArray[995] = -8;
        byArray[996] = -3;
        byArray[997] = 122;
        byArray[998] = -43;
        byArray[999] = -20;
        byArray[1000] = -69;
        byArray[1001] = 119;
        byArray[1002] = -72;
        byArray[1003] = -42;
        byArray[1004] = -65;
        byArray[1005] = 87;
        byArray[1006] = 114;
        byArray[1007] = 48;
        byArray[1008] = 25;
        byArray[1009] = 68;
        byArray[1010] = -92;
        byArray[1011] = 46;
        byArray[1012] = 124;
        byArray[1013] = -10;
        byArray[1014] = -123;
        byArray[1015] = -74;
        byArray[1016] = -7;
        byArray[1017] = -106;
        byArray[1018] = 53;
        byArray[1019] = -1;
        byArray[1020] = -21;
        byArray[1021] = 100;
        byArray[1022] = 104;
        byArray[1023] = 63;
        byArray[1024] = 84;
        byArray[1025] = 112;
        byArray[1026] = -119;
        byArray[1027] = 5;
        byArray[1028] = -56;
        byArray[1029] = 12;
        byArray[1030] = 77;
        byArray[1031] = 24;
        byArray[1032] = -102;
        byArray[1033] = 20;
        byArray[1034] = 68;
        byArray[1035] = 125;
        byArray[1036] = -49;
        byArray[1037] = -51;
        byArray[1038] = 52;
        byArray[1039] = -1;
        byArray[1040] = 97;
        byArray[1041] = 79;
        byArray[1042] = 68;
        byArray[1043] = -41;
        byArray[1044] = 66;
        byArray[1045] = 42;
        byArray[1046] = -89;
        byArray[1047] = 126;
        byArray[1048] = -5;
        byArray[1049] = 10;
        byArray[1050] = -70;
        byArray[1051] = -120;
        byArray[1052] = -95;
        byArray[1053] = -113;
        byArray[1054] = -77;
        byArray[1055] = 93;
        byArray[1056] = -128;
        byArray[1057] = -109;
        byArray[1058] = 116;
        byArray[1059] = 127;
        byArray[1060] = 11;
        byArray[1061] = -57;
        byArray[1062] = -36;
        byArray[1063] = -111;
        byArray[1064] = -78;
        byArray[1065] = 108;
        byArray[1066] = 35;
        byArray[1067] = -89;
        byArray[1068] = 21;
        byArray[1069] = 88;
        byArray[1070] = -53;
        byArray[1071] = 32;
        byArray[1072] = -54;
        byArray[1073] = -30;
        byArray[1074] = -96;
        byArray[1075] = -73;
        byArray[1076] = -50;
        byArray[1077] = 61;
        byArray[1078] = -61;
        byArray[1079] = 20;
        byArray[1080] = 102;
        byArray[1081] = 57;
        byArray[1082] = 82;
        byArray[1083] = -18;
        byArray[1084] = -87;
        byArray[1085] = 2;
        byArray[1086] = -127;
        byArray[1087] = -127;
        byArray[1089] = -25;
        byArray[1090] = -64;
        byArray[1091] = 66;
        byArray[1092] = -72;
        byArray[1093] = 55;
        byArray[1094] = -41;
        byArray[1095] = 8;
        byArray[1096] = 87;
        byArray[1097] = 11;
        byArray[1098] = 96;
        byArray[1099] = 76;
        byArray[1100] = -63;
        byArray[1101] = 68;
        byArray[1102] = 12;
        byArray[1103] = 110;
        byArray[1104] = 72;
        byArray[1105] = -126;
        byArray[1106] = -123;
        byArray[1107] = -103;
        byArray[1108] = 12;
        byArray[1109] = 33;
        byArray[1110] = 49;
        byArray[1111] = 97;
        byArray[1112] = -62;
        byArray[1113] = 56;
        byArray[1114] = -5;
        byArray[1115] = 83;
        byArray[1116] = -25;
        byArray[1117] = -73;
        byArray[1118] = 96;
        byArray[1119] = -43;
        byArray[1120] = 85;
        byArray[1121] = 56;
        byArray[1123] = -75;
        byArray[1124] = 99;
        byArray[1125] = -93;
        byArray[1126] = -39;
        byArray[1127] = -120;
        byArray[1128] = 110;
        byArray[1129] = 88;
        byArray[1130] = 33;
        byArray[1131] = 21;
        byArray[1132] = 19;
        byArray[1133] = 45;
        byArray[1134] = -61;
        byArray[1135] = -81;
        byArray[1136] = -79;
        byArray[1137] = 5;
        byArray[1138] = 26;
        byArray[1139] = -123;
        byArray[1140] = 55;
        byArray[1141] = 12;
        byArray[1142] = 120;
        byArray[1143] = 5;
        byArray[1144] = -73;
        byArray[1145] = 91;
        byArray[1146] = 95;
        byArray[1147] = -28;
        byArray[1148] = -79;
        byArray[1149] = 99;
        byArray[1150] = 97;
        byArray[1151] = -56;
        byArray[1152] = 83;
        byArray[1153] = 84;
        byArray[1154] = 42;
        byArray[1155] = -2;
        byArray[1156] = 87;
        byArray[1157] = -68;
        byArray[1158] = 34;
        byArray[1159] = 77;
        byArray[1160] = 94;
        byArray[1161] = -54;
        byArray[1162] = 55;
        byArray[1163] = 69;
        byArray[1164] = -42;
        byArray[1165] = 13;
        byArray[1166] = 34;
        byArray[1167] = 41;
        byArray[1168] = 100;
        byArray[1169] = -60;
        byArray[1170] = 112;
        byArray[1171] = 25;
        byArray[1172] = -36;
        byArray[1173] = -51;
        byArray[1174] = 98;
        byArray[1175] = 69;
        byArray[1176] = 50;
        byArray[1177] = -77;
        byArray[1178] = 120;
        byArray[1179] = 19;
        byArray[1180] = -114;
        byArray[1181] = 86;
        byArray[1182] = 12;
        byArray[1183] = -73;
        byArray[1184] = -52;
        byArray[1185] = -60;
        byArray[1186] = -115;
        byArray[1187] = -44;
        byArray[1188] = -57;
        byArray[1189] = -73;
        byArray[1190] = -12;
        byArray[1191] = -20;
        byArray[1192] = -18;
        byArray[1193] = -71;
        byArray[1194] = -98;
        byArray[1195] = 123;
        byArray[1196] = 81;
        byArray[1197] = -29;
        byArray[1198] = -40;
        byArray[1199] = 82;
        byArray[1200] = 28;
        byArray[1201] = -60;
        byArray[1202] = -96;
        byArray[1203] = -40;
        byArray[1204] = -113;
        byArray[1205] = 51;
        byArray[1206] = -69;
        byArray[1207] = -69;
        byArray[1208] = -32;
        byArray[1209] = -8;
        byArray[1210] = 12;
        byArray[1211] = -81;
        byArray[1212] = 105;
        byArray[1213] = -67;
        byArray[1214] = -98;
        byArray[1215] = 61;
        byArray[1216] = 59;
        byte[] privateKeyBytes = byArray;
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyBytes);
        Cipher cipher = null;
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = kf.generatePrivate(spec);
            cipher = Cipher.getInstance("RSA");
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | NoSuchPaddingException exc) {
            logger.error("Cannot read private key", (Throwable)exc);
        }
        AUTH_DECRYPTOR = cipher;
    }

    public UserRestService() {
        super(User.class, (Comparable[])new User[0]);
    }

    @GET
    @Path(value="/request_login_token/domain={domain: .*}&login={login: .*}")
    @Produces(value={"application/json"})
    public LoginResponse requestLoginToken(@PathParam(value="domain") String domain, @PathParam(value="login") String login) {
        try (EntityManager em = null;){
            if (domain != null && domain.isBlank()) {
                domain = null;
            }
            if (".".equals(domain) && (domain = InetUtils.getDomainName()) == null) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.InternalError, "Cannot read domain name");
                return loginResponse;
            }
            em = Server.getEntityManagerFactory().createEntityManager();
            User user = UserRestService.getUser(em, domain, login);
            if (user == null) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.UserNotFound);
                return loginResponse;
            }
            if (!user.isActive()) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.UserInactive);
                return loginResponse;
            }
            LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.Success, AuthenticationDatabase.requestAuthorisation((User)user));
            return loginResponse;
        }
    }

    @GET
    @Path(value="/login/domain={domain: .*}&login={login: .*}&passphrase_encoded={passphrase_encoded}&passphrase={passphrase: .*}")
    @Produces(value={"application/json"})
    public LoginResponse login(@PathParam(value="domain") String domain, @PathParam(value="login") String login, @PathParam(value="passphrase_encoded") boolean encodedPassphrase, @PathParam(value="passphrase") String passphrase) {
        try (EntityManager em = null;){
            if (domain.isEmpty()) {
                domain = null;
            }
            if (".".equals(domain) && (domain = InetUtils.getDomainName()) == null) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.InternalError, "Cannot read domain name");
                return loginResponse;
            }
            em = Server.getEntityManagerFactory().createEntityManager();
            User user = UserRestService.getUser(em, domain, login);
            if (user == null) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.UserNotFound);
                return loginResponse;
            }
            boolean passwdCheck = false;
            String loginRequestStr = encodedPassphrase ? new String(AUTH_DECRYPTOR.doFinal(Base64.getDecoder().decode(passphrase)), StandardCharsets.UTF_8) : new String(Base64.getDecoder().decode(passphrase), StandardCharsets.UTF_8);
            LoginRequest loginRequest = LoginRequest.parse((String)loginRequestStr);
            String requestToken = AuthenticationDatabase.getRequestToken((User)user);
            if (!requestToken.equals(loginRequest.getToken())) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.InternalError, "Wrong request token!");
                return loginResponse;
            }
            if (user.getDomain() == null) {
                passwdCheck = user.getEncryptedPassword() == null && loginRequest.getPassword() == null ? true : (user.getEncryptedPassword() != null ? user.getEncryptedPassword().equals(PASSWORD_ENCRYPTOR.encryptPassword(loginRequest.getPassword())) : false);
            } else {
                try {
                    UserRestService.authenticate(user.getDomain(), user.getLogin(), loginRequest.getPassword());
                    passwdCheck = true;
                }
                catch (Exception exc) {
                    passwdCheck = false;
                    LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.InternalError, exc.getMessage());
                    em.close();
                    return loginResponse;
                }
            }
            if (!passwdCheck) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.WrongPassword);
                return loginResponse;
            }
            if (!user.isActive()) {
                LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.UserInactive);
                return loginResponse;
            }
            LoginResponse loginResponse = new LoginResponse(LoginResponse.LoginResponseType.Success, user.getLoginPhrase(), AuthenticationDatabase.autorise((User)user));
            return loginResponse;
        }
    }

    @Secured
    @GET
    @Path(value="/get")
    @Produces(value={"application/json"})
    public User get() throws Exception {
        return this.getUser();
    }

    @Secured
    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public User get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (User)this.getGeneric(trx, Integer.valueOf(id));
    }

    @Secured
    @POST
    @Path(value="/get/trx={trx}")
    @Produces(value={"application/json"})
    public User[] get(@PathParam(value="trx") int trx, int[] ids) {
        User[] users = new User[ids.length];
        int i = 0;
        while (i < ids.length) {
            users[i] = (User)this.getGeneric(trx, Integer.valueOf(ids[i]));
            ++i;
        }
        return users;
    }

    @Secured
    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public User[] getAll(@PathParam(value="trx") int trx) {
        User user = this.getUser();
        if (user.isAdmin()) {
            return (User[])this.getAllGeneric(trx);
        }
        return new User[]{user};
    }

    @POST
    @Path(value="/register/enc_passwd={enc_passwd: .*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult register(User user, @PathParam(value="enc_passwd") String encryptedPassword) {
        try (EntityManager em = null;){
            em = Server.getEntityManagerFactory().createEntityManager();
            em.getTransaction().begin();
            if (user.getDomain() != null && user.getDomain().isBlank()) {
                user.setDomain(null);
            }
            user.setActive(false);
            user.setAdmin(false);
            user.setEncryptedPassword(encryptedPassword);
            if ((Long)em.createQuery("SELECT COUNT(u) FROM User u", Long.class).getSingleResult() == 0L) {
                user.setActive(true);
                user.setAdmin(true);
            }
            if (UserRestService.getUser(em, user.getDomain(), user.getLogin()) != null) {
                OperationResult operationResult = new OperationResult(ResultType.ExpectedError, "Duplicate user credentials!");
                return operationResult;
            }
            em.persist((Object)user);
            em.getTransaction().commit();
            int fakeTrxId = (int)(Math.random() * 1000.0 * -1.0);
            TransactionChangeset.changedOrNew((int)fakeTrxId, (Object)user);
            TransactionChangeset.doPostCommitSync((int)fakeTrxId);
            OperationResult operationResult = new OperationResult((Serializable)user.getId(), ResultType.Success);
            return operationResult;
        }
    }

    @Secured
    @POST
    @Path(value="/create/trx={trx}&enc_passwd={enc_passwd: .*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult create(@PathParam(value="trx") int trx, User user, @PathParam(value="enc_passwd") String encryptedPassword) {
        try {
            user.setEncryptedPassword(encryptedPassword);
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (user.getDomain() != null && user.getDomain().isBlank()) {
                user.setDomain(null);
            }
            if ((Long)em.createQuery("SELECT COUNT(u) FROM User u", Long.class).getSingleResult() == 0L) {
                user.setActive(true);
                user.setAdmin(true);
            }
            if (UserRestService.getUser(em, user.getDomain(), user.getLogin()) != null) {
                return new OperationResult(ResultType.ExpectedError, "Duplicate user credentials!");
            }
            em.persist((Object)user);
            TransactionChangeset.changedOrNew((int)trx, (Object)user);
            return new OperationResult((Serializable)user.getId(), ResultType.Success);
        }
        catch (Exception exc) {
            Serializable id = this.getId(user);
            if (id == null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot create %s user", this.clazz.getSimpleName()), exc.toString());
            }
            return new OperationResult(id, ResultType.UnexprectedDbError, String.format("Cannot create %s user with id=%s", this.clazz.getSimpleName(), id.toString()), exc.toString());
        }
    }

    @Secured
    @POST
    @Path(value="/change_passwd/trx={trx}&domain={domain: .*}&login={login: .*}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public OperationResult changePassword(@PathParam(value="trx") int trx, @PathParam(value="domain") String domain, @PathParam(value="login") String login, @FormDataParam(value="old_enc_passwd") String oldEncryptedPassword, @FormDataParam(value="new_enc_passwd") String newEncryptedPassword) {
        try {
            if (domain.isBlank()) {
                domain = null;
            }
            if (".".equals(domain) && (domain = InetUtils.getDomainName()) == null) {
                return new OperationResult(ResultType.UnexprectedError, "Cannot read domain name");
            }
            User currentUser = this.getUser();
            if (!currentUser.isAdmin() && !currentUser.getLoginPhrase().equals(login)) {
                return new OperationResult(ResultType.AccessForbidden, "Current user have not enough rights to perform this operation");
            }
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            User user = UserRestService.getUser(em, domain, login);
            if (user == null) {
                return new OperationResult(ResultType.UnexprectedError, String.format("User with login %s not found", login));
            }
            if (user.getDomain() != null) {
                return new OperationResult(ResultType.AccessForbidden, "Current user have not enough rights to perform this operation");
            }
            if (!currentUser.isAdmin() && (oldEncryptedPassword != null && !oldEncryptedPassword.equals(user.getEncryptedPassword()) || user.getEncryptedPassword() != null && !user.getEncryptedPassword().equals(oldEncryptedPassword))) {
                return new OperationResult(ResultType.UnexprectedError, "Wrong current password!");
            }
            user.setEncryptedPassword(newEncryptedPassword);
            em.persist((Object)user);
            TransactionChangeset.changedOrNew((int)trx, (Object)user);
            return new OperationResult((Serializable)user.getId(), ResultType.Success);
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot change %s user password", login), exc.toString());
        }
    }

    @Secured
    @POST
    @Path(value="/update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult update(@PathParam(value="trx") int trx, User user) {
        try {
            User currentUser = this.getUser();
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            User savedUser = (User)em.find(User.class, (Object)user.getId());
            if (!currentUser.isAdmin() && !currentUser.equals((Object)savedUser)) {
                return new OperationResult(ResultType.AccessForbidden, "Current user have not enough rights to perform this operation");
            }
            user.setEncryptedPassword(savedUser.getEncryptedPassword());
            if (user.getDomain() != null && user.getDomain().isBlank()) {
                user.setDomain(null);
            }
            em.merge((Object)user);
            TransactionChangeset.changedOrNew((int)trx, (Object)user);
            return new OperationResult((Serializable)user.getId(), ResultType.Success);
        }
        catch (Exception exc) {
            Serializable id = this.getId(user);
            if (id == null) {
                return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot update %s user", this.clazz.getSimpleName()), exc.toString());
            }
            return new OperationResult(id, ResultType.UnexprectedDbError, String.format("Cannot update %s user with id=%s", this.clazz.getSimpleName(), id.toString()), exc.toString());
        }
    }

    @Secured
    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            User currentUser = this.getUser();
            if (currentUser.getId() == id) {
                return new OperationResult(ResultType.UnexprectedError, "User cannot detele itself");
            }
            if (!currentUser.isAdmin()) {
                return new OperationResult(ResultType.AccessForbidden, "Current user have not enough rights to perform this operation");
            }
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            User user = (User)em.find(User.class, (Object)id);
            em.createQuery("UPDATE PropertyValue pv SET pv.user = :current_user WHERE pv.user = :user").setParameter("current_user", (Object)currentUser).setParameter("user", (Object)user).executeUpdate();
            for (Chart2DViewPrefs c2dp : em.createQuery("SELECT o FROM Chart2DViewPrefs o WHERE o.user = :user", Chart2DViewPrefs.class).setParameter("user", (Object)user).getResultList()) {
                em.remove((Object)c2dp);
            }
            for (Chart3DViewPrefs c3dp : em.createQuery("SELECT o FROM Chart3DViewPrefs o WHERE o.user = :user", Chart3DViewPrefs.class).setParameter("user", (Object)user).getResultList()) {
                em.remove((Object)c3dp);
            }
            for (TableViewPrefs tvp : em.createQuery("SELECT o FROM TableViewPrefs o WHERE o.user = :user", TableViewPrefs.class).setParameter("user", (Object)user).getResultList()) {
                em.remove((Object)tvp);
            }
            em.createQuery("DELETE FROM UserContentViewPreference o WHERE o.user = :user").setParameter("user", (Object)user).executeUpdate();
            em.createQuery("DELETE FROM TimeRangeFilterPreference o WHERE o.user = :user").setParameter("user", (Object)user).executeUpdate();
            em.remove((Object)user);
            TransactionChangeset.removed((int)trx, (Object)user);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error deleting user", (Throwable)exc);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Error occured during user deletion", new Object[0]));
        }
    }

    @Override
    protected Serializable getId(User object) {
        return object.getId();
    }

    protected static User getUser(EntityManager em, String domain, String login) {
        if (domain == null) {
            return (User)em.createQuery("SELECT u FROM User u WHERE u.domain IS NULL AND u.login = :login", User.class).setParameter("login", (Object)login).getSingleResultOrNull();
        }
        return (User)em.createQuery("SELECT u FROM User u WHERE u.domain = :domain AND u.login = :login", User.class).setParameter("domain", (Object)domain).setParameter("login", (Object)login).getSingleResultOrNull();
    }

    private static Collection<InetSocketAddress> getDomainControllers(String domain) throws NamingException {
        String[] types = new String[]{"SRV"};
        InitialDirContext ctx = new InitialDirContext();
        Attributes attributes = ctx.getAttributes("dns:/_ldap._tcp.dc._msdcs." + domain, types);
        if (attributes.get("SRV") == null) {
            return Collections.emptyList();
        }
        NamingEnumeration<?> e = attributes.get("SRV").getAll();
        TreeMap<Integer, InetSocketAddress> result = new TreeMap<Integer, InetSocketAddress>();
        while (e.hasMoreElements()) {
            String line = (String)e.nextElement();
            String[] parts = line.split("\\s+");
            int prio = Integer.parseInt(parts[0]);
            int port = Integer.parseInt(parts[2]);
            String host = parts[3];
            result.put(prio, new InetSocketAddress(host, port));
        }
        return result.values();
    }

    private static void authenticate(String domainName, String username, String password) throws Exception {
        try {
            Collection<InetSocketAddress> result = UserRestService.getDomainControllers(domainName);
            if (result.isEmpty()) {
                throw new Exception("No domain controllers found for domain " + domainName);
            }
            String loginServer = result.iterator().next().getHostString();
            System.setProperty("java.security.krb5.realm", domainName.toUpperCase());
            System.setProperty("java.security.krb5.kdc", loginServer);
            LoginContext lc = new LoginContext("", null, new StaticCallbackHandler(username, password), new StaticConfiguration("com.sun.security.auth.module.Krb5LoginModule"));
            lc.login();
            lc.logout();
        }
        catch (LoginException le) {
            throw new Exception("Authentication failed: " + le.getMessage(), le);
        }
        catch (SecurityException se) {
            throw new Exception("Authentication failed: " + se.getMessage(), se);
        }
        catch (NamingException ne) {
            throw new Exception("Authentication failed: " + ne.getMessage(), ne);
        }
    }

    private static class StaticCallbackHandler
    implements CallbackHandler {
        private String username;
        private String password;

        public StaticCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            int i = 0;
            while (i < callbacks.length) {
                if (!(callbacks[i] instanceof TextOutputCallback)) {
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback nc = (NameCallback)NameCallback.class.cast(callbacks[i]);
                        nc.setName(this.username);
                    } else if (callbacks[i] instanceof PasswordCallback) {
                        PasswordCallback pc = (PasswordCallback)PasswordCallback.class.cast(callbacks[i]);
                        pc.setPassword(this.password.toCharArray());
                    } else {
                        throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                    }
                }
                ++i;
            }
        }
    }

    private static class StaticConfiguration
    extends Configuration {
        final AppConfigurationEntry staticConfigEntry;

        public StaticConfiguration(String loginModuleName) {
            HashMap options = new HashMap();
            this.staticConfigEntry = new AppConfigurationEntry(loginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return new AppConfigurationEntry[]{this.staticConfigEntry};
        }
    }
}

