/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.characteristics;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.model.Characteristic2DInstanceCurveChanges;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.ArrayList;
import java.util.Arrays;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="characteristic/2d_instance")
public class Characteristic2DInstanceRestService
extends AbstractRestService<Characteristic2DInstance> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Characteristic2DInstanceRestService.class.getName());
    public static final Characteristic2DInstanceRestService INSTANCE = new Characteristic2DInstanceRestService();

    public Characteristic2DInstanceRestService() {
        super(Characteristic2DInstance.class, (Comparable[])new Characteristic2DInstance[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Characteristic2DInstance get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return ORMCache.getCharacteristic2DInstance((int)id);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_c2d_instance'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}&c2d_id={c2d_id}")
    @Produces(value={"application/json"})
    public Characteristic2DInstance[] getAll(@PathParam(value="trx") int trx, @PathParam(value="c2d_id") int c2dId) {
        try {
            ArrayList<Characteristic2DInstance> instances = new ArrayList<Characteristic2DInstance>();
            for (Characteristic2DInstance inst : ORMCache.getCharacteristic2D((int)c2dId).getInstances()) {
                instances.add(ORMCache.getCharacteristic2DInstance((int)inst.getId()));
            }
            Object[] result = instances.toArray((Characteristic2DInstance[])this.emptyArray);
            Arrays.sort(result);
            return result;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_2dcharacteristics_instances'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get/trx={trx}&c2d_id={c2d_id}&object_id={object_id}")
    @Produces(value={"application/json"})
    public Characteristic2DInstance get(@PathParam(value="trx") int trx, @PathParam(value="c2d_id") int c2dId, @PathParam(value="object_id") int objectId) {
        try {
            for (Characteristic2DInstance inst : ORMCache.getCharacteristic2D((int)c2dId).getInstances()) {
                if (!inst.getStructureObject().getId().equals(objectId)) continue;
                return ORMCache.getCharacteristic2DInstance((int)inst.getId());
            }
            return null;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_2dcharacteristics_instances'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Characteristic2DInstance c2di) {
        OperationResult result = this.saveOrUpdateGeneric(trx, c2di);
        TransactionChangeset.changedOrNew((int)trx, (Object)c2di);
        return result;
    }

    @POST
    @Path(value="/apply_curve_changes/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult applyCurveChanges(Characteristic2DFunctionChange[] changes, @PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Characteristic2DInstance instance = (Characteristic2DInstance)em.find(Characteristic2DInstance.class, (Object)id);
            Characteristic2DFunctionChange[] characteristic2DFunctionChangeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                Characteristic2DFunctionChange change = characteristic2DFunctionChangeArray[n2];
                if (change.getFunction() == null || change.getFunction().isEmpty() || change.getNewBegin() == null) {
                    instance.removeFunction(change.getOldBegin());
                } else if (change.getOldBegin() == null) {
                    instance.putFunction(change.getNewBegin(), change.getFunction());
                } else {
                    if (!change.getOldBegin().equals(change.getNewBegin())) {
                        instance.removeFunction(change.getOldBegin());
                    }
                    instance.putFunction(change.getNewBegin(), change.getFunction());
                }
                ++n2;
            }
            OperationResult result = this.saveOrUpdateGeneric(trx, instance);
            if (result.getType() == ResultType.Success) {
                TransactionChangeset.changedOrNew((int)trx, (Object)new Characteristic2DInstanceCurveChanges(instance, changes));
            }
            return result;
        }
        catch (Exception exc) {
            logger.error("Error at 'applyCurveChanges'", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    protected Integer getId(Characteristic2DInstance object) {
        return object.getId();
    }
}

