/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.characteristics;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.charts.Characteristic2DSeries;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="characteristic/2d")
public class Characteristic2DRestService
extends AbstractRestService<Characteristic2D> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Characteristic2DRestService.class.getName());
    public static final Characteristic2DRestService INSTANCE = new Characteristic2DRestService();

    public Characteristic2DRestService() {
        super(Characteristic2D.class, (Comparable[])new Characteristic2D[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Characteristic2D get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return ORMCache.getCharacteristic2D((int)id);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_variable'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Characteristic2D[] getAll(@PathParam(value="trx") int trx) {
        try {
            return ORMCache.getCharacteristics2D();
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_2dcharacteristics'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Characteristic2D[] getByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId) {
        try {
            LinkedList<Characteristic2D> c2ds = new LinkedList<Characteristic2D>();
            Characteristic2D[] characteristic2DArray = ORMCache.getCharacteristics2D();
            int n = characteristic2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                Characteristic2D c2d = characteristic2DArray[n2];
                if (c2d.getStructureClass().getId().equals(classId)) {
                    c2ds.add(c2d);
                }
                ++n2;
            }
            Collections.sort(c2ds);
            return c2ds.toArray(new Characteristic2D[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_c2ds'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_available/trx={trx}&root_class_id={root_class_id}&input_pu={input_pu}&output_pu={output_pu}")
    @Produces(value={"application/json"})
    public Characteristic2D[] getAvailable(@PathParam(value="trx") int trx, @PathParam(value="root_class_id") int classId, @PathParam(value="input_pu") String inputPUKey, @PathParam(value="output_pu") String outputPUKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Set classes = ((StructureClass)em.find(StructureClass.class, (Object)classId)).getAllParentClasses();
            List c2ds = em.createQuery("SELECT o FROM Characteristic2D o WHERE o.structureClass in :classes AND inputPhysicalUnit = :input_pu AND outputPhysicalUnit = :output_pu", Characteristic2D.class).setParameter("classes", (Object)classes).setParameter("input_pu", (Object)PhysicalUnit.getPhysicalUnit((String)inputPUKey)).setParameter("output_pu", (Object)PhysicalUnit.getPhysicalUnit((String)outputPUKey)).getResultList();
            Collections.sort(c2ds);
            return c2ds.toArray(new Characteristic2D[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_c2ds'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Characteristic2D c2d) {
        boolean isNew;
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        boolean bl = isNew = this.getId(c2d) == null;
        if (!c2d.getRoleIds().isEmpty()) {
            TypedQuery rolesQuery;
            if (isNew) {
                rolesQuery = em.createQuery("SELECT v FROM Characteristic2D v WHERE EXISTS (SELECT role FROM v.roleIds role WHERE role IN :role_ids)", Characteristic2D.class);
            } else {
                rolesQuery = em.createQuery("SELECT v FROM Characteristic2D v WHERE v.id != :v_id AND EXISTS (SELECT role FROM v.roleIds role WHERE role IN :role_ids)", Characteristic2D.class);
                rolesQuery.setParameter("v_id", (Object)c2d.getId());
            }
            rolesQuery.setParameter("role_ids", (Object)c2d.getRoleIds());
            Iterator iterator = rolesQuery.getResultList().iterator();
            if (iterator.hasNext()) {
                Characteristic2D v = (Characteristic2D)iterator.next();
                return new OperationResult(ResultType.UnexprectedError, String.format("One of used roles is already assignet to '%s' characteristic 2D", v.toString()));
            }
        }
        if (isNew) {
            em.persist((Object)c2d);
        } else {
            c2d = (Characteristic2D)em.merge((Object)c2d);
        }
        TransactionChangeset.changedOrNew((int)trx, (Object)c2d);
        return new OperationResult((Serializable)c2d.getId(), ResultType.Success);
    }

    @GET
    @Path(value="/create_missing_instances/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult createMissingInstances(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Characteristic2D c2d = (Characteristic2D)this.getGeneric(trx, Integer.valueOf(id));
            Set existingInstances = c2d.getInstances();
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)c2d.getStructureClass().getId());
            Set allObjects = structureClass.getAllObjects();
            for (StructureObject object : allObjects) {
                boolean exists = false;
                for (Characteristic2DInstance existingInstance : existingInstances) {
                    if (!existingInstance.getStructureObject().equals((Object)object)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                Characteristic2DInstance newInstance = new Characteristic2DInstance();
                newInstance.setCharacteristic(c2d);
                newInstance.setStructureObject(object);
                em.persist((Object)newInstance);
                TransactionChangeset.changedOrNew((int)trx, (Object)newInstance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot create missing instances for object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Characteristic2D c2d = (Characteristic2D)em.find(Characteristic2D.class, (Object)id);
            for (Characteristic2DInstance c2di : c2d.getInstances()) {
                em.remove((Object)c2di);
            }
            for (Characteristic2DSeries c2ds : em.createQuery("SELECT o FROM Characteristic2DSeries o WHERE o.characteristic = :c2d", Characteristic2DSeries.class).setParameter("c2d", (Object)c2d).getResultList()) {
                c2ds.getChart().setCharacteristic2DSeries(null);
                em.merge((Object)c2ds.getChart());
                em.remove((Object)c2ds);
            }
            em.remove((Object)c2d);
            TransactionChangeset.removed((int)trx, (Object)c2d);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            logger.error(String.format("Error deleting characteristic2d with id %d", id), (Throwable)exc);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    protected Integer getId(Characteristic2D object) {
        return object.getId();
    }
}

