/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.characteristics;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.characteristic.Characteristic2DRole;
import de.elpro.ewms.core.characteristic.ICharacteristic2DRole;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.helpers.VariableRoleHelper;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.roles.Roles;
import java.util.Collections;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="characteristic/2d/role")
public class Characteristic2DRolesRestService
extends AuthenticatedRestService {
    public static final Logger logger = Activator.getLoggerFactory().createLogger(Characteristic2DRolesRestService.class.getName());

    @GET
    @Path(value="/get/id={id}")
    @Produces(value={"application/json"})
    public Characteristic2DRole get(@PathParam(value="id") String id) {
        return Characteristic2DRole.of((ICharacteristic2DRole)Roles.getCharacteristic2DRole((String)id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Characteristic2DRole[] getAll(@PathParam(value="trx") int trx) {
        return (Characteristic2DRole[])Roles.getAllCharacteristic2DRoles().stream().map(r -> Characteristic2DRole.of((ICharacteristic2DRole)r)).toArray(Characteristic2DRole[]::new);
    }

    @GET
    @Path(value="/get_all/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Characteristic2DRole[] getAll(@PathParam(value="trx") int trx, @PathParam(value="class_id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)id);
        LinkedList roles = new LinkedList();
        for (StructureClass pClass : structureClass.getAllParentClasses()) {
            for (String classRoleId : pClass.getRoleIds()) {
                IStructureClassRole classRole = Roles.getClassRole((String)classRoleId);
                if (classRole == null) continue;
                roles.addAll(Roles.getCharacteristic2DRoles((String)classRole.getId()));
            }
        }
        Collections.sort(roles, (r1, r2) -> r1.getName().compareTo(r2.getName()));
        return (Characteristic2DRole[])roles.stream().map(r -> Characteristic2DRole.of((ICharacteristic2DRole)r)).toArray(Characteristic2DRole[]::new);
    }

    @GET
    @Path(value="/get_all/trx={trx}&class_id={class_id}&input_pu_key={input_pu_key}&output_pu_key={output_pu_key}")
    @Produces(value={"application/json"})
    public Characteristic2DRole[] getAll(@PathParam(value="trx") int trx, @PathParam(value="class_id") int id, @PathParam(value="input_pu_key") String inputPhysicalUnitKey, @PathParam(value="output_pu_key") String outputPhysicalUnitKey) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)id);
        LinkedList<ICharacteristic2DRole> roles = new LinkedList<ICharacteristic2DRole>();
        for (StructureClass pClass : structureClass.getAllParentClasses()) {
            for (String classRoleId : pClass.getRoleIds()) {
                IStructureClassRole classRole = Roles.getClassRole((String)classRoleId);
                if (classRole == null) continue;
                for (ICharacteristic2DRole characteristic2DRole : Roles.getCharacteristic2DRoles((String)classRole.getId())) {
                    if (!characteristic2DRole.getInputPhysicalUnit().getKey().equals(inputPhysicalUnitKey) || !characteristic2DRole.getOutputPhysicalUnit().getKey().equals(outputPhysicalUnitKey)) continue;
                    roles.add(characteristic2DRole);
                }
            }
        }
        Collections.sort(roles, (r1, r2) -> r1.getName().compareTo(r2.getName()));
        return (Characteristic2DRole[])roles.stream().map(r -> Characteristic2DRole.of((ICharacteristic2DRole)r)).toArray(Characteristic2DRole[]::new);
    }

    @GET
    @Path(value="/get_characteristic_2d/trx={trx}&role_id={role_id}")
    @Produces(value={"application/json"})
    public Characteristic2D getCharacteristic2DByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getUniqueCharacteristic2DByRole((EntityManager)em, (String)roleId);
        }
        catch (Exception exc) {
            logger.error("Error at get_characteristic_2d", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_characteristic_2d_instance/trx={trx}&role_id={role_id}&obj_id={obj_id}")
    @Produces(value={"application/json"})
    public Characteristic2DInstance getCharacteristic2DInstanceByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_id") int objId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getCharacteristic2DInstance((EntityManager)em, (String)roleId, (StructureObject)new StructureObject(objId));
        }
        catch (Exception exc) {
            logger.error("Error at get_characteristic_2d_instance", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_characteristic_2d_instance/trx={trx}&role_id={role_id}&obj_key={obj_key}")
    @Produces(value={"application/json"})
    public Characteristic2DInstance getCharacteristic2DInstanceByRoleAndObjectKey(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_key") String objKey) {
        StructureObject object;
        EntityManager em;
        block3: {
            try {
                em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
                object = ORMCache.getStructureObject((String)objKey);
                if (object != null) break block3;
                return null;
            }
            catch (Exception exc) {
                logger.error("Error at get_characteristic_2d_instance", (Throwable)exc);
                return null;
            }
        }
        return VariableRoleHelper.getCharacteristic2DInstance((EntityManager)em, (String)roleId, (StructureObject)object);
    }
}

