/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.characteristics;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic3DFunctionChange;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.model.Characteristic3DInstanceFunctionChanges;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="characteristic/3d_instance")
public class Characteristic3DInstanceRestService
extends AbstractRestService<Characteristic3DInstance> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Characteristic3DInstanceRestService.class.getName());
    public static final Characteristic3DInstanceRestService INSTANCE = new Characteristic3DInstanceRestService();

    public Characteristic3DInstanceRestService() {
        super(Characteristic3DInstance.class, (Comparable[])new Characteristic3DInstance[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Characteristic3DInstance get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return ORMCache.getCharacteristic3DInstance((int)id);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_c3d_instance'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}&c3d_id={c3d_id}")
    @Produces(value={"application/json"})
    public Characteristic3DInstance[] getAll(@PathParam(value="trx") int trx, @PathParam(value="c3d_id") int c3dId) {
        try {
            ArrayList<Characteristic3DInstance> instances = new ArrayList<Characteristic3DInstance>();
            for (Characteristic3DInstance inst : ORMCache.getCharacteristic3D((int)c3dId).getInstances()) {
                instances.add(ORMCache.getCharacteristic3DInstance((int)inst.getId()));
            }
            return instances.toArray((Characteristic3DInstance[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_3dcharacteristics_instances'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get/trx={trx}&c3d_id={c3d_id}&object_id={object_id}")
    @Produces(value={"application/json"})
    public Characteristic3DInstance get(@PathParam(value="trx") int trx, @PathParam(value="c3d_id") int c3dId, @PathParam(value="object_id") int objectId) {
        try {
            for (Characteristic3DInstance inst : ORMCache.getCharacteristic3D((int)c3dId).getInstances()) {
                if (!inst.getStructureObject().getId().equals(objectId)) continue;
                return ORMCache.getCharacteristic3DInstance((int)inst.getId());
            }
            return null;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_3dcharacteristics_instances'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Characteristic3DInstance c3di) {
        OperationResult result = this.saveOrUpdateGeneric(trx, c3di);
        TransactionChangeset.changedOrNew((int)trx, (Object)c3di);
        return result;
    }

    @POST
    @Path(value="/apply_curve_changes/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult applyCurveChanges(Characteristic3DFunctionChange[] changes, @PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Characteristic3DInstance instance = (Characteristic3DInstance)em.find(Characteristic3DInstance.class, (Object)id);
            Characteristic3DFunctionChange[] characteristic3DFunctionChangeArray = changes;
            int n = changes.length;
            int n2 = 0;
            while (n2 < n) {
                Characteristic3DFunctionChange change = characteristic3DFunctionChangeArray[n2];
                if (change.getFunction() == null || change.getNewBegin() == null) {
                    instance.removeFunction(change.getOldBegin());
                } else if (change.getOldBegin() == null) {
                    instance.putFunction(change.getNewBegin(), change.getFunction());
                } else {
                    if (!change.getOldBegin().equals(change.getNewBegin())) {
                        instance.removeFunction(change.getOldBegin());
                    }
                    instance.putFunction(change.getNewBegin(), change.getFunction());
                }
                ++n2;
            }
            OperationResult result = this.saveOrUpdateGeneric(trx, instance);
            if (result.getType() == ResultType.Success) {
                TransactionChangeset.changedOrNew((int)trx, (Object)new Characteristic3DInstanceFunctionChanges(instance, changes));
            }
            return result;
        }
        catch (Exception exc) {
            logger.error("Error at 'applyCurveChanges'", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedError, exc.getMessage());
        }
    }

    protected Integer getId(Characteristic3DInstance object) {
        return object.getId();
    }
}

