/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.characteristics;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.charts.Characteristic3DSeries;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import de.elpro.ewms.server.transactions.TransactionChangeset;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="characteristic/3d")
public class Characteristic3DRestService
extends AbstractRestService<Characteristic3D> {
    private static final Logger logger = Activator.getLoggerFactory().createLogger(Characteristic3DRestService.class.getName());
    public static final Characteristic3DRestService INSTANCE = new Characteristic3DRestService();

    public Characteristic3DRestService() {
        super(Characteristic3D.class, (Comparable[])new Characteristic3D[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public Characteristic3D get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            return ORMCache.getCharacteristic3D((int)id);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_variable'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Characteristic3D[] getAll(@PathParam(value="trx") int trx) {
        try {
            return ORMCache.getCharacteristics3D();
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_3dcharacteristics'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Characteristic3D[] getByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId) {
        try {
            LinkedList<Characteristic3D> c3ds = new LinkedList<Characteristic3D>();
            Characteristic3D[] characteristic3DArray = ORMCache.getCharacteristics3D();
            int n = characteristic3DArray.length;
            int n2 = 0;
            while (n2 < n) {
                Characteristic3D c3d = characteristic3DArray[n2];
                if (c3d.getStructureClass().getId().equals(classId)) {
                    c3ds.add(c3d);
                }
                ++n2;
            }
            Collections.sort(c3ds);
            return c3ds.toArray(new Characteristic3D[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_c3ds'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_name/trx={trx}&var_name={var_name: .*}")
    @Produces(value={"application/json"})
    public Characteristic3D getByName(@PathParam(value="trx") int trx, @PathParam(value="var_name") String varName) {
        try {
            Characteristic3D var = ORMCache.getCharacteristic3D((String)varName);
            return var;
        }
        catch (Exception exc) {
            logger.error("Error at 'get_variable_by_name'", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_available/trx={trx}&root_class_id={root_class_id}&input_x_pu={input_x_pu}&input_y_pu={input_y_pu}&output_z_pu={output_z_pu}&output_w_pu={output_w_pu: .*}")
    @Produces(value={"application/json"})
    public Characteristic3D[] getAvailable(@PathParam(value="trx") int trx, @PathParam(value="root_class_id") int classId, @PathParam(value="input_x_pu") String inputXPUKey, @PathParam(value="input_y_pu") String inputYPUKey, @PathParam(value="output_z_pu") String outputZPUKey, @PathParam(value="output_w_pu") String outputWPUKey) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Set classes = ((StructureClass)em.find(StructureClass.class, (Object)classId)).getAllParentClasses();
            PhysicalUnit puX = PhysicalUnit.getPhysicalUnit((String)inputXPUKey);
            PhysicalUnit puY = PhysicalUnit.getPhysicalUnit((String)inputYPUKey);
            PhysicalUnit puZ = PhysicalUnit.getPhysicalUnit((String)outputZPUKey);
            PhysicalUnit puW = outputWPUKey != null && !outputWPUKey.isBlank() ? PhysicalUnit.getPhysicalUnit((String)outputWPUKey) : null;
            List c3ds = puW != null ? em.createQuery("SELECT o FROM Characteristic3D o WHERE o.structureClass in :classes AND inputXAxisPhysicalUnit = :input_x_pu AND inputYAxisPhysicalUnit = :input_y_pu AND outputZAxisPhysicalUnit = :output_z_pu AND outputWAxisPhysicalUnit = :output_w_pu", Characteristic3D.class).setParameter("classes", (Object)classes).setParameter("input_x_pu", (Object)puX).setParameter("input_y_pu", (Object)puY).setParameter("output_z_pu", (Object)puZ).setParameter("output_w_pu", (Object)puW).getResultList() : em.createQuery("SELECT o FROM Characteristic3D o WHERE o.structureClass in :classes AND inputXAxisPhysicalUnit = :input_x_pu AND inputYAxisPhysicalUnit = :input_y_pu AND outputZAxisPhysicalUnit = :output_z_pu AND outputWAxisPhysicalUnit IS NULL", Characteristic3D.class).setParameter("classes", (Object)classes).setParameter("input_x_pu", (Object)puX).setParameter("input_y_pu", (Object)puY).setParameter("output_z_pu", (Object)puZ).getResultList();
            Collections.sort(c3ds);
            return c3ds.toArray(new Characteristic3D[0]);
        }
        catch (Exception exc) {
            logger.error("Error at 'get_all_c3ds'", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Characteristic3D c3d) {
        OperationResult result = this.saveOrUpdateGeneric(trx, c3d);
        TransactionChangeset.changedOrNew((int)trx, (Object)c3d);
        return result;
    }

    @GET
    @Path(value="/create_missing_instances/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult createMissingInstances(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Characteristic3D c3d = (Characteristic3D)this.getGeneric(trx, Integer.valueOf(id));
            Set existingInstances = c3d.getInstances();
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)c3d.getStructureClass().getId());
            Set allObjects = structureClass.getAllObjects();
            for (StructureObject object : allObjects) {
                boolean exists = false;
                for (Characteristic3DInstance existingInstance : existingInstances) {
                    if (!existingInstance.getStructureObject().equals((Object)object)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                Characteristic3DInstance newInstance = new Characteristic3DInstance();
                newInstance.setCharacteristic(c3d);
                newInstance.setStructureObject(object);
                em.persist((Object)newInstance);
                TransactionChangeset.changedOrNew((int)trx, (Object)newInstance);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot create missing instances for object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        if (!this.getUser().isAdmin()) {
            return OperationResult.ACCESS_DENIED;
        }
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Characteristic3D c3d = (Characteristic3D)em.find(Characteristic3D.class, (Object)id);
            for (Characteristic3DInstance c3di : c3d.getInstances()) {
                em.remove((Object)c3di);
            }
            for (Characteristic3DSeries c3ds : em.createQuery("SELECT o FROM Characteristic3DSeries o WHERE o.characteristic = :c3d", Characteristic3DSeries.class).setParameter("c3d", (Object)c3d).getResultList()) {
                c3ds.getChart().setCharacteristic3DSeries(null);
                em.merge((Object)c3ds.getChart());
                em.remove((Object)c3ds);
            }
            em.remove((Object)c3d);
            TransactionChangeset.removed((int)trx, (Object)c3d);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.Success);
        }
        catch (Exception exc) {
            logger.error(String.format("Error deleting characteristic3d with id %d", id), (Throwable)exc);
            return new OperationResult((Serializable)Integer.valueOf(id), ResultType.UnexprectedDbError, String.format("Cannot delete %s object with id=%s", this.clazz.getSimpleName(), id), exc.toString());
        }
    }

    protected Integer getId(Characteristic3D object) {
        return object.getId();
    }
}

