/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.characteristics;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.characteristic.Characteristic3D;
import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.characteristic.Characteristic3DRole;
import de.elpro.ewms.core.characteristic.ICharacteristic3DRole;
import de.elpro.ewms.core.structure.IStructureClassRole;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.server.cache.ORMCache;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.helpers.VariableRoleHelper;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.roles.Roles;
import java.util.Collections;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="characteristic/3d/role")
public class Characteristic3DRolesRestService
extends AuthenticatedRestService {
    public static final Logger logger = Activator.getLoggerFactory().createLogger(Characteristic3DRolesRestService.class.getName());

    @GET
    @Path(value="/get/id={id}")
    @Produces(value={"application/json"})
    public Characteristic3DRole get(@PathParam(value="id") String id) {
        return Characteristic3DRole.of((ICharacteristic3DRole)Roles.getCharacteristic3DRole((String)id));
    }

    @GET
    @Path(value="/get_all/trx={trx}")
    @Produces(value={"application/json"})
    public Characteristic3DRole[] getAll(@PathParam(value="trx") int trx) {
        return (Characteristic3DRole[])Roles.getAllCharacteristic3DRoles().stream().map(r -> Characteristic3DRole.of((ICharacteristic3DRole)r)).toArray(Characteristic3DRole[]::new);
    }

    @GET
    @Path(value="/get_all/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public Characteristic3DRole[] getAll(@PathParam(value="trx") int trx, @PathParam(value="class_id") int id) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)id);
        LinkedList roles = new LinkedList();
        for (StructureClass pClass : structureClass.getAllParentClasses()) {
            for (String classRoleId : pClass.getRoleIds()) {
                IStructureClassRole classRole = Roles.getClassRole((String)classRoleId);
                if (classRole == null) continue;
                roles.addAll(Roles.getCharacteristic3DRoles((String)classRole.getId()));
            }
        }
        Collections.sort(roles, (r1, r2) -> r1.getName().compareTo(r2.getName()));
        return (Characteristic3DRole[])roles.stream().map(r -> Characteristic3DRole.of((ICharacteristic3DRole)r)).toArray(Characteristic3DRole[]::new);
    }

    @GET
    @Path(value="/get_all/trx={trx}&class_id={class_id}&input_x_axis_pu_key={input_x_axis_pu_key}&input_y_axis_pu_key={input_y_axis_pu_key}&output_z_axis_pu_key={output_z_axis_pu_key}&output_w_axis_pu_key={output_w_axis_pu_key: .*}")
    @Produces(value={"application/json"})
    public Characteristic3DRole[] getAll(@PathParam(value="trx") int trx, @PathParam(value="class_id") int id, @PathParam(value="input_x_axis_pu_key") String inputXAxisPhysicalUnitKey, @PathParam(value="input_y_axis_pu_key") String inputYAxisPhysicalUnitKey, @PathParam(value="output_z_axis_pu_key") String outputZAxisPhysicalUnitKey, @PathParam(value="output_w_axis_pu_key") String outputWAxisPhysicalUnitKey) {
        EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
        StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)id);
        LinkedList<ICharacteristic3DRole> roles = new LinkedList<ICharacteristic3DRole>();
        for (StructureClass pClass : structureClass.getAllParentClasses()) {
            for (String classRoleId : pClass.getRoleIds()) {
                IStructureClassRole classRole = Roles.getClassRole((String)classRoleId);
                if (classRole == null) continue;
                for (ICharacteristic3DRole characteristic3DRole : Roles.getCharacteristic3DRoles((String)classRole.getId())) {
                    if (!characteristic3DRole.getInputXAxisPhysicalUnit().getKey().equals(inputXAxisPhysicalUnitKey) || !characteristic3DRole.getInputYAxisPhysicalUnit().getKey().equals(inputYAxisPhysicalUnitKey) || !characteristic3DRole.getOutputZAxisPhysicalUnit().getKey().equals(outputZAxisPhysicalUnitKey) || !(outputWAxisPhysicalUnitKey != null && !outputWAxisPhysicalUnitKey.isBlank() ? characteristic3DRole.getOutputWAxisPhysicalUnit().getKey().equals(outputWAxisPhysicalUnitKey) : characteristic3DRole.getOutputWAxisPhysicalUnit() == null)) continue;
                    roles.add(characteristic3DRole);
                }
            }
        }
        Collections.sort(roles, (r1, r2) -> r1.getName().compareTo(r2.getName()));
        return (Characteristic3DRole[])roles.stream().map(r -> Characteristic3DRole.of((ICharacteristic3DRole)r)).toArray(Characteristic3DRole[]::new);
    }

    @GET
    @Path(value="/get_characteristic_3d/trx={trx}&role_id={role_id}")
    @Produces(value={"application/json"})
    public Characteristic3D getCharacteristic3DByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getUniqueCharacteristic3DByRole((EntityManager)em, (String)roleId);
        }
        catch (Exception exc) {
            logger.error("Error at get_characteristic_3d", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_characteristic_3d_instance/trx={trx}&role_id={role_id}&obj_id={obj_id}")
    @Produces(value={"application/json"})
    public Characteristic3DInstance getCharacteristic3DInstanceByRole(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_id") int objId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return VariableRoleHelper.getCharacteristic3DInstance((EntityManager)em, (String)roleId, (StructureObject)new StructureObject(objId));
        }
        catch (Exception exc) {
            logger.error("Error at get_characteristic_3d_instance", (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_characteristic_3d_instance/trx={trx}&role_id={role_id}&obj_key={obj_key}")
    @Produces(value={"application/json"})
    public Characteristic3DInstance getCharacteristic3DInstanceByRoleAndObjectKey(@PathParam(value="trx") int trx, @PathParam(value="role_id") String roleId, @PathParam(value="obj_key") String objKey) {
        StructureObject object;
        EntityManager em;
        block3: {
            try {
                em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
                object = ORMCache.getStructureObject((String)objKey);
                if (object != null) break block3;
                return null;
            }
            catch (Exception exc) {
                logger.error("Error at get_characteristic_3d_instance", (Throwable)exc);
                return null;
            }
        }
        return VariableRoleHelper.getCharacteristic3DInstance((EntityManager)em, (String)roleId, (StructureObject)object);
    }
}

