/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.Characteristic3DSeries;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.auth.AuthenticatedRestService;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/characteristic3d_series")
public class Characteristic3DSeriesRestService
extends AuthenticatedRestService {
    private static Logger logger = Activator.getLoggerFactory().createLogger(Characteristic3DSeriesRestService.class.getName());

    @GET
    @Path(value="/get_by_chart/trx={trx}&chart_id={chart_id}")
    @Produces(value={"application/json"})
    public Characteristic3DSeries getByChart(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chartId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            return (Characteristic3DSeries)em.createQuery("SELECT o FROM Characteristic3DSeries o WHERE o.chart = :chart", Characteristic3DSeries.class).setParameter("chart", (Object)new Chart3D(chartId)).getSingleResultOrNull();
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by Chart %s'", Characteristic3DSeries.class.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Characteristic3DSeries varSeries) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (varSeries.getId() == null) {
                em.persist((Object)varSeries);
            } else {
                em.merge((Object)varSeries);
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot save %s object", Characteristic3DSeries.class.getSimpleName()), exc.toString());
        }
    }

    @GET
    @Path(value="/delete/trx={trx}&chart_id={chart_id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chartId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            Chart3D chart = (Chart3D)em.find(Chart3D.class, (Object)chartId);
            Characteristic3DSeries c3d = chart.getCharacteristic3DSeries();
            chart.setCharacteristic3DSeries(null);
            em.merge((Object)chart);
            em.remove((Object)c3d);
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            return new OperationResult(ResultType.UnexprectedDbError, String.format("Cannot delete %s object", Characteristic3DSeries.class.getSimpleName()), exc.toString());
        }
    }
}

