/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.viewprefs.Chart3DViewPrefs;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.db.ResultType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/chart3d_view_prefs")
public class Chart3DViewPrefsRestService
extends AbstractRestService<Chart3DViewPrefs> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(Chart3DViewPrefsRestService.class.getName());

    public Chart3DViewPrefsRestService() {
        super(Chart3DViewPrefs.class, (Comparable[])new Chart3DViewPrefs[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&chart_id={chart_id}&object_id={object_id: [^/]*}")
    @Produces(value={"application/json"})
    public Chart3DViewPrefs get(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chart_id, @PathParam(value="object_id") Integer structure_object_id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (structure_object_id != null) {
                return (Chart3DViewPrefs)em.createQuery("SELECT o FROM Chart3DViewPrefs o WHERE o.chart = :chart AND o.user = :user AND o.structureObject = :object", Chart3DViewPrefs.class).setParameter("chart", (Object)new Chart3D(chart_id)).setParameter("user", (Object)this.getUser()).setParameter("object", (Object)new StructureObject(structure_object_id.intValue())).getSingleResultOrNull();
            }
            return (Chart3DViewPrefs)em.createQuery("SELECT o FROM Chart3DViewPrefs o WHERE o.chart = :chart AND o.user = :user AND o.structureObject IS NULL", Chart3DViewPrefs.class).setParameter("chart", (Object)new Chart3D(chart_id)).setParameter("user", (Object)this.getUser()).getSingleResultOrNull();
        }
        catch (Exception exc) {
            logger.error("Error reading Chart3DViewPrefs", (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, Chart3DViewPrefs chartViewPrefs) {
        chartViewPrefs.setUser(this.getUser());
        return this.saveOrUpdateGeneric(trx, chartViewPrefs);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/delete/trx={trx}&chart_id={chart_id}&object_id={object_id: [^/]*}")
    @Produces(value={"application/json"})
    public OperationResult deleteByChart(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chart_id, @PathParam(value="object_id") Integer structure_object_id) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            if (structure_object_id != null) {
                em.createQuery("SELECT o FROM Chart3DViewPrefs o WHERE o.chart = :chart AND o.user = :user AND o.structureObject = :object", Chart3DViewPrefs.class).setParameter("chart", (Object)new Chart3D(chart_id)).setParameter("user", (Object)this.getUser()).setParameter("object", (Object)new StructureObject(structure_object_id.intValue())).getResultList().forEach(o -> em.remove(o));
            } else {
                em.createQuery("SELECT o FROM Chart3DViewPrefs o WHERE o.chart = :chart AND o.user = :user", Chart3DViewPrefs.class).setParameter("chart", (Object)new Chart3D(chart_id)).setParameter("user", (Object)this.getUser()).getResultList().forEach(o -> em.remove(o));
            }
            return OperationResult.SUCCESS;
        }
        catch (Exception exc) {
            logger.error("Error deleting Chart3DViewPrefs", (Throwable)exc);
            return new OperationResult(ResultType.UnexprectedDbError, exc.getMessage());
        }
    }

    @Override
    protected Serializable getId(Chart3DViewPrefs object) {
        return object.getId();
    }
}

