/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/sankey_chart")
public class SankeyChartRestService
extends AbstractRestService<SankeyChart> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(SankeyChartRestService.class.getName());

    public SankeyChartRestService() {
        super(SankeyChart.class, (Comparable[])new SankeyChart[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public SankeyChart get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (SankeyChart)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_ungrouped/trx={trx}")
    @Produces(value={"application/json"})
    public SankeyChart[] getUngrouped(@PathParam(value="trx") int trx) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM SankeyChart o WHERE o.chartGroup IS NULL", SankeyChart.class).getResultList();
            Collections.sort(values);
            return values.toArray((SankeyChart[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get ungrouped %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_group/trx={trx}&group_id={group_id}")
    @Produces(value={"application/json"})
    public SankeyChart[] getByGroup(@PathParam(value="trx") int trx, @PathParam(value="group_id") int groupId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM SankeyChart o WHERE o.chartGroup = :cg", SankeyChart.class).setParameter("cg", (Object)new ChartGroup(groupId)).getResultList();
            Collections.sort(values);
            return values.toArray((SankeyChart[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by group %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/find_by_class/trx={trx}&class_id={class_id}")
    @Produces(value={"application/json"})
    public SankeyChart[] findByClass(@PathParam(value="trx") int trx, @PathParam(value="class_id") int classId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            StructureClass structureClass = (StructureClass)em.find(StructureClass.class, (Object)classId);
            Set allParentClasses = structureClass.getAllParentClasses();
            List values = em.createQuery("SELECT o FROM SankeyChart o WHERE o.structureClass IN :parent_classes", SankeyChart.class).setParameter("parent_classes", (Object)allParentClasses).getResultList();
            Collections.sort(values);
            return values.toArray((SankeyChart[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by class %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, SankeyChart chart) {
        return this.saveOrUpdateGeneric(trx, chart);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(SankeyChart object) {
        return object.getId();
    }
}

