/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.server.http.rest.charts;

import de.elpro.ewms.core.auth.Secured;
import de.elpro.ewms.core.auth.User;
import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.db.OperationResult;
import de.elpro.ewms.server.db.appconfig.EntityManagerPool;
import de.elpro.ewms.server.http.rest.bundle.Activator;
import de.elpro.ewms.server.http.rest.model.AbstractRestService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.persistence.EntityManager;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.eclipse.fx.core.log.Logger;

@Secured
@Path(value="charts/sankey_node")
public class SankeyNodeRestService
extends AbstractRestService<SankeyNode> {
    private static Logger logger = Activator.getLoggerFactory().createLogger(SankeyNodeRestService.class.getName());

    public SankeyNodeRestService() {
        super(SankeyNode.class, (Comparable[])new SankeyNode[0]);
    }

    @GET
    @Path(value="/get/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public SankeyNode get(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return (SankeyNode)this.getGeneric(trx, Integer.valueOf(id));
    }

    @GET
    @Path(value="/get_by_chart/trx={trx}&chart_id={chart_id}")
    @Produces(value={"application/json"})
    public SankeyNode[] getAll(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chartId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM SankeyNode o WHERE o.chart = :chart", SankeyNode.class).setParameter("chart", (Object)new SankeyChart(chartId)).getResultList();
            Collections.sort(values);
            return values.toArray((SankeyNode[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by chart %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_by_parent_node/trx={trx}&node_id={node_id}")
    @Produces(value={"application/json"})
    public SankeyNode[] getChildNodes(@PathParam(value="trx") int trx, @PathParam(value="node_id") int nodeId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM SankeyNode o WHERE o.parentNode = :pn", SankeyNode.class).setParameter("pn", (Object)new SankeyNode(nodeId)).getResultList();
            Collections.sort(values);
            return values.toArray((SankeyNode[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by parentNode %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @GET
    @Path(value="/get_root_nodes/trx={trx}&chart_id={chart_id}")
    @Produces(value={"application/json"})
    public SankeyNode[] getRootNodes(@PathParam(value="trx") int trx, @PathParam(value="chart_id") int chartId) {
        try {
            EntityManager em = EntityManagerPool.getEntityManager((int)trx, (User)this.getUser());
            List values = em.createQuery("SELECT o FROM SankeyNode o WHERE o.chart = :chart AND o.parentNode IS NULL", SankeyNode.class).setParameter("chart", (Object)new SankeyChart(chartId)).getResultList();
            Collections.sort(values);
            return values.toArray((SankeyNode[])this.emptyArray);
        }
        catch (Exception exc) {
            logger.error(String.format("Error at 'get by chart %s'", this.clazz.getSimpleName()), (Throwable)exc);
            return null;
        }
    }

    @POST
    @Path(value="/save_or_update/trx={trx}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public OperationResult saveOrUpdate(@PathParam(value="trx") int trx, SankeyNode node) {
        return this.saveOrUpdateGeneric(trx, node);
    }

    @GET
    @Path(value="/delete/trx={trx}&id={id}")
    @Produces(value={"application/json"})
    public OperationResult delete(@PathParam(value="trx") int trx, @PathParam(value="id") int id) {
        return this.deleteGeneric(trx, Integer.valueOf(id));
    }

    @Override
    protected Serializable getId(SankeyNode object) {
        return object.getId();
    }
}

